/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import junit.framework.TestCase;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.net.connection.Connection;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.DummySocketFacade;

public class QueryResponseMsgTest
extends TestCase {
    private PhexSecurityManager securityService;

    public QueryResponseMsgTest(String string) {
        super(string);
    }

    protected void setUp() {
        this.securityService = new PhexSecurityManager();
    }

    protected void tearDown() {
    }

    public void testCreateAndParse() throws Exception {
        MsgHeader msgHeader = new MsgHeader(new GUID(), -127, 7, 0, 0);
        QueryResponseRecord queryResponseRecord = new QueryResponseRecord(1, new URN("urn:sha1:LO4DP3SD3I3CZZP6PIKG3VCQHG4KTQD2"), 1, "file", -1L, null);
        QueryResponseRecord[] queryResponseRecordArray = new QueryResponseRecord[]{queryResponseRecord};
        QueryResponseMsg queryResponseMsg = new QueryResponseMsg(msgHeader, new GUID(), new DefaultDestAddress("111.111.111.111", 1111), 0, queryResponseRecordArray, null, true, false);
        ByteBuffer byteBuffer = queryResponseMsg.createHeaderBuffer();
        ByteBuffer byteBuffer2 = queryResponseMsg.createMessageBuffer();
        int n = byteBuffer.remaining() + byteBuffer2.remaining();
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(n);
        byteBuffer3.put(byteBuffer).put(byteBuffer2);
        byte[] byArray = byteBuffer3.array();
        DummySocketFacade dummySocketFacade = new DummySocketFacade(byArray);
        Connection connection = new Connection(dummySocketFacade, new BandwidthController("JUnitText", Long.MAX_VALUE));
        QueryResponseMsg queryResponseMsg2 = (QueryResponseMsg)MessageProcessor.parseMessage(connection, this.securityService);
        MsgHeader msgHeader2 = queryResponseMsg2.getHeader();
        QueryResponseMsgTest.assertEquals((int)msgHeader.getDataLength(), (int)msgHeader2.getDataLength());
        QueryResponseMsgTest.assertEquals((byte)msgHeader.getHopsTaken(), (byte)msgHeader2.getHopsTaken());
        QueryResponseMsgTest.assertEquals((String)msgHeader.getMsgID().toHexString(), (String)msgHeader2.getMsgID().toHexString());
        QueryResponseMsgTest.assertEquals((byte)msgHeader.getPayload(), (byte)msgHeader2.getPayload());
        QueryResponseMsgTest.assertEquals((byte)msgHeader.getTTL(), (byte)msgHeader2.getTTL());
        QueryResponseMsgTest.assertEquals((Object)queryResponseMsg.getDestAddress(), (Object)queryResponseMsg2.getDestAddress());
        QueryResponseMsgTest.assertEquals((short)queryResponseMsg.getRecordCount(), (short)queryResponseMsg2.getRecordCount());
        QueryResponseMsgTest.assertEquals((Object)queryResponseMsg.getRemoteServentID(), (Object)queryResponseMsg2.getRemoteServentID());
        QueryResponseMsgTest.assertEquals((int)queryResponseMsg.getRemoteHostSpeed(), (int)queryResponseMsg2.getRemoteHostSpeed());
        QueryResponseMsgTest.assertEquals((short)queryResponseMsg.getUploadSpeedFlag(), (short)queryResponseMsg2.getUploadSpeedFlag());
        QueryResponseMsgTest.assertEquals((short)queryResponseMsg.getPushNeededFlag(), (short)queryResponseMsg2.getPushNeededFlag());
        QueryResponseMsgTest.assertEquals((boolean)LibraryPrefs.AllowBrowsing.get(), (boolean)queryResponseMsg2.isBrowseHostSupported());
        QueryResponseMsgTest.assertEquals((short)-1, (short)queryResponseMsg2.getHasUploadedFlag());
        QueryResponseMsgTest.assertEquals((String)"PHEX", (String)queryResponseMsg2.getVendorCode());
        QueryResponseMsgTest.assertEquals((boolean)true, (boolean)queryResponseMsg2.isChatSupported());
        QueryResponseMsgTest.assertEquals((boolean)NetworkPrefs.AllowChatConnection.get(), (boolean)queryResponseMsg2.isChatSupported());
        QueryResponseMsgTest.assertEquals((short)(Servent.getInstance().isUploadLimitReached() ? (short)1 : 0), (short)queryResponseMsg2.getServerBusyFlag());
    }
}

