/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseRecord;
import phex.net.repres.PresentationManager;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.query.QHDConstants;
import phex.security.PhexSecurityManager;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.xml.XMLUtils;

public class QueryResponseMsg
extends Message
implements QHDConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_SUPPORTED_MASK = 1;
    private final PhexSecurityManager securityService;
    private byte[] body;
    private short uniqueResultCount;
    private QueryResponseRecord[] records;
    private DestAddress destAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private DestAddress[] pushProxyAddresses;
    private boolean isParsed;
    private static int REC_COUNT_LENGTH = 1;
    private static int I2P_DEST_LENGTH = 516;
    private static int NULL_TERM_LENGTH = 1;
    private static int SPEED_LENGTH = 4;

    public QueryResponseMsg(MsgHeader header, GUID clientID, DestAddress aHostAddress, int speed, QueryResponseRecord[] records, DestAddress[] pushProxyAddresses, boolean hasConnectedIncoming, boolean isHostBusyUploading) {
        super(header);
        if (records.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + records.length);
        }
        this.getHeader().setPayloadType((byte)-127);
        this.remoteClientID = clientID;
        this.destAddress = aHostAddress;
        this.records = records;
        this.pushProxyAddresses = pushProxyAddresses;
        boolean isPushNeeded = false;
        boolean isServerBusy = isHostBusyUploading;
        try {
            this.buildBody(speed, isPushNeeded, isServerBusy);
        }
        catch (IOException e) {
            NLogger.error(QueryResponseMsg.class, (Object)e, (Throwable)e);
        }
        this.getHeader().setDataLength(this.body.length);
        this.isParsed = true;
        this.securityService = null;
    }

    public QueryResponseMsg(MsgHeader header, byte[] aBody, PhexSecurityManager securityService) throws InvalidMessageException {
        super(header);
        if (header.getPayload() != -127) {
            throw new IllegalArgumentException("Invalid message type: " + header.getPayload());
        }
        this.securityService = securityService;
        this.body = aBody;
        header.setDataLength(this.body.length);
        StringBuffer buffer = new StringBuffer();
        int offset = IOUtil.deserializeString(this.body, 1, buffer);
        ++offset;
        try {
            this.destAddress = PresentationManager.getInstance().createHostAddress(buffer.toString(), -1);
        }
        catch (MalformedDestAddressException e) {
            throw new InvalidMessageException("Malformed destination key!");
        }
        if (!this.destAddress.isValidAddress()) {
            throw new InvalidMessageException("Invalid address: " + this.destAddress);
        }
        this.isParsed = false;
    }

    private void buildBody(int speed, boolean isPushNeeded, boolean isServerBusy) throws IOException {
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        int recordCount = this.records.length;
        bodyStream.write((byte)recordCount);
        byte[] destbody = new byte[I2P_DEST_LENGTH + NULL_TERM_LENGTH];
        int offset = IOUtil.serializeString(this.destAddress.getFullHostName(), destbody, 0);
        destbody[offset++] = 0;
        bodyStream.write(destbody);
        IOUtil.serializeIntLE(speed, bodyStream);
        for (int i = 0; i < recordCount; ++i) {
            this.records[i].write(bodyStream);
        }
        bodyStream.write(80);
        bodyStream.write(72);
        bodyStream.write(69);
        bodyStream.write(88);
        bodyStream.write(2);
        int isPushNeededByte = 0;
        if (isPushNeeded) {
            isPushNeededByte = 1;
        }
        int isServerBusyByte = 0;
        if (isServerBusy) {
            isServerBusyByte = 4;
        }
        int isGGEPUsedByte = 0;
        if (LibraryPrefs.AllowBrowsing.get().booleanValue() || this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
            isGGEPUsedByte = 32;
        }
        bodyStream.write((byte)(isPushNeededByte | 4 | 0 | 0x10 | 0x20));
        bodyStream.write((byte)(1 | isServerBusyByte | 0 | 0 | isGGEPUsedByte));
        if (NetworkPrefs.AllowChatConnection.get().booleanValue()) {
            bodyStream.write(1);
        } else {
            bodyStream.write(0);
        }
        this.remoteClientID.write(bodyStream);
        this.body = bodyStream.toByteArray();
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public short getUniqueResultCount() throws InvalidMessageException {
        this.parseBody();
        return this.uniqueResultCount;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public int getRemoteHostSpeed() {
        long speed = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 7));
        return IOUtil.castLong2Int(speed);
    }

    public String getVendorCode() throws InvalidMessageException {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() throws InvalidMessageException {
        this.parseBody();
        return 0;
    }

    public short getServerBusyFlag() throws InvalidMessageException {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() throws InvalidMessageException {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() throws InvalidMessageException {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public boolean isChatSupported() throws InvalidMessageException {
        this.parseBody();
        return this.isChatSupported;
    }

    public boolean isBrowseHostSupported() throws InvalidMessageException {
        this.parseBody();
        return false;
    }

    public DestAddress[] getPushProxyAddresses() throws InvalidMessageException {
        this.parseBody();
        return null;
    }

    public GUID getRemoteServentID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public QueryResponseRecord[] getMsgRecords() throws InvalidMessageException {
        this.parseBody();
        return this.records;
    }

    public void copy(QueryResponseMsg b) {
        this.getHeader().copy(b.getHeader());
        this.destAddress = b.destAddress;
        this.remoteClientID = b.remoteClientID;
        int recordCount = b.records.length;
        this.records = new QueryResponseRecord[recordCount];
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = new QueryResponseRecord();
            rec.copy(b.records[i]);
            this.records[i] = rec;
        }
        this.body = b.body;
    }

    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    private void parseBody() throws InvalidMessageException {
        if (this.isParsed) {
            return;
        }
        assert (this.securityService != null) : "PhexSecurityService missing";
        int recordCount = this.getRecordCount();
        int offset = REC_COUNT_LENGTH + I2P_DEST_LENGTH + NULL_TERM_LENGTH + SPEED_LENGTH;
        this.uniqueResultCount = 0;
        HashSet<URN> uniqueURNs = new HashSet<URN>();
        this.records = new QueryResponseRecord[recordCount];
        int highestAltLocCount = 0;
        for (int i = 0; i < recordCount; ++i) {
            QueryResponseRecord rec = new QueryResponseRecord();
            offset = rec.deserialize(this.body, offset, this.securityService);
            if (rec.getAlternateLocations() != null) {
                highestAltLocCount = Math.max(highestAltLocCount, rec.getAlternateLocations().length);
            }
            this.records[i] = rec;
            URN urn = rec.getURN();
            if (urn != null) {
                uniqueURNs.add(urn);
                continue;
            }
            this.uniqueResultCount = (short)(this.uniqueResultCount + 1);
        }
        this.uniqueResultCount = (short)(this.uniqueResultCount + uniqueURNs.size());
        this.pushNeededFlag = (short)-1;
        this.serverBusyFlag = (short)-1;
        this.hasUploadedFlag = (short)-1;
        this.uploadSpeedFlag = (short)-1;
        this.isBrowseHostSupported = false;
        if (offset <= this.getHeader().getDataLength() - 16 - 4 - 2) {
            try {
                this.vendorCode = new String(this.body, offset, 4, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException exp) {
                NLogger.error(QueryResponseMsg.class, (Object)exp);
                throw new RuntimeException(exp);
            }
            if (QueryResponseMsg.isVendorCodeValid(this.vendorCode)) {
                this.vendorCode = this.vendorCode.intern();
            } else {
                String hexVendorCode = HexConverter.toHexString(this.body, offset, 4);
                NLogger.warn(QueryResponseMsg.class, (Object)(this.getHeader().getFromHost() + ": Illegal QHD vendor code found: " + this.vendorCode + " (" + hexVendorCode + "). Body: " + HexConverter.toHexString(this.body)));
                this.vendorCode = hexVendorCode;
            }
            int openDataLength = IOUtil.unsignedByte2int(this.body[offset += 4]);
            ++offset;
            if (openDataLength > 1) {
                byte flag1 = this.body[offset];
                byte flag2 = this.body[offset + 1];
                if ((flag2 & 1) != 0) {
                    this.pushNeededFlag = (flag1 & 1) != 0 ? (short)1 : 0;
                }
                if ((flag1 & 4) != 0) {
                    this.serverBusyFlag = (flag2 & 4) != 0 ? (short)1 : 0;
                }
                if ((flag1 & 8) != 0) {
                    this.hasUploadedFlag = (flag2 & 8) != 0 ? (short)1 : 0;
                }
                if ((flag1 & 0x10) != 0) {
                    this.uploadSpeedFlag = (flag2 & 0x10) != 0 ? (short)1 : 0;
                }
                if ((flag1 & 0x20) != 0 && (flag2 & 0x20) != 0) {
                    int ggepMagicIndex;
                    for (ggepMagicIndex = offset + 2; ggepMagicIndex < this.body.length && this.body[ggepMagicIndex] != -61; ++ggepMagicIndex) {
                    }
                    GGEPBlock[] ggepBlocks = GGEPBlock.parseGGEPBlocks(this.body, ggepMagicIndex);
                    this.isBrowseHostSupported = GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks, "BH");
                    this.pushProxyAddresses = GGEPExtension.parsePushProxyExtensionData(ggepBlocks, this.securityService);
                }
            }
            offset += openDataLength;
            int maxAcceptedAltLocs = 16;
            if (this.vendorCode.equals("LIME")) {
                maxAcceptedAltLocs = 10;
            }
            if (highestAltLocCount > maxAcceptedAltLocs) {
                if (NLogger.isWarnEnabled(QueryResponseMsg.class)) {
                    NLogger.warn(QueryResponseMsg.class, (Object)("QueryRespRecord with " + highestAltLocCount + " alt locs" + " - vendor: " + this.vendorCode + " host: " + this.getDestAddress() + " access: " + (Object)((Object)this.securityService.controlHostAddressAccess(this.getDestAddress()))));
                    for (int i = 0; i < this.records.length; ++i) {
                        DestAddress[] altLocs = this.records[i].getAlternateLocations();
                        if (altLocs == null || altLocs.length <= maxAcceptedAltLocs) continue;
                        NLogger.warn(QueryResponseMsg.class, (Object)("QueryRespRecord with " + altLocs.length + " alt locs" + " - file: " + this.records[i].getFilename()));
                    }
                    if (this.getHeader().getHopsTaken() <= 1) {
                        NLogger.warn(QueryResponseMsg.class, (Object)("Number of query response record alt-locs exceed the acceptable maximum for LIME: " + highestAltLocCount + "/10 " + "---- QRR Hops: " + this.getHeader().getHopsTaken() + " From: " + this.getDestAddress()));
                    }
                }
                throw new InvalidMessageException("Number of query response record alt-locs exceed the acceptable maximum for LIME: " + highestAltLocCount + "/" + 10);
            }
            int privateDataLength = this.body.length - offset - 16;
            if (privateDataLength > 0 && (this.vendorCode.equals("LIME") || this.vendorCode.equals("RAZA") || this.vendorCode.equals("PHEX"))) {
                byte flag = this.body[offset];
                this.isChatSupported = (flag & 1) != 0;
            }
        }
        this.parseRemoteClientID();
        this.isParsed = true;
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.getHeader().getDataLength() - 16);
    }

    private static boolean isVendorCodeValid(String vendorCode) {
        if (vendorCode.length() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (XMLUtils.isXmlChar(vendorCode.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

