/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Collection;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.host.CaughtHost;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.udp.hostcache.UdpHostCacheContainer;
import phex.utils.IOUtil;
import phex.utils.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PongFactory {
    private static final byte[] GGEP_VENDOR_CODE = new byte[5];
    private static int I2P_DEST_LENGTH;

    public PongMsg createUdpPongMsg(byte[] bytesMsg, Host fromHost, PhexSecurityManager securityService) throws InvalidMessageException {
        return null;
    }

    public PongMsg createUdpPongMsg(MsgHeader msgHdr, byte[] data, int offset, Host fromHost, PhexSecurityManager securityService) throws InvalidMessageException {
        return null;
    }

    public PongMsg createUdpPongMsg(PingMsg ping, DestAddress localAddress, boolean isUdpHostCache, int avgDailyUptime, int sharedFileCount, int sharedFileSize, boolean isUltrapeer, CaughtHostsContainer hostContainer, UdpHostCacheContainer uhcContainer) {
        return null;
    }

    public PongMsg createMyOutgoingPong(GUID msgId, DestAddress localAddress, byte ttl, int sharedFileCount, int sharedFileSize, boolean isUltrapeer, int avgDailyUptime) {
        GGEPBlock ggepBlock = this.createMyGGEPBlock(avgDailyUptime, isUltrapeer);
        MsgHeader header = new MsgHeader(msgId, 1, ttl, 0, 0);
        DestAddress pongAddress = localAddress;
        PongMsg pong = new PongMsg(header, pongAddress, sharedFileCount, sharedFileSize, isUltrapeer, ggepBlock);
        return pong;
    }

    public PongMsg createOtherLeafsOutgoingPong(GUID msgId, byte ttl, byte hops, DestAddress address) {
        MsgHeader header = new MsgHeader(msgId, 1, ttl, hops, 0);
        GGEPBlock ggepBlock = null;
        PongMsg pong = new PongMsg(header, address, 0, 0, false, ggepBlock);
        return pong;
    }

    public PongMsg createFromCachePong(GUID newGuid, byte newTTL, PongMsg pongMsg, PhexSecurityManager securityService) {
        MsgHeader header = new MsgHeader(newGuid, 1, newTTL, 0, 0);
        PongMsg pong = new PongMsg(header, pongMsg.getBody(), securityService);
        return pong;
    }

    private GGEPBlock createMyGGEPBlock(int avgDailyUptime, boolean isUltrapeer) {
        GGEPBlock ggepBlock = new GGEPBlock(false);
        if (avgDailyUptime > 0) {
            ggepBlock.addExtension("DU", 6);
        }
        if (isUltrapeer) {
            byte[] upExtension = new byte[3];
            upExtension[0] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getUltrapeerMajorVersionNumber(), VersionUtils.getUltrapeerMinorVersionNumber());
            NetworkHostsContainer networkHostsContainer = Servent.getInstance().getHostService().getNetworkHostsContainer();
            upExtension[1] = (byte)networkHostsContainer.getOpenLeafSlotsCount();
            upExtension[2] = (byte)networkHostsContainer.getOpenUltrapeerSlotsCount();
            ggepBlock.addExtension("UP", upExtension);
        }
        ggepBlock.addExtension("VC", GGEP_VENDOR_CODE);
        return ggepBlock;
    }

    private static void addPhexExtendedDestinationGGEP(DestAddress address, GGEPBlock ggepBlock) {
        ggepBlock.addExtension("PHEX.EXDST", address.getHostName().getBytes());
    }

    private static byte[] packIpPortData(Collection<CaughtHost> caughtHostCollection) {
        NLogger.info(PongMsg.class, (Object)"Packing Pong message IPP extension.");
        int FIELD_SIZE = I2P_DEST_LENGTH;
        byte[] data = new byte[caughtHostCollection.size() * FIELD_SIZE];
        int offset = 0;
        for (CaughtHost host : caughtHostCollection) {
            DestAddress address = host.getHostAddress();
            String destBase64 = address.getFullHostName();
            System.arraycopy(destBase64.getBytes(), 0, data, offset, I2P_DEST_LENGTH);
            offset += I2P_DEST_LENGTH;
        }
        return data;
    }

    static {
        PongFactory.GGEP_VENDOR_CODE[0] = 80;
        PongFactory.GGEP_VENDOR_CODE[1] = 72;
        PongFactory.GGEP_VENDOR_CODE[2] = 69;
        PongFactory.GGEP_VENDOR_CODE[3] = 88;
        PongFactory.GGEP_VENDOR_CODE[4] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getMajorVersionNumber(), VersionUtils.getMinorVersionNumber());
        I2P_DEST_LENGTH = 516;
    }
}

