/*
 * Decompiled with CFR 0.152.
 */
package phex.io.buffer;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.io.buffer.DirectByteBuffer;

@Deprecated
public class DirectByteBufferProvider {
    private static final DirectByteBufferProvider instance = new DirectByteBufferProvider();
    private Map<Integer, Set<DirectByteBuffer>> sizeToBufferListMap = new LinkedHashMap<Integer, Set<DirectByteBuffer>>();
    private static final long MAX_TOTAL_BUFFER_SIZE = 0xA00000L;

    private DirectByteBufferProvider() {
        Environment.getInstance().scheduleTimerTask(new CleanupCheckerTask(), 600000L, 600000L);
    }

    public static DirectByteBuffer requestBuffer(int sizeInBytes) {
        return instance.requestDirectByteBuffer(sizeInBytes);
    }

    protected synchronized void releaseDirectByteBuffer(DirectByteBuffer directByteBuffer) {
        this.debugDump();
        ByteBuffer buffer = directByteBuffer.getInternalBuffer();
        int kb = (int)Math.ceil((double)buffer.capacity() / 1024.0);
        Integer key = kb;
        Set<DirectByteBuffer> set = this.sizeToBufferListMap.get(key);
        if (set == null) {
            set = new HashSet<DirectByteBuffer>();
            this.sizeToBufferListMap.put(key, set);
        }
        set.add(directByteBuffer);
        this.debugDump();
    }

    private synchronized DirectByteBuffer requestDirectByteBuffer(int capacity) {
        DirectByteBuffer directByteBuffer;
        this.debugDump();
        int kb = (int)Math.ceil((double)capacity / 1024.0);
        Integer key = kb;
        Set<DirectByteBuffer> set = this.sizeToBufferListMap.get(key);
        if (set == null) {
            set = new HashSet<DirectByteBuffer>();
            this.sizeToBufferListMap.put(key, set);
        }
        if (set.isEmpty()) {
            directByteBuffer = this.allocateDirectByteBuffer(kb * 1024);
        } else {
            directByteBuffer = set.iterator().next();
            set.remove(directByteBuffer);
        }
        ByteBuffer buffer = directByteBuffer.getInternalBuffer();
        buffer.clear();
        buffer.limit(capacity);
        this.debugDump();
        return directByteBuffer;
    }

    private synchronized DirectByteBuffer allocateDirectByteBuffer(int capacity) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ByteBuffer.allocateDirect(capacity);
        }
        catch (OutOfMemoryError err) {
            this.clearBuffers();
            System.runFinalization();
            System.gc();
            Thread.yield();
            try {
                byteBuffer = ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError err2) {
                NLogger.error(DirectByteBufferProvider.class, (Object)"Out of memory while trying to allocated direct byte buffer.");
                throw err2;
            }
        }
        DirectByteBuffer directByteBuffer = new DirectByteBuffer(byteBuffer, this);
        return directByteBuffer;
    }

    private synchronized void clearBuffers() {
        for (Set<DirectByteBuffer> set : this.sizeToBufferListMap.values()) {
            set.clear();
        }
    }

    private synchronized void cleanupChecker() {
        long bytesUsed = 0L;
        for (Integer key : this.sizeToBufferListMap.keySet()) {
            Set<DirectByteBuffer> set = this.sizeToBufferListMap.get(key);
            bytesUsed += (long)(key * set.size()) * 1024L;
        }
        if (bytesUsed > 0xA00000L) {
            this.performCleanup(bytesUsed - 0xA00000L);
        }
    }

    private synchronized void performCleanup(long bytesToFree) {
        int mapSize = this.sizeToBufferListMap.size();
        int highestCount = 0;
        int[] bufferSizeArr = new int[mapSize];
        Set[] bufferSetArr = new Set[mapSize];
        int i = 0;
        for (Integer key : this.sizeToBufferListMap.keySet()) {
            Set<DirectByteBuffer> set = this.sizeToBufferListMap.get(key);
            bufferSizeArr[i] = key * 1024;
            bufferSetArr[i] = set;
            int setSize = set.size();
            if (setSize > highestCount) {
                highestCount = setSize;
            }
            ++i;
        }
        long bytesFreed = 0L;
        while (bytesFreed < bytesToFree && highestCount > 0) {
            for (i = 0; i < mapSize; ++i) {
                if (bufferSetArr[i].size() != highestCount) continue;
                bufferSetArr[i].remove(bufferSetArr[i].iterator().next());
                bytesFreed += (long)bufferSizeArr[i];
            }
            --highestCount;
        }
    }

    private synchronized void debugDump() {
    }

    private class CleanupCheckerTask
    extends TimerTask {
        private static final int TIMER_PERIOD = 600000;

        private CleanupCheckerTask() {
        }

        public void run() {
            DirectByteBufferProvider.this.cleanupChecker();
        }
    }
}

