/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.log.NLogger;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.Servent;
import phex.statistic.StatisticsManager;
import phex.statistic.UptimeStatisticProvider;

public class UltrapeerCapabilityChecker
extends TimerTask {
    private static final long TIMER_PERIOD = 10000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long TEN_MINUTES = 600000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long TWO_HOURS = 0x6DDD00L;
    private final Servent servent;
    private boolean isUltrapeerCapable;
    private boolean isUltrapeerOS;
    private StatisticsManager statisticsService;

    public UltrapeerCapabilityChecker(Servent servent, StatisticsManager statisticsService) {
        if (servent == null) {
            throw new NullPointerException("servent missing.");
        }
        if (statisticsService == null) {
            throw new NullPointerException("statisticsService missing.");
        }
        this.servent = servent;
        this.statisticsService = statisticsService;
        Environment env = Environment.getInstance();
        this.isUltrapeerOS = env.isUltrapeerOS();
        env.scheduleTimerTask(this, 0L, 10000L);
    }

    public void run() {
        try {
            this.checkIfUltrapeerCapable();
        }
        catch (Throwable th) {
            NLogger.error(UltrapeerCapabilityChecker.class, (Object)th, th);
        }
    }

    private void checkIfUltrapeerCapable() {
        boolean isCapable;
        UptimeStatisticProvider uptimeProvider = (UptimeStatisticProvider)this.statisticsService.getStatisticProvider("UptimeProvider");
        if (uptimeProvider == null) {
            this.isUltrapeerCapable = false;
            return;
        }
        this.isUltrapeerCapable = isCapable = ConnectionPrefs.AllowToBecomeUP.get() != false && !this.servent.isFirewalled() && this.isUltrapeerOS && BandwidthPrefs.NetworkSpeedKbps.get() > 64 && BandwidthPrefs.MaxNetworkBandwidth.get() > 10240 && BandwidthPrefs.MaxTotalBandwidth.get() > 14336 && (((LongObj)uptimeProvider.getValue()).getValue() > 1200000L || ((LongObj)uptimeProvider.getAverageValue()).getValue() > 600000L);
    }

    public boolean isUltrapeerCapable() {
        return this.isUltrapeerCapable;
    }
}

