/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import phex.host.Host;
import phex.utils.Localizer;

public class HostInfo {
    public static String getHostStatusString(Host host) {
        String lastStatusMsg = host.getLastStatusMsg();
        switch (host.getStatus()) {
            case NOT_CONNECTED: {
                return Localizer.getString("NetHostStatus_NotConnected");
            }
            case ERROR: {
                Object[] args = new Object[]{lastStatusMsg};
                return Localizer.getFormatedString("NetHostStatus_Error", args);
            }
            case CONNECTING: {
                Object[] args = new Object[]{lastStatusMsg != null ? lastStatusMsg : ""};
                return Localizer.getFormatedString("NetHostStatus_Connecting", args);
            }
            case ACCEPTING: {
                Object[] args = new Object[]{lastStatusMsg};
                return Localizer.getFormatedString("NetHostStatus_Accepting", args);
            }
            case CONNECTED: {
                Object[] args = new Object[]{host.isSendQueueInRed() ? Integer.valueOf(1) : Integer.valueOf(0)};
                return Localizer.getFormatedString("NetHostStatus_Connected", args);
            }
            case DISCONNECTED: {
                return Localizer.getString("NetHostStatus_Disconnected");
            }
        }
        return Localizer.getString("NetHostStatus_Unknown");
    }
}

