/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.GeneralGnutellaNetwork;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.ProtocolNotSupportedException;
import phex.event.ChangeEvent;
import phex.gwebcache.GWebCache;
import phex.gwebcache.GWebCacheComparator;
import phex.gwebcache.GWebCacheConnection;
import phex.host.CaughtHostsContainer;
import phex.servent.Servent;
import phex.utils.IOUtil;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;

public class GWebCacheContainer {
    private static int MIN_G_WEB_CACHES_SIZE = 3;
    private static int MAX_G_WEB_CACHES_SIZE = 50;
    private static List<String> BLOCKED_WEB_CACHES;
    private static List<String> PHEX_WEB_CACHES;
    private final List<GWebCache> allGWebCaches;
    private final List<GWebCache> functionalGWebCaches;
    private final List<GWebCache> phexGWebCaches;
    private final Set<String> uniqueGWebCacheURLs;
    private final TreeSet<GWebCache> sortedGWebCaches;
    private final Random random;
    private final Servent servent;

    public GWebCacheContainer(Servent servent) {
        if (servent == null) {
            throw new NullPointerException("Servent missing.");
        }
        NLogger.debug(GWebCacheContainer.class, (Object)"Initializing GWebCacheContainer");
        this.servent = servent;
        this.allGWebCaches = new ArrayList<GWebCache>();
        this.phexGWebCaches = new ArrayList<GWebCache>();
        this.functionalGWebCaches = new ArrayList<GWebCache>();
        this.uniqueGWebCacheURLs = new HashSet<String>();
        this.sortedGWebCaches = new TreeSet<GWebCache>(GWebCacheComparator.INSTANCE);
        this.random = new Random();
        this.initializeGWebCacheContainer();
        servent.getEventService().processAnnotations(this);
    }

    private void initializeGWebCacheContainer() {
        this.allGWebCaches.clear();
        this.phexGWebCaches.clear();
        this.functionalGWebCaches.clear();
        this.uniqueGWebCacheURLs.clear();
        this.sortedGWebCaches.clear();
        this.insertPhexGWebCaches();
        this.loadFromConfigInBackgrd();
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.initializeGWebCacheContainer();
    }

    public boolean queryMoreHosts(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            DestAddress[] hosts = connection.sendHostFileRequest(this.servent.getSecurityService());
            if (!this.verifyGWebCache(connection) || hosts == null) continue;
            CaughtHostsContainer container = this.servent.getHostService().getCaughtHostsContainer();
            for (int i = 0; i < hosts.length; ++i) {
                container.addCaughtHost(hosts[i], (short)2);
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean updateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        NLogger.info(GWebCacheContainer.class, (Object)"updateRemoteGWebCache");
        String fullHostName = null;
        if (myHostAddress != null) {
            fullHostName = myHostAddress.getFullHostName();
            NLogger.debug(GWebCacheContainer.class, (Object)("My fullHostName: " + fullHostName));
        }
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) {
                NLogger.debug(GWebCacheContainer.class, (Object)"No connection but we continue");
                continue;
            }
            String urlString = null;
            GWebCache gWebCache = this.getGWebCacheForUpdate(connection.getGWebCache());
            NLogger.debug(GWebCacheContainer.class, (Object)"Is there gwebcache for update available ? (yes / nothing for no)");
            if (gWebCache != null) {
                NLogger.debug(GWebCacheContainer.class, (Object)"Is there gwebcache for update available: yes");
                assert (!gWebCache.isPhexCache() && !gWebCache.equals(connection.getGWebCache())) : "isPhexCache: " + gWebCache.isPhexCache() + ",equals " + gWebCache.getUrl() + " - " + connection.getGWebCache().getUrl();
                urlString = gWebCache.getUrl().toExternalForm();
            }
            if (fullHostName == null && urlString == null) {
                NLogger.debug(GWebCacheContainer.class, (Object)"No data to update... try again to determine random GWebCache in loop");
                continue;
            }
            succ = connection.updateRequest(fullHostName, urlString);
            this.verifyGWebCache(connection);
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean queryMoreGWebCaches(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            URL[] urls = connection.sendURLFileRequest();
            if (!this.verifyGWebCache(connection) || urls == null) continue;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    boolean isPhexCache = this.isPhexGWebCache(urls[i].toExternalForm());
                    GWebCache gWebCache = new GWebCache(urls[i], isPhexCache);
                    if (!this.isCacheAccessAllowed(gWebCache)) continue;
                    this.insertGWebCache(gWebCache);
                    continue;
                }
                catch (IOException exp) {
                    NLogger.debug(GWebCacheContainer.class, (Object)exp);
                }
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public int getGWebCacheCount() {
        return this.allGWebCaches.size();
    }

    private GWebCache getGWebCacheForUpdate(GWebCache ignore) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GWebCache getRandomGWebCache(boolean preferPhex) {
        NLogger.info(GWebCacheContainer.class, (Object)"getRandomGWebCache");
        this.ensureMinGWebCaches();
        List<GWebCache> list = this.allGWebCaches;
        synchronized (list) {
            boolean usePhexCache;
            GWebCache cache = null;
            boolean bl = usePhexCache = preferPhex && this.random.nextInt(8) == 0;
            if (usePhexCache && this.phexGWebCaches.size() > 0) {
                NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache: getRandomGWebCacheusePhexCache && phexGWebCaches.size() > 0");
                Collections.sort(this.phexGWebCaches, GWebCacheComparator.INSTANCE);
                cache = this.phexGWebCaches.get(0);
                NLogger.debug(GWebCacheContainer.class, (Object)("getRandomGWebCache: cache = " + cache));
            } else {
                NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache: getRandomGWebCacheusePhexCache && phexGWebCaches.size() <= 0");
                int count = this.allGWebCaches.size();
                if (count == 0) {
                    NLogger.debug(GWebCacheContainer.class, (Object)("getRandomGWebCache: count = " + this.allGWebCaches.size()));
                    return null;
                }
                cache = this.sortedGWebCaches.first();
                NLogger.info(GWebCacheContainer.class, (Object)("getRandomGWebCache: cache (after sorting) = " + cache));
            }
            long now = System.currentTimeMillis();
            NLogger.debug(GWebCacheContainer.class, (Object)("getRandomGWebCache: now > cache.getEarliestReConnectTime() ? ( " + now + " vs " + cache.getEarliestReConnectTime() + " )"));
            if (now > cache.getEarliestReConnectTime()) {
                NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache: yes => return cache.");
                return cache;
            }
            NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache: no. ");
            return null;
        }
    }

    private GWebCacheConnection getRandomGWebCacheConnection(boolean preferPhex) {
        NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCacheConnection");
        GWebCacheConnection connection = null;
        GWebCache gWebCache = null;
        try {
            gWebCache = this.getRandomGWebCache(preferPhex);
            if (gWebCache == null) {
                NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache getRandomGWebCacheConnection = null");
                return null;
            }
            connection = new GWebCacheConnection(gWebCache);
        }
        catch (ProtocolNotSupportedException exp) {
            NLogger.debug(GWebCacheContainer.class, (Object)"getRandomGWebCache ProtocolNotSupportedExceptionn removeGWebCache");
            this.removeGWebCache(gWebCache, true);
            return null;
        }
        return connection;
    }

    private boolean verifyGWebCache(GWebCacheConnection connection) {
        NLogger.debug(GWebCacheContainer.class, (Object)"verifyGWebCache");
        GWebCache gWebCache = connection.getGWebCache();
        this.sortedGWebCaches.remove(gWebCache);
        gWebCache.countConnectionAttempt(connection.isCacheBad());
        this.sortedGWebCaches.add(gWebCache);
        if (!(connection.isCacheBad() || gWebCache.isPhexCache() || this.functionalGWebCaches.contains(gWebCache))) {
            NLogger.debug(GWebCacheContainer.class, (Object)"verifyGWebCache: cache is working add it to functional list if not phex cache.");
            this.functionalGWebCaches.add(gWebCache);
        }
        this.saveGWebCacheToFile();
        return true;
    }

    private GWebCache parseGWebCacheFromLine(String line) throws IOException {
        int failedInRowCount;
        long lastRequestTime;
        String urlStr;
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            urlStr = line;
            lastRequestTime = -1L;
            failedInRowCount = -1;
        } else if (tokenCount == 3) {
            urlStr = tokenizer.nextToken();
            try {
                lastRequestTime = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastRequestTime = -1L;
            }
            try {
                failedInRowCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                failedInRowCount = -1;
            }
        } else {
            NLogger.warn(GWebCacheContainer.class, (Object)("Unknown HostCache line format: " + line));
            return null;
        }
        NormalizableURL helpUrl = new NormalizableURL(urlStr);
        helpUrl.normalize();
        URL url = new URL(helpUrl.toExternalForm());
        boolean isPhexCache = this.isPhexGWebCache(url.toExternalForm());
        GWebCache cache = new GWebCache(url, isPhexCache);
        if (lastRequestTime > 0L) {
            cache.setLastRequestTime(lastRequestTime);
        }
        if (failedInRowCount > 0) {
            cache.setFailedInRowCount(failedInRowCount);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGWebCache(GWebCache gWebCache) {
        List<GWebCache> list = this.allGWebCaches;
        synchronized (list) {
            if (this.allGWebCaches.size() >= MAX_G_WEB_CACHES_SIZE) {
                NLogger.error(GWebCacheContainer.class, (Object)"Limit of 1000 GWebCaches reached.");
                this.removeGWebCache(this.sortedGWebCaches.last(), true);
                return;
            }
            String uniqueString = gWebCache.getHostDomain();
            if (!this.uniqueGWebCacheURLs.contains(uniqueString)) {
                this.allGWebCaches.add(gWebCache);
                this.sortedGWebCaches.add(gWebCache);
                this.uniqueGWebCacheURLs.add(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.add(gWebCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGWebCache(GWebCache gWebCache, boolean force) {
        List<GWebCache> list = this.allGWebCaches;
        synchronized (list) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || force) {
                this.allGWebCaches.remove(gWebCache);
                this.functionalGWebCaches.remove(gWebCache);
                this.sortedGWebCaches.remove(gWebCache);
                String uniqueString = gWebCache.getHostDomain();
                this.uniqueGWebCacheURLs.remove(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.remove(gWebCache);
                }
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCacheFromLine(String gWebCacheLine) {
        try {
            GWebCache gWebCache = this.parseGWebCacheFromLine(gWebCacheLine);
            if (gWebCache != null && this.isCacheAccessAllowed(gWebCache)) {
                this.insertGWebCache(gWebCache);
            }
        }
        catch (IOException exp) {
            NLogger.debug(GWebCacheContainer.class, (Object)exp);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() >= 10) {
            return;
        }
        if (!(this.servent.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        NLogger.debug(GWebCacheContainer.class, (Object)"Load default GWebCache file.");
        InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/gwebcache.cfg");
        if (inStream != null) {
            InputStreamReader reader = new InputStreamReader(inStream);
            try {
                this.loadGWebCacheFromReader(reader);
                this.saveGWebCacheToFile();
            }
            catch (IOException exp) {
                NLogger.warn(GWebCacheContainer.class, (Object)exp, (Throwable)exp);
            }
        } else {
            NLogger.warn(GWebCacheContainer.class, (Object)"Default GWebCache file not found.");
        }
        if (this.allGWebCaches.size() < 1) {
            this.insertPhexGWebCaches();
            this.saveGWebCacheToFile();
        }
    }

    private void insertPhexGWebCaches() {
        if (!(this.servent.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        for (String phexCachesURL : PHEX_WEB_CACHES) {
            try {
                URL url = new URL(phexCachesURL);
                GWebCache cache = new GWebCache(url, true);
                this.insertGWebCache(cache);
            }
            catch (IOException e) {
                NLogger.error(GWebCacheContainer.class, (Object)e, (Throwable)e);
            }
        }
    }

    private boolean isCacheAccessAllowed(GWebCache gWebCache) {
        URL cacheURL = gWebCache.getUrl();
        String hostName = cacheURL.getHost();
        if (AddressUtils.isIPHostName(hostName) && StringUtils.isEmpty(cacheURL.getPath())) {
            return false;
        }
        for (String blocked : BLOCKED_WEB_CACHES) {
            if (hostName.indexOf(blocked) == -1) continue;
            NLogger.debug(GWebCacheContainer.class, (Object)"GWebCache host blocked.");
            return false;
        }
        return true;
    }

    public boolean isPhexGWebCache(String url) {
        return PHEX_WEB_CACHES.indexOf(url) != -1;
    }

    private void loadFromConfigInBackgrd() {
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    File gWebCacheFile = GWebCacheContainer.this.servent.getGnutellaNetwork().getGWebCacheFile();
                    if (!gWebCacheFile.exists()) {
                        return;
                    }
                    GWebCacheContainer.this.loadGWebCacheFromReader(new FileReader(gWebCacheFile));
                }
                catch (IOException exp) {
                    NLogger.error(GWebCacheContainer.class, (Object)"Failed loading GWebCache file.", (Throwable)exp);
                }
                finally {
                    GWebCacheContainer.this.ensureMinGWebCaches();
                }
            }
        };
        Environment.getInstance().executeOnThreadPool(runner, "LoadGWebCacheRunner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromReader(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        List<GWebCache> list = this.allGWebCaches;
        synchronized (list) {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this.insertGWebCacheFromLine(line);
            }
        }
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGWebCacheToFile() {
        NLogger.debug(GWebCacheContainer.class, (Object)"Saving GWebCaches.");
        BufferedWriter writer = null;
        try {
            File file = this.servent.getGnutellaNetwork().getGWebCacheFile();
            writer = new BufferedWriter(new FileWriter(file));
            List<GWebCache> list = this.allGWebCaches;
            synchronized (list) {
                for (GWebCache gWebCache : this.allGWebCaches) {
                    if (gWebCache.isPhexCache()) continue;
                    writer.write(gWebCache.getUrl().toExternalForm() + " " + gWebCache.getLastRequestTime() + " " + gWebCache.getFailedInRowCount());
                    writer.newLine();
                }
            }
            IOUtil.closeQuietly(writer);
        }
        catch (IOException exp) {
            NLogger.error(GWebCacheContainer.class, (Object)exp, (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(writer);
        }
    }

    static {
        String[] arr = new String[]{"http://i2p/STCoM38O3iquVMBSzc7tBdtjxM8scvXPNzDaF8o~OAnEBmRNcBjRMWGOsPjQ~TLS9oD14e0avaM17vr67pCccxeb~2o-hTFJJBHI4aNI-rolrA-2SPj7xocV-9yFGf3eS9dLP70u3qfTiVULD70tObYlRxlSiMckMILrvwQc9oIFyIRJt254yNO9n7O0OTJsEjoh0JwoO3MeGm9Umm3XPMnGwzSqiVCUyJAUWuv5i8vmWqQqJVXjQI9sDFA~t5JYFbjZcjAGexW7d3KaEljcWJduNho4loqtYlgq6Z9rdZX3R~zgdoG5Y-CNFaowNLqMqOb9fzvSUOCWojoVLxkqz42VMSR19WxyOJ-4~7jtxUTR-R0A8dx3nfusbf6yqaQglL4wedLwdpaNTGZkwWET8oVgmHrEkhXkKudvo4-66f8YJq6XSKXvEg0I62EQkx8D7DXsm8k9VBei527yOx3JiOj5kNZ0vi26EoAdqR4CxuaD78jvr59mTt-x2x5QZvQ6AAAA/", "http://i2p/90azVnADDkfpZ6JYlQEmirJ2s9NV1qUppJl-lA9mLWKERWJGzAEKqOkquaAj8ZsSHPypEDtTdn5ElUaUxHrnLh8Lcy~hY1gP1LIZUX-YgxR4scH~mMrH4M6N2AV0LdR54phH4ul7YJuyVRUwWjOb80Gm6CvHgHhHj-cEuVpvW~kTFAIzieTrwxU2klo9WWFriDUzjy6~24JQv0wHh2tS2tdkDzLwj9oMdEtmzBRQyXhs~NX~GvvrKPIN45GNtCNcfmRpVlaPqapcsjfXAmEthHBV-S4lYRVBKRWfk8FUoIHLQPQyUfCUYJ0HEknUAfG~o~FBoZ3T8T~w2OD3dYQlhmiT0nJr8MKqCsC8xLN0UvYbxFKUn9AVzxWAM7Gm6fY-piYhrgmhoGYfPhxRu0dUJ5yFM1Umd6eO5TSJJYuacu4Uw0KUpPRQDZk5dWnDjXpGR0qPKikUhWFxrf~0-26EB84TrZD2VIfY2qKN4pHTV4NTFsNpjcPRUrRzU20erc7QAAAA/"};
        PHEX_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(arr));
        String[] blockedArr = new String[]{"gavinroy.com"};
        BLOCKED_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(blockedArr));
    }
}

