/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.security;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.ContainerEvent;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.renderer.DateCellRenderer;
import phex.security.IpSecurityRule;
import phex.security.IpSecurityRuleComparator;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.Localizer;

public class SecurityTableModel
extends FWSortableTableModel {
    private static final int ADDRESS_MODEL_INDEX = 0;
    private static final int TYPE_MODEL_INDEX = 1;
    private static final int EXPIRES_MODEL_INDEX = 2;
    private static final int TRIGGER_COUNT_MODEL_INDEX = 3;
    private static final int DESCRIPTION_MODEL_INDEX = 4;
    private static final int ADDRESS_COLUMN_ID = 1001;
    private static final int TYPE_COLUMN_ID = 1002;
    private static final int EXPIRES_COLUMN_ID = 1003;
    private static final int TRIGGER_COUNT_COLUMN_ID = 1004;
    private static final int DESCRIPTION_COLUMN_ID = 1005;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004, 1005};
    private static String[] tableColumns = new String[]{Localizer.getString("Address"), Localizer.getString("Type"), Localizer.getString("Expires"), Localizer.getString("TriggerCount"), Localizer.getString("Description")};
    private static Class[] tableClasses = new Class[]{String.class, String.class, DateCellRenderer.class, Integer.class, String.class};
    private PhexSecurityManager securityMgr;

    public SecurityTableModel() {
        super(COLUMN_IDS, tableColumns, tableClasses);
        Servent servent = GUIRegistry.getInstance().getServent();
        this.securityMgr = servent.getSecurityService();
        servent.getEventService().processAnnotations(this);
    }

    public int getRowCount() {
        return this.securityMgr.getIPAccessRuleCount();
    }

    public Object getValueAt(int row, int column) {
        IpSecurityRule rule = this.securityMgr.getIPAccessRule(row);
        if (rule == null) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        switch (column) {
            case 0: {
                return rule.getAddressString();
            }
            case 1: {
                if (rule.isDenyingRule()) {
                    return Localizer.getString("Deny");
                }
                return Localizer.getString("Accept");
            }
            case 2: {
                return rule.getExpiryDate();
            }
            case 3: {
                return rule.getTriggerCount();
            }
            case 4: {
                return rule.getDescription();
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return IpSecurityRuleComparator.INSTANCE;
            }
        }
        return null;
    }

    public Object getComparableValueAt(int row, int column) {
        switch (column) {
            case 0: {
                IpSecurityRule rule = this.securityMgr.getIPAccessRule(row);
                return rule;
            }
        }
        return this.getValueAt(row, column);
    }

    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    @EventTopicSubscriber(topic="phex:security/rule")
    public void onSecurityRuleEvent(String topic, final ContainerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    SecurityTableModel.this.fireTableChanged(new TableModelEvent(SecurityTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    SecurityTableModel.this.fireTableChanged(new TableModelEvent(SecurityTableModel.this, position, position, -1, -1));
                }
            }
        });
    }
}

