/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.security;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.security.SecurityRuleDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.security.SecurityRuleRowRenderer;
import phex.gui.tabs.security.SecurityTableModel;
import phex.security.IpSecurityRule;
import phex.security.IpUserSecurityRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.servent.Servent;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class SecurityTab
extends FWTab {
    private static final String SECURITY_TABLE_IDENTIFIER = "SecurityTable";
    private static final SecurityRule[] EMPTY_SECURITYRULE_ARRAY = new SecurityRule[0];
    private JPopupMenu securityPopup;
    private SecurityTableModel securityModel;
    private FWTable securityTable;
    private JScrollPane securityTableScrollPane;
    private PhexSecurityManager securityMgr;
    private static final String EDIT_SECURITY_RULE_ACTION_KEY = "EditSecurityRuleAction";

    public SecurityTab() {
        super(1005, Localizer.getString("Security"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Security.Tab"), Localizer.getString("TTTSecurity"), Localizer.getChar("SecurityMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SecurityAccelerator")), 5);
        Servent servent = GUIRegistry.getInstance().getServent();
        this.securityMgr = servent.getSecurityService();
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("Security"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        MouseHandler mouseHandler = new MouseHandler();
        this.securityModel = new SecurityTableModel();
        this.securityTable = new FWTable(new FWSortedTableModel(this.securityModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.securityTable, SECURITY_TABLE_IDENTIFIER);
        SecurityRuleRowRenderer securityRowRenderer = new SecurityRuleRowRenderer();
        List<TableColumn> colList = this.securityTable.getColumns(true);
        for (TableColumn column : colList) {
            column.setCellRenderer(securityRowRenderer);
        }
        this.securityTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.securityTable.activateAllHeaderActions();
        this.securityTable.setAutoResizeMode(0);
        this.securityTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.securityTable);
        this.securityTableScrollPane = FWTable.createFWTableScrollPane(this.securityTable);
        this.securityTableScrollPane.addMouseListener(mouseHandler);
        contentBuilder.add((Component)this.securityTableScrollPane, cc.xy(1, 1));
        FWToolBar securityToolbar = new FWToolBar(0);
        securityToolbar.setBorderPainted(false);
        securityToolbar.setFloatable(false);
        contentBuilder.add((Component)securityToolbar, cc.xy(1, 3));
        this.securityPopup = new JPopupMenu();
        FWAction action = new NewSecurityRuleAction();
        this.addTabAction(action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
        action = new EditSecurityRuleAction();
        this.addTabAction(EDIT_SECURITY_RULE_ACTION_KEY, action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
        action = new RemoveSecurityRuleAction();
        this.addTabAction(action);
        securityToolbar.addAction(action);
        this.securityPopup.add(action);
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.securityTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.securityTableScrollPane);
        }
    }

    private SecurityRule[] getSelectedSecurityRules() {
        if (this.securityTable.getSelectedRowCount() == 0) {
            return EMPTY_SECURITYRULE_ARRAY;
        }
        int[] viewIndices = this.securityTable.getSelectedRows();
        int[] modelIndices = this.securityTable.convertRowIndicesToModel(viewIndices);
        SecurityRule[] files = this.securityMgr.getIPAccessRulesAt(modelIndices);
        return files;
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.securityTable, SECURITY_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    public class RemoveSecurityRuleAction
    extends FWAction {
        public RemoveSecurityRuleAction() {
            super(Localizer.getString("RemoveSecurityRule"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Security.Remove"), Localizer.getString("TTTRemoveSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRow() < 0) {
                    this.setEnabled(false);
                    return;
                }
                SecurityRule[] securityRules = SecurityTab.this.getSelectedSecurityRules();
                for (int i = 0; i < securityRules.length; ++i) {
                    if (securityRules[i] == null || securityRules[i].isSystemRule()) continue;
                    SecurityTab.this.securityMgr.removeSecurityRule(securityRules[i]);
                }
            }
            catch (Throwable th) {
                NLogger.error(RemoveSecurityRuleAction.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
            int row = SecurityTab.this.securityTable.getSelectedRow();
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRules = SecurityTab.this.getSelectedSecurityRules();
            for (int i = 0; i < securityRules.length; ++i) {
                if (securityRules[i] == null || securityRules[i].isSystemRule()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    public class EditSecurityRuleAction
    extends FWAction {
        public EditSecurityRuleAction() {
            super(Localizer.getString("EditSecurityRule"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Security.Edit"), Localizer.getString("TTTEditSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (SecurityTab.this.securityTable.getSelectedRowCount() != 1) {
                    return;
                }
                int viewIdx = SecurityTab.this.securityTable.getSelectedRow();
                int modelIdx = SecurityTab.this.securityTable.translateRowIndexToModel(viewIdx);
                IpSecurityRule rule = SecurityTab.this.securityMgr.getIPAccessRule(modelIdx);
                if (rule == null || rule.isSystemRule() || !(rule instanceof IpUserSecurityRule)) {
                    return;
                }
                SecurityRuleDialog dialog = new SecurityRuleDialog((IpUserSecurityRule)rule);
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                NLogger.error(EditSecurityRuleAction.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
            if (SecurityTab.this.securityTable.getSelectedRowCount() == 1) {
                int viewIdx = SecurityTab.this.securityTable.getSelectedRow();
                int modelIdx = SecurityTab.this.securityTable.translateRowIndexToModel(viewIdx);
                IpSecurityRule rule = SecurityTab.this.securityMgr.getIPAccessRule(modelIdx);
                if (rule == null || rule.isSystemRule()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class NewSecurityRuleAction
    extends FWAction {
        public NewSecurityRuleAction() {
            super(Localizer.getString("NewSecurityRule"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Security.New"), Localizer.getString("TTTNewSecurityRule"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SecurityRuleDialog dialog = new SecurityRuleDialog();
                dialog.setVisible(true);
            }
            catch (Throwable th) {
                NLogger.error(NewSecurityRuleAction.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && e.getSource() == SecurityTab.this.securityTable) {
                    SecurityTab.this.getTabAction(SecurityTab.EDIT_SECURITY_RULE_ACTION_KEY).actionPerformed(null);
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        public void mouseReleased(MouseEvent e) {
            try {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        public void mousePressed(MouseEvent e) {
            try {
                Component source;
                if (SwingUtilities.isRightMouseButton(e) && (source = (Component)e.getSource()) == SecurityTab.this.securityTable) {
                    Point p = e.getPoint();
                    int row = SecurityTab.this.securityTable.rowAtPoint(p);
                    int column = SecurityTab.this.securityTable.columnAtPoint(p);
                    SecurityTab.this.securityTable.changeSelection(row, column, false, false);
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == SecurityTab.this.securityTable || source == SecurityTab.this.securityTableScrollPane) {
                SecurityTab.this.securityPopup.show(source, x, y);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            try {
                SecurityTab.this.refreshTabActions();
            }
            catch (Throwable th) {
                NLogger.error(SelectionHandler.class, (Object)th, th);
            }
        }
    }
}

