/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.Keymap;
import phex.common.MediaType;
import phex.gui.common.FWSizeDefComboBox;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.renderer.MediaTypeListRenderer;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.condition.OrConcatCondition;
import phex.rules.consequence.FilterFromSearchConsequence;
import phex.utils.Localizer;

public class QuickFilterPanel
extends JPanel {
    private static final String QUICK_FILTER_RULE_NAME = "?<#}PhexQuickFilterRule";
    private SearchResultsDataModel currentResultsDataModel;
    private Rule currentQuickFilterRule;
    private JTextField withTermsTF;
    private JTextField withoutTermsTF;
    private JComboBox mediaTypeComboBox;
    private JTextField minFileSizeTF;
    private FWSizeDefComboBox minFileSizeUnitComboBox;
    private JTextField maxFileSizeTF;
    private FWSizeDefComboBox maxFileSizeUnitComboBox;
    private Timer activateQuickFilterTimer;

    public QuickFilterPanel() {
        this.initializeComponent();
        this.updateUI();
        this.activateQuickFilterTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickFilterPanel.this.activateQuickFilter();
            }
        });
        this.activateQuickFilterTimer.setRepeats(false);
        this.activateQuickFilterTimer.setInitialDelay(500);
    }

    private void initializeComponent() {
        this.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("6dlu, right:d, 2dlu, d, 2dlu, d, 8dlu, right:d, 2dlu, d, 2dlu, d, 6dlu", "6dlu, p, 4dlu, p, 4dlu, p, 6dlu,");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        layout.setColumnGroups(new int[][]{{2, 8}, {4, 10}, {6, 12}});
        JLabel label = panelBuilder.addLabel(Localizer.getString("SearchTab_WithTerms"), cc.xywh(2, 2, 1, 1));
        label.setToolTipText(Localizer.getString("SearchTab_TTTWithTerms"));
        QuickFilterActivationHandler activationHandler = new QuickFilterActivationHandler();
        this.withTermsTF = new JTextField(8);
        this.withTermsTF.addKeyListener(activationHandler);
        this.withTermsTF.setToolTipText(Localizer.getString("SearchTab_TTTWithTerms"));
        Keymap keymap = JTextField.addKeymap("SearchFilterTextEditor", this.withTermsTF.getKeymap());
        this.withTermsTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.withTermsTF);
        panelBuilder.add((Component)this.withTermsTF, cc.xywh(4, 2, 3, 1));
        label = panelBuilder.addLabel(Localizer.getString("SearchTab_WithoutTerms"), cc.xywh(8, 2, 1, 1));
        label.setToolTipText(Localizer.getString("SearchTab_TTTWithoutTerms"));
        this.withoutTermsTF = new JTextField(8);
        this.withoutTermsTF.addKeyListener(activationHandler);
        this.withoutTermsTF.setToolTipText(Localizer.getString("SearchTab_TTTWithoutTerms"));
        keymap = JTextField.addKeymap("SearchFilterTextEditor", this.withoutTermsTF.getKeymap());
        this.withoutTermsTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.withoutTermsTF);
        panelBuilder.add((Component)this.withoutTermsTF, cc.xywh(10, 2, 3, 1));
        label = panelBuilder.addLabel(Localizer.getString("SearchTab_FileType"), cc.xywh(2, 4, 1, 1));
        label.setToolTipText(Localizer.getString("SearchTab_TTTFileType"));
        this.mediaTypeComboBox = new JComboBox<MediaType>(MediaType.getAllMediaTypes());
        this.mediaTypeComboBox.addItemListener(activationHandler);
        this.mediaTypeComboBox.setRenderer(new MediaTypeListRenderer());
        panelBuilder.add((Component)this.mediaTypeComboBox, cc.xywh(4, 4, 3, 1));
        label = panelBuilder.addLabel(Localizer.getString("SearchTab_MinFileSize"), cc.xywh(2, 6, 1, 1));
        label.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        this.minFileSizeTF = new IntegerTextField(9);
        this.minFileSizeTF.addKeyListener(activationHandler);
        this.minFileSizeTF.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        keymap = JTextField.getKeymap("SearchFilterTextEditor");
        this.minFileSizeTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.minFileSizeTF);
        panelBuilder.add((Component)this.minFileSizeTF, cc.xywh(4, 6, 1, 1));
        this.minFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.minFileSizeUnitComboBox.addItemListener(activationHandler);
        this.minFileSizeUnitComboBox.setToolTipText(Localizer.getString("SearchTab_TTTMinFileSize"));
        panelBuilder.add((Component)this.minFileSizeUnitComboBox, cc.xywh(6, 6, 1, 1));
        label = panelBuilder.addLabel(Localizer.getString("SearchTab_MaxFileSize"), cc.xywh(8, 6, 1, 1));
        label.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        this.maxFileSizeTF = new IntegerTextField(9);
        this.maxFileSizeTF.addKeyListener(activationHandler);
        this.maxFileSizeTF.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        keymap = JTextField.getKeymap("SearchFilterTextEditor");
        this.maxFileSizeTF.setKeymap(keymap);
        GUIUtils.assignKeymapToTextField(keymap, this.maxFileSizeTF);
        panelBuilder.add((Component)this.maxFileSizeTF, cc.xywh(10, 6, 1, 1));
        this.maxFileSizeUnitComboBox = new FWSizeDefComboBox();
        this.maxFileSizeUnitComboBox.addItemListener(activationHandler);
        this.maxFileSizeUnitComboBox.setToolTipText(Localizer.getString("SearchTab_TTTMaxFileSize"));
        panelBuilder.add((Component)this.maxFileSizeUnitComboBox, cc.xywh(12, 6, 1, 1));
    }

    private void activateQuickFilter() {
        StringTokenizer tokenizer;
        String terms;
        FilenameCondition cond;
        if (this.currentResultsDataModel == null) {
            return;
        }
        if (this.currentQuickFilterRule == null) {
            this.currentQuickFilterRule = new Rule();
            this.currentQuickFilterRule.setName(QUICK_FILTER_RULE_NAME);
            this.currentQuickFilterRule.addConsequence(FilterFromSearchConsequence.INSTANCE);
        }
        this.currentQuickFilterRule.clearConditions();
        OrConcatCondition orCondition = new OrConcatCondition();
        if (this.withTermsTF.getText().trim().length() > 0) {
            cond = new FilenameCondition();
            terms = this.withTermsTF.getText();
            tokenizer = new StringTokenizer(terms, " ");
            while (tokenizer.hasMoreTokens()) {
                cond.addTerm(tokenizer.nextToken());
            }
            orCondition.addCondition(new NotCondition(cond));
        }
        if (this.withoutTermsTF.getText().trim().length() > 0) {
            cond = new FilenameCondition();
            terms = this.withoutTermsTF.getText();
            tokenizer = new StringTokenizer(terms, " ");
            while (tokenizer.hasMoreTokens()) {
                cond.addTerm(tokenizer.nextToken());
            }
            orCondition.addCondition(cond);
        }
        MediaType mediaType = (MediaType)this.mediaTypeComboBox.getSelectedItem();
        orCondition.addCondition(new NotCondition(new MediaTypeCondition(mediaType)));
        String minSizeStr = this.minFileSizeTF.getText().trim();
        long finalMinSize = -1L;
        try {
            if (minSizeStr.length() > 0) {
                long minSize = Integer.parseInt(minSizeStr);
                long minSizeMultiplier = this.minFileSizeUnitComboBox.getDefMultiplier();
                finalMinSize = minSizeMultiplier * minSize;
            }
        }
        catch (NumberFormatException minSize) {
            // empty catch block
        }
        String maxSizeStr = this.maxFileSizeTF.getText().trim();
        long finalMaxSize = -1L;
        try {
            if (maxSizeStr.length() > 0) {
                long maxSize = Integer.parseInt(maxSizeStr);
                long maxSizeMultiplier = this.maxFileSizeUnitComboBox.getDefMultiplier();
                finalMaxSize = maxSizeMultiplier * maxSize;
            }
        }
        catch (NumberFormatException maxSize) {
            // empty catch block
        }
        if (finalMinSize >= 0L || finalMaxSize >= 0L) {
            FileSizeCondition fileSizeCond = new FileSizeCondition(finalMinSize, finalMaxSize);
            orCondition.addCondition(new NotCondition(fileSizeCond));
        }
        if (orCondition.getConditionCount() > 0) {
            this.currentQuickFilterRule.addCondition(orCondition);
        }
        this.currentResultsDataModel.setQuickFilterRule(this.currentQuickFilterRule);
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.currentResultsDataModel = null;
        this.currentQuickFilterRule = null;
        Rule quickFilterRule = null;
        if (searchResultsDataModel != null) {
            quickFilterRule = searchResultsDataModel.getQuickFilterRule();
        }
        this.withTermsTF.setText("");
        this.withoutTermsTF.setText("");
        this.mediaTypeComboBox.setSelectedIndex(0);
        this.minFileSizeTF.setText("");
        this.maxFileSizeTF.setText("");
        if (quickFilterRule != null) {
            List<Condition> conditions = quickFilterRule.getConditions();
            Iterator<Condition> condIterator = conditions.iterator();
            if (condIterator.hasNext()) {
                conditions = ((OrConcatCondition)condIterator.next()).getConditions();
                condIterator = conditions.iterator();
            }
            while (condIterator.hasNext()) {
                Iterator<String> iterator;
                Set<String> terms;
                StringBuffer buffer;
                FilenameCondition filenameCondition;
                Condition condition = condIterator.next();
                if (condition instanceof NotCondition) {
                    int i;
                    FileSizeCondition fileSizeCondition;
                    Set<FileSizeCondition.Range> ranges;
                    Iterator<Object> iterator2;
                    if ((condition = ((NotCondition)condition).getContainedCondition()) instanceof FilenameCondition) {
                        filenameCondition = (FilenameCondition)condition;
                        buffer = new StringBuffer();
                        terms = filenameCondition.getTerms();
                        if (terms.size() > 0) {
                            iterator = terms.iterator();
                            while (iterator.hasNext()) {
                                buffer.append(iterator.next());
                                if (!iterator.hasNext()) continue;
                                buffer.append(" ");
                            }
                        }
                        this.withTermsTF.setText(buffer.toString());
                        continue;
                    }
                    if (condition instanceof MediaTypeCondition) {
                        MediaTypeCondition mediaTypeCondition = (MediaTypeCondition)condition;
                        Set<MediaType> types = mediaTypeCondition.getTypes();
                        iterator2 = types.iterator();
                        if (!iterator2.hasNext()) continue;
                        MediaType type = (MediaType)iterator2.next();
                        this.mediaTypeComboBox.setSelectedItem(type);
                        continue;
                    }
                    if (!(condition instanceof FileSizeCondition) || !(iterator2 = (ranges = (fileSizeCondition = (FileSizeCondition)condition).getRanges()).iterator()).hasNext()) continue;
                    FileSizeCondition.Range range = (FileSizeCondition.Range)iterator2.next();
                    if (range.min > 0L) {
                        this.minFileSizeUnitComboBox.setSelectedIndex(0);
                        long displayVal = range.min;
                        for (i = FWSizeDefComboBox.SIZE_DEFINITIONS.length - 1; i >= 0; --i) {
                            FWSizeDefComboBox.SizeDefinition currentDef = FWSizeDefComboBox.SIZE_DEFINITIONS[i];
                            long mod = range.min % currentDef.getMultiplier();
                            if (mod != 0L) continue;
                            this.minFileSizeUnitComboBox.setSelectedIndex(i);
                            displayVal = range.min / currentDef.getMultiplier();
                            break;
                        }
                        this.minFileSizeTF.setText(String.valueOf(displayVal));
                    }
                    if (range.max <= 0L) continue;
                    this.maxFileSizeUnitComboBox.setSelectedIndex(0);
                    long displayVal = range.max;
                    for (i = FWSizeDefComboBox.SIZE_DEFINITIONS.length - 1; i >= 0; --i) {
                        FWSizeDefComboBox.SizeDefinition currentDef = FWSizeDefComboBox.SIZE_DEFINITIONS[i];
                        long mod = range.max % currentDef.getMultiplier();
                        if (mod != 0L) continue;
                        this.maxFileSizeUnitComboBox.setSelectedIndex(i);
                        displayVal = range.min / currentDef.getMultiplier();
                        break;
                    }
                    this.maxFileSizeTF.setText(String.valueOf(displayVal));
                    continue;
                }
                if (!(condition instanceof FilenameCondition)) continue;
                filenameCondition = (FilenameCondition)condition;
                buffer = new StringBuffer();
                terms = filenameCondition.getTerms();
                if (terms.size() > 0) {
                    iterator = terms.iterator();
                    while (iterator.hasNext()) {
                        buffer.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        buffer.append(" ");
                    }
                }
                this.withoutTermsTF.setText(buffer.toString());
            }
        }
        this.currentResultsDataModel = searchResultsDataModel;
        this.currentQuickFilterRule = quickFilterRule;
    }

    private class QuickFilterActivationHandler
    extends KeyAdapter
    implements ItemListener {
        private QuickFilterActivationHandler() {
        }

        public void keyTyped(KeyEvent e) {
            QuickFilterPanel.this.activateQuickFilterTimer.restart();
        }

        public void itemStateChanged(ItemEvent e) {
            QuickFilterPanel.this.activateQuickFilterTimer.restart();
        }
    }
}

