/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.ContainerEvent;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.WhatsNewSearch;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchListTableModel
extends FWSortableTableModel {
    public static final int SEARCH_TERM_MODEL_INDEX = 0;
    public static final int RESULT_COUNT_MODEL_INDEX = 1;
    public static final int FILTERED_COUNT_MODEL_INDEX = 2;
    public static final int PROGRESS_MODEL_INDEX = 3;
    public static final int STATUS_MODEL_INDEX = 4;
    public static final int SEARCH_TERM_COLUMN_ID = 1001;
    public static final int RESULT_COUNT_COLUMN_ID = 1002;
    public static final int FILTERED_COUNT_COLUMN_ID = 1003;
    public static final int PROGRESS_COLUMN_ID = 1004;
    public static final int STATUS_COLUMN_ID = 1005;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004, 1005};
    private static String[] tableColumns = new String[]{Localizer.getString("SearchTerm"), Localizer.getString("Results"), Localizer.getString("Filtered"), Localizer.getString("Progress"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{String.class, Integer.class, Integer.class, ProgressCellRenderer.class, String.class};
    private SearchContainer searchContainer;

    public SearchListTableModel(SearchContainer searchContainer) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        this.searchContainer = searchContainer;
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    @Override
    public int getRowCount() {
        return this.searchContainer.getSearchCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Search search = this.searchContainer.getSearchAt(row);
        if (search == null) {
            return "";
        }
        switch (col) {
            case 0: {
                if (search instanceof KeywordSearch) {
                    return ((KeywordSearch)search).getSearchString();
                }
                if (search instanceof WhatsNewSearch) {
                    return Localizer.getString("SearchTab_WhatsNewSearch");
                }
                if (search instanceof BrowseHostResults) {
                    return Localizer.getFormatedString("SearchTab_BrowsingHost", ((BrowseHostResults)search).getDestAddress().getFullHostName());
                }
                throw new RuntimeException("Unknwon search type");
            }
            case 1: {
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                return dataModel.getSearchElementCount();
            }
            case 2: {
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                return dataModel.getFilteredElementCount();
            }
            case 3: {
                return search.getProgress();
            }
            case 4: {
                if (search.isSearching()) {
                    return Localizer.getString("Searching");
                }
                return Localizer.getString("Search_Stopped");
            }
        }
        return "";
    }

    @Override
    public Object getComparableValueAt(int row, int column) {
        return this.getValueAt(row, column);
    }

    @Override
    public Comparator<?> getColumnComparator(int column) {
        switch (column) {
            case 3: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    @Override
    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    @EventTopicSubscriber(topic="phex:search/update")
    public void onSearchUpdateEvent(String topic, final ContainerEvent event) {
        if (this.searchContainer != event.getContainer()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    SearchListTableModel.this.fireTableChanged(new TableModelEvent(SearchListTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    SearchListTableModel.this.fireTableChanged(new TableModelEvent(SearchListTableModel.this, position, position, -1, -1));
                }
            }
        });
    }
}

