/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.QueryRoutingTable;
import phex.common.format.NumberFormatUtils;
import phex.common.format.TimeFormatUtils;
import phex.event.ContainerEvent;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.DestAddressComparator;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.host.Host;
import phex.host.HostInfo;
import phex.host.NetworkHostsContainer;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkTableModel
extends FWSortableTableModel {
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int TYPE_MODEL_INDEX = 2;
    public static final int MODE_MODEL_INDEX = 3;
    public static final int RECEIVED_DROPPED_MODEL_INDEX = 4;
    public static final int SENT_QUEUED_MODEL_INDEX = 5;
    public static final int SHARED_MODEL_INDEX = 6;
    public static final int QRT_MODEL_INDEX = 7;
    public static final int UPTIME_MODEL_INDEX = 8;
    public static final int STATUS_MODEL_INDEX = 9;
    private static final Integer HOST_COLUMN_ID = 1001;
    private static final Integer VENDOR_COLUMN_ID = 1002;
    private static final Integer TYPE_COLUMN_ID = 1003;
    private static final Integer RECEIVED_DROPPED_COLUMN_ID = 1004;
    private static final Integer SENT_QUEUED_COLUMN_ID = 1005;
    private static final Integer SHARED_COLUMN_ID = 1007;
    private static final Integer UPTIME_COLUMN_ID = 1008;
    private static final Integer STATUS_COLUMN_ID = 1009;
    private static final Integer MODE_COLUMN_ID = 1010;
    private static final Integer QRT_COLUMN_ID = 1011;
    private static final Integer[] COLUMN_IDS = new Integer[]{HOST_COLUMN_ID, VENDOR_COLUMN_ID, TYPE_COLUMN_ID, MODE_COLUMN_ID, RECEIVED_DROPPED_COLUMN_ID, SENT_QUEUED_COLUMN_ID, SHARED_COLUMN_ID, QRT_COLUMN_ID, UPTIME_COLUMN_ID, STATUS_COLUMN_ID};
    private static final String[] tableColumns = new String[]{Localizer.getString("RemoteHost"), Localizer.getString("Vendor"), Localizer.getString("Type"), Localizer.getString("Mode"), Localizer.getString("ReceivedDropped"), Localizer.getString("SentQueuedDropped"), Localizer.getString("Shared"), Localizer.getString("QRT"), Localizer.getString("Uptime"), Localizer.getString("Status")};
    private static final Class<?>[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private NetworkHostsContainer hostsContainer;

    public NetworkTableModel(NetworkHostsContainer hostsContainer) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        this.hostsContainer = hostsContainer;
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    @Override
    public int getRowCount() {
        return this.hostsContainer.getNetworkHostCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Host host = this.hostsContainer.getNetworkHostAt(row);
        if (host == null) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        switch (col) {
            case 0: {
                return host.getHostAddress();
            }
            case 1: {
                return host.getVendor();
            }
            case 2: {
                switch (host.getType()) {
                    case OUTGOING: {
                        return Localizer.getString("HostType_Outgoing");
                    }
                    case INCOMING: {
                        return Localizer.getString("HostType_Incoming");
                    }
                }
                return "";
            }
            case 3: {
                if (!host.isConnected()) {
                    return "";
                }
                if (host.isUltrapeer()) {
                    String mode = Localizer.getString("Ultrapeer");
                    if (host.getPushProxyAddress() != null) {
                        mode = mode + " (PP)";
                    }
                    return mode;
                }
                if (host.isUltrapeerLeafConnection()) {
                    return Localizer.getString("Leaf");
                }
                return Localizer.getString("Peer");
            }
            case 4: {
                return String.valueOf(host.getReceivedCount() + " (" + String.valueOf(host.getDropCount()) + ")");
            }
            case 5: {
                return String.valueOf(host.getSentCount()) + " / " + String.valueOf(host.getSendQueueLength()) + " / " + String.valueOf(host.getSendDropCount());
            }
            case 6: {
                if (host.getFileCount() == -1L) {
                    return "";
                }
                return host.getFileCount() + "/" + NumberFormatUtils.formatSignificantByteSize(host.getTotalSize() * 1024L);
            }
            case 7: {
                QueryRoutingTable qrt = host.getLastReceivedRoutingTable();
                if (qrt == null) {
                    return "";
                }
                return NumberFormatUtils.formatDecimal(qrt.getFillRatio(), 2) + "% / " + NumberFormatUtils.formatDecimal((double)qrt.getTableSize() / 1024.0, 0) + "K";
            }
            case 8: {
                long upSeconds = host.getConnectionUpTime(System.currentTimeMillis()) / 1000L;
                return TimeFormatUtils.formatSignificantElapsedTime(upSeconds);
            }
            case 9: {
                return HostInfo.getHostStatusString(host);
            }
        }
        return "";
    }

    @Override
    public Comparator<?> getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new DestAddressComparator();
            }
        }
        return null;
    }

    @Override
    public Object getComparableValueAt(int row, int column) {
        switch (column) {
            case 8: {
                Host host = this.hostsContainer.getNetworkHostAt(row);
                if (host == null) {
                    return Long.MIN_VALUE;
                }
                return host.getConnectionUpTime(System.currentTimeMillis());
            }
        }
        return this.getValueAt(row, column);
    }

    @Override
    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public boolean isColumnDefaultVisible(int columnIndex) {
        return columnIndex != 7;
    }

    @EventTopicSubscriber(topic="phex:net/hosts")
    public void onNetworkHostsEvent(String topic, final ContainerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    NetworkTableModel.this.fireTableChanged(new TableModelEvent(NetworkTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    NetworkTableModel.this.fireTableChanged(new TableModelEvent(NetworkTableModel.this, position, position, -1, -1));
                }
            }
        });
    }
}

