/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.security;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.common.log.NLogger;
import phex.gui.common.BanneredDialog;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IPTextField;
import phex.gui.common.IntegerTextField;
import phex.security.IpUserSecurityRule;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.Localizer;

public class SecurityRuleDialog
extends BanneredDialog {
    private CloseEventHandler closeEventHandler;
    private JTextField descriptionTF;
    private JCheckBox disableRuleCkBx;
    private IPTextField ipTF;
    private IntegerTextField cidrTF;
    private JComboBox expiresCBox;
    private JLabel daysLabel;
    private IntegerTextField daysTF;
    private JLabel hoursLabel;
    private IntegerTextField hoursTF;
    private JLabel minutesLabel;
    private IntegerTextField minutesTF;
    private JCheckBox isDeletedOnExpiryCkbx;
    private JButton okBtn;
    private JButton cancelBtn;
    private IpUserSecurityRule securityRule;

    public SecurityRuleDialog() {
        this((IpUserSecurityRule)null);
    }

    public SecurityRuleDialog(IpUserSecurityRule rule) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("SecurityRuleDialog_DialogTitle"), false, null, Localizer.getString("SecurityRuleDialog_BannerSubHeader"));
        this.securityRule = rule;
        if (this.securityRule == null) {
            this.setBannerHeaderText(Localizer.getString("SecurityRuleDialog_BannerHeader_New"));
        } else {
            this.setBannerHeaderText(Localizer.getString("SecurityRuleDialog_BannerHeader_Edit"));
        }
        this.initContent();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void customPrefillBanSingleIp(String description, byte[] hostIp) {
        this.descriptionTF.setText(description);
        this.ipTF.setIPString(AddressUtils.ip2string(hostIp));
        this.cidrTF.setText("32");
        this.disableRuleCkBx.setSelected(false);
        this.expiresCBox.setSelectedIndex(1);
        this.isDeletedOnExpiryCkbx.setSelected(false);
    }

    private void initComponents() {
        this.closeEventHandler = new CloseEventHandler();
        this.addWindowListener(this.closeEventHandler);
        this.descriptionTF = new JTextField(40);
        this.disableRuleCkBx = new JCheckBox(Localizer.getString("SecurityRuleDialog_DisableRule"));
        this.ipTF = new IPTextField();
        this.cidrTF = new IntegerTextField(2, 2);
        String[] expireArr = new String[]{Localizer.getString("SecurityRuleDialog_Never"), Localizer.getString("SecurityRuleDialog_EndOfSession"), Localizer.getString("SecurityRuleDialog_After")};
        this.expiresCBox = new JComboBox<String>(expireArr);
        this.expiresCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SecurityRuleDialog.this.refreshExpiryDisplayState();
            }
        });
        this.daysTF = new IntegerTextField(4);
        this.hoursTF = new IntegerTextField(4);
        this.minutesTF = new IntegerTextField(4);
        this.isDeletedOnExpiryCkbx = new JCheckBox(Localizer.getString("SecurityRuleDialog_DeleteRuleAfterExpiry"));
        this.isDeletedOnExpiryCkbx.setToolTipText(Localizer.getString("SecurityRuleDialog_TTTDeleteRuleAfterExpiry"));
        this.okBtn = new JButton(Localizer.getString("SecurityRuleDialog_OK"));
        this.okBtn.setDefaultCapable(true);
        this.okBtn.setRequestFocusEnabled(true);
        this.okBtn.addActionListener(new OkBtnListener());
        this.getRootPane().setDefaultButton(this.okBtn);
        this.cancelBtn = new JButton(Localizer.getString("SecurityRuleDialog_Cancel"));
        this.cancelBtn.addActionListener(this.closeEventHandler);
    }

    private void initContent() {
        if (this.securityRule == null) {
            return;
        }
        this.descriptionTF.setText(this.securityRule.getDescription());
        this.ipTF.setIPString(AddressUtils.ip2string(this.securityRule.getIp()));
        this.cidrTF.setText(String.valueOf(this.securityRule.getCidr()));
        this.disableRuleCkBx.setSelected(this.securityRule.isDisabled());
        ExpiryDate expiryDate = this.securityRule.getExpiryDate();
        if (expiryDate.isExpiringNever()) {
            this.expiresCBox.setSelectedIndex(0);
        } else if (expiryDate.isExpiringEndOfSession()) {
            this.expiresCBox.setSelectedIndex(1);
        } else {
            this.expiresCBox.setSelectedIndex(2);
            this.initAfterExpiryDateContent(expiryDate);
        }
        this.isDeletedOnExpiryCkbx.setSelected(this.securityRule.isDeletedOnExpiry());
    }

    protected JPanel createDialogContentPanel() {
        this.initComponents();
        JPanel contentPanel = new JPanel();
        FormLayout layout = new FormLayout("7dlu, d, 3dlu, d, 1dlu, d, 1dlu, d, fill:d:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, contentPanel);
        builder.setLeadingColumnOffset(1);
        builder.appendSeparator(Localizer.getString("SecurityRuleDialog_SecurityRule"));
        builder.append(Localizer.getString("SecurityRuleDialog_Description"), (Component)this.descriptionTF, 6);
        builder.append((Component)this.disableRuleCkBx, 8);
        builder.appendSeparator(Localizer.getString("SecurityRuleDialog_NetworkAddress"));
        builder.append(Localizer.getString("SecurityRuleDialog_IP_CIDR"), (Component)this.ipTF);
        builder.append(Localizer.getString("SecurityRuleDialog_IP_CIDR_Separator"), (Component)this.cidrTF, true);
        builder.appendSeparator(Localizer.getString("SecurityRuleDialog_Options"));
        builder.append(Localizer.getString("SecurityRuleDialog_Expires"), (Component)this.expiresCBox, 5);
        builder.append(Box.createGlue());
        builder.append((Component)this.createTimePanel(), 6);
        builder.append(Box.createGlue());
        builder.append((Component)this.isDeletedOnExpiryCkbx, 6);
        this.refreshExpiryDisplayState();
        return contentPanel;
    }

    protected JPanel createDialogButtonPanel() {
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(this.okBtn, this.cancelBtn);
        return btnPanel;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel createTimePanel() {
        JPanel timePanel = new JPanel();
        FormLayout layout = new FormLayout("d, 1dlu, d, 3dlu, d, 1dlu, d, 3dlu, d, 1dlu, d", "p");
        PanelBuilder panelBuilder = new PanelBuilder(layout, timePanel);
        panelBuilder.add(this.daysTF);
        panelBuilder.setColumn(3);
        this.daysLabel = panelBuilder.addLabel(Localizer.getString("SecurityRuleDialog_Days"));
        panelBuilder.setColumn(5);
        panelBuilder.add(this.hoursTF);
        panelBuilder.setColumn(7);
        this.hoursLabel = panelBuilder.addLabel(Localizer.getString("SecurityRuleDialog_Hours"));
        panelBuilder.setColumn(9);
        panelBuilder.add(this.minutesTF);
        panelBuilder.setColumn(11);
        this.minutesLabel = panelBuilder.addLabel(Localizer.getString("SecurityRuleDialog_Minutes"));
        return timePanel;
    }

    private void initAfterExpiryDateContent(ExpiryDate expiryDate) {
        int minutes;
        int hours;
        int days;
        long currentTime;
        long time = expiryDate.getTime();
        long timeDiff = time - (currentTime = System.currentTimeMillis());
        if (timeDiff <= 0L) {
            days = 0;
            hours = 0;
            minutes = 0;
        } else {
            days = (int)Math.floor((double)timeDiff / 8.64E7);
            hours = (int)Math.floor((double)(timeDiff -= (long)days * 86400000L) / 3600000.0);
            minutes = (int)Math.ceil((double)(timeDiff -= (long)hours * 3600000L) / 60000.0);
        }
        this.daysTF.setText(String.valueOf(days));
        this.hoursTF.setText(String.valueOf(hours));
        this.minutesTF.setText(String.valueOf(minutes));
    }

    private void refreshExpiryDisplayState() {
        if (Localizer.getString("SecurityRuleDialog_Never").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(false);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if (Localizer.getString("SecurityRuleDialog_EndOfSession").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.hoursTF.setEnabled(false);
            this.hoursLabel.setEnabled(false);
            this.minutesTF.setEnabled(false);
            this.minutesLabel.setEnabled(false);
        } else if (Localizer.getString("SecurityRuleDialog_After").equals(this.expiresCBox.getSelectedItem())) {
            this.isDeletedOnExpiryCkbx.setEnabled(true);
            this.daysTF.setEnabled(true);
            this.daysLabel.setEnabled(true);
            this.hoursTF.setEnabled(true);
            this.hoursLabel.setEnabled(true);
            this.minutesTF.setEnabled(true);
            this.minutesLabel.setEnabled(true);
        }
    }

    private void validateAndSaveSecurityRule() {
        ExpiryDate expiryDate;
        String description = this.descriptionTF.getText();
        Servent servent = GUIRegistry.getInstance().getServent();
        PhexSecurityManager securityMgr = servent.getSecurityService();
        byte[] ip = this.ipTF.getIP();
        byte cidr = this.cidrTF.getIntegerValue().byteValue();
        boolean isDisabled = this.disableRuleCkBx.isSelected();
        switch (this.expiresCBox.getSelectedIndex()) {
            case 0: {
                expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
                break;
            }
            case 1: {
                expiryDate = ExpiryDate.SESSION_EXPIRY_DATE;
                break;
            }
            case 2: {
                expiryDate = this.createAfterExpiryDate();
                break;
            }
            default: {
                throw new RuntimeException("Unknown expiry type: " + this.expiresCBox.getSelectedIndex());
            }
        }
        boolean isDeletedOnExpiry = this.isDeletedOnExpiryCkbx.isSelected();
        if (this.securityRule == null) {
            securityMgr.createIPAccessRule(description, ip, cidr, isDisabled, expiryDate, isDeletedOnExpiry);
        } else {
            securityMgr.updateIpUserSecurityRule(this.securityRule, description, ip, cidr, isDisabled, expiryDate, isDeletedOnExpiry);
        }
    }

    private ExpiryDate createAfterExpiryDate() {
        Integer minutes;
        Integer hours;
        Integer days = this.daysTF.getIntegerValue();
        if (days == null) {
            days = 0;
        }
        if ((hours = this.hoursTF.getIntegerValue()) == null) {
            hours = 0;
        }
        if ((minutes = this.minutesTF.getIntegerValue()) == null) {
            minutes = 0;
        }
        long currentTime = System.currentTimeMillis();
        return ExpiryDate.getExpiryDate(currentTime += (long)days.intValue() * 86400000L + (long)hours.intValue() * 3600000L + (long)minutes.intValue() * 60000L);
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            SecurityRuleDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            SecurityRuleDialog.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SecurityRuleDialog.this.validateAndSaveSecurityRule();
                SecurityRuleDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }
}

