/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.common.MediaType;
import phex.common.log.NLogger;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.MediaTypeCondition;
import phex.utils.Localizer;

public class MediaTypeCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private MediaTypeCondition orgCondition;
    private MediaTypeCondition condition;
    private JTable mediaTypeTable;
    private MediaTypeModel mediaTypeModel;

    public MediaTypeCondEditor(MediaTypeCondition cond, RuleDescriptionPanel descPanel, JDialog parentDialog) {
        super(parentDialog, Localizer.getString("MediaTypeCondEditor_DialogTitle"), true);
        this.ruleDescPanel = descPanel;
        this.orgCondition = cond;
        this.condition = new MediaTypeCondition(cond);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, d:grow, 4dlu", "4dlu, p, 2dlu, fill:100dlu:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        JLabel label = new JLabel(Localizer.getString("MediaTypeCondEditor_ConditionToAdd"));
        contentPB.add((Component)label, cc.xywh(2, 2, 1, 1));
        this.mediaTypeModel = new MediaTypeModel();
        this.mediaTypeTable = new JTable(this.mediaTypeModel);
        JTableHeader tableHeader = this.mediaTypeTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        JCheckBox box = (JCheckBox)((Object)this.mediaTypeTable.getDefaultRenderer(Boolean.class));
        TableColumn column = this.mediaTypeTable.getColumnModel().getColumn(0);
        column.setMaxWidth(box.getPreferredSize().width + 2);
        column.setMinWidth(box.getPreferredSize().width + 2);
        this.mediaTypeTable.getColumnModel().getColumn(1).setCellRenderer(new MediaTypeCellRenderer());
        contentPB.add((Component)new JScrollPane(this.mediaTypeTable), cc.xywh(2, 4, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        okBtn.setDefaultCapable(true);
        okBtn.setRequestFocusEnabled(true);
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(okBtn);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class MediaTypeCellRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            if (value instanceof MediaType) {
                MediaType mediaType = (MediaType)value;
                this.setText(Localizer.getString(mediaType.getName()));
                this.setToolTipText(mediaType.getFileTypesUIText());
            }
        }
    }

    private final class MediaTypeModel
    extends AbstractTableModel {
        protected Object[][] conditionTypes = new Object[MediaType.getAllMediaTypes().length][2];

        public MediaTypeModel() {
            MediaType[] mediaTypes = MediaType.getAllMediaTypes();
            Set<MediaType> types = MediaTypeCondEditor.this.condition.getTypes();
            for (int i = 0; i < mediaTypes.length; ++i) {
                this.conditionTypes[i][0] = types.contains(mediaTypes[i]) ? Boolean.TRUE : Boolean.FALSE;
                this.conditionTypes[i][1] = mediaTypes[i];
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.conditionTypes.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.conditionTypes[rowIndex][columnIndex];
        }

        public String getColumnName(int column) {
            return "";
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Boolean bolVal = (Boolean)aValue;
            this.conditionTypes[row][0] = aValue;
            if (bolVal.booleanValue()) {
                MediaTypeCondEditor.this.condition.addType((MediaType)this.conditionTypes[row][1]);
            } else {
                MediaTypeCondEditor.this.condition.removeType((MediaType)this.conditionTypes[row][1]);
            }
        }

        public int getRowOf(MediaType mediaType) {
            for (int i = 0; i < this.conditionTypes.length; ++i) {
                if (this.conditionTypes[i][1] != mediaType) continue;
                return i;
            }
            return -1;
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            MediaTypeCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            MediaTypeCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MediaTypeCondEditor.this.orgCondition.update(MediaTypeCondEditor.this.condition);
                MediaTypeCondEditor.this.ruleDescPanel.updateRuleData();
                MediaTypeCondEditor.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }
}

