/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.statusbar;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.format.NumberFormatUtils;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconPack;
import phex.utils.Localizer;

public class DownloadZone
extends JPanel {
    private SwarmingManager swarmingMgr;
    private BandwidthManager bwMgr;
    private JLabel downloadLabel;
    private JLabel bwLabel;

    public DownloadZone(SwarmingManager downloadService, BandwidthManager bandwidthMgr) {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.swarmingMgr = downloadService;
        this.bwMgr = bandwidthMgr;
        this.downloadLabel = new JLabel();
        this.add(this.downloadLabel);
        this.bwLabel = new JLabel();
        this.add(this.bwLabel);
        this.updateZone();
        layout.putConstraint("West", (Component)this.downloadLabel, 5, "West", (Component)this);
        layout.putConstraint("North", (Component)this.downloadLabel, 3, "North", (Component)this);
        layout.putConstraint("West", (Component)this.bwLabel, 5, "East", (Component)this.downloadLabel);
        layout.putConstraint("North", (Component)this.bwLabel, 3, "North", (Component)this);
        layout.putConstraint("East", (Component)this, 5, "East", (Component)this.bwLabel);
        this.setupIcons();
    }

    private void setupIcons() {
        IconPack factory = GUIRegistry.getInstance().getPlafIconPack();
        this.downloadLabel.setIcon(factory.getIcon("StatusBar.Download"));
    }

    public void updateZone() {
        Object[] args = new Object[]{this.swarmingMgr.getDownloadFileCount(2), this.swarmingMgr.getDownloadFileCount(), this.swarmingMgr.getDownloadFileCount(6)};
        String text = Localizer.getFormatedString("StatusBar_Downloads", args);
        this.downloadLabel.setText(text);
        this.downloadLabel.setToolTipText(Localizer.getString("StatusBar_TTTDownloads"));
        BandwidthController bwController = this.bwMgr.getDownloadBandwidthController();
        long transferRate = bwController.getShortTransferAvg().getAverage();
        long throttlingRate = bwController.getThrottlingRate();
        String transferRateStr = NumberFormatUtils.formatSignificantByteSize(transferRate);
        String throttlingRateStr = throttlingRate >= Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(throttlingRate);
        this.bwLabel.setText(transferRateStr + Localizer.getString("PerSec") + " (" + throttlingRateStr + ")");
        this.validate();
    }
}

