/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.menubar;

import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.OpenURLAction;
import phex.gui.actions.ToggleStatusbarAction;
import phex.gui.actions.ToggleToolbarAction;
import phex.gui.common.FWMenu;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconPack;
import phex.gui.common.MainFrame;
import phex.gui.common.menubar.RescanSharedFilesAction;
import phex.gui.common.menubar.ViewAboutAction;
import phex.gui.common.menubar.ViewOptionsAction;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;

public class MainMenuBar
extends JMenuBar {
    private FWMenu viewMenu;
    private ToggleToolbarAction toggleToolbarAction;
    private ToggleStatusbarAction toggleStatusbarAction;
    private JMenuItem phexHomeLink;
    private JMenuItem phexForumLink;

    public MainMenuBar(MainFrame mainFrame, DGuiSettings dSettings) {
        JMenu networkMenu = new JMenu(Localizer.getString("Network"));
        networkMenu.setMnemonic(Localizer.getChar("NetworkMnemonic"));
        GUIRegistry guiRegistry = GUIRegistry.getInstance();
        FWMenu newMenu = new FWMenu(Localizer.getString("New"));
        FWAction action = guiRegistry.getGlobalAction("NewDownloadAction");
        newMenu.addAction(action);
        networkMenu.add(newMenu);
        action = guiRegistry.getGlobalAction("ConnectNetworkAction");
        networkMenu.add(action);
        action = guiRegistry.getGlobalAction("DisconnectNetworkAction");
        networkMenu.add(action);
        networkMenu.addSeparator();
        action = guiRegistry.getGlobalAction("SwitchNetworkAction");
        networkMenu.add(action);
        networkMenu.addSeparator();
        action = guiRegistry.getGlobalAction("ExitPhexAction");
        networkMenu.add(action);
        this.add(networkMenu);
        this.viewMenu = new FWMenu(Localizer.getString("View"));
        this.viewMenu.addMenuListener(new ViewMenuListener());
        this.viewMenu.setMnemonic(Localizer.getChar("ViewMnemonic"));
        this.add(this.viewMenu);
        boolean isToolbarVisible = true;
        if (dSettings != null && dSettings.isSetToolbarVisible()) {
            isToolbarVisible = dSettings.isToolbarVisible();
        }
        this.toggleToolbarAction = new ToggleToolbarAction(isToolbarVisible);
        boolean isStatusbarVisible = true;
        if (dSettings != null && dSettings.isSetStatusbarVisible()) {
            isStatusbarVisible = dSettings.isStatusbarVisible();
        }
        this.toggleStatusbarAction = new ToggleStatusbarAction(isStatusbarVisible);
        FWMenu settingsMenu = new FWMenu(Localizer.getString("Settings"));
        settingsMenu.setMnemonic(Localizer.getChar("SettingsMnemonic"));
        action = new ViewOptionsAction();
        settingsMenu.addAction(action);
        settingsMenu.addSeparator();
        action = new RescanSharedFilesAction();
        settingsMenu.addAction(action);
        this.add(settingsMenu);
        FWMenu helpMenu = new FWMenu(Localizer.getString("Help"));
        helpMenu.setMnemonic(Localizer.getChar("HelpMnemonic"));
        this.phexHomeLink = helpMenu.addAction(new OpenURLAction(Localizer.getString("PhexHomepage"), "http://www.phex.org", null, Localizer.getString("TTTPhexHomepage"), Integer.valueOf(Localizer.getChar("PhexHomepageMnemonic")), null));
        this.phexForumLink = helpMenu.addAction(new OpenURLAction(Localizer.getString("PhexForum"), "http://www.gnutellaforums.com/forumdisplay.php?s=&forumid=16", null, Localizer.getString("TTTPhexForum"), Integer.valueOf(Localizer.getChar("PhexForumMnemonic")), null));
        helpMenu.addSeparator();
        helpMenu.addAction(new ViewAboutAction());
        this.add(helpMenu);
        this.setupIcons();
    }

    private void setupIcons() {
        IconPack plafIconPack = GUIRegistry.getInstance().getPlafIconPack();
        this.phexHomeLink.setIcon(plafIconPack.getIcon("MenuBar.Help.Link"));
        this.phexForumLink.setIcon(plafIconPack.getIcon("MenuBar.Help.Link"));
    }

    private final class ViewMenuListener
    implements MenuListener {
        private ViewMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
            MainMenuBar.this.viewMenu.removeAll();
        }

        public void menuDeselected(MenuEvent e) {
            MainMenuBar.this.viewMenu.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            List list;
            MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
            FWTab tab = mainFrame.getSelectedTab();
            if (tab != null && (list = tab.getViewMenuActions()) != null && list.size() > 0) {
                for (FWAction action : list) {
                    MainMenuBar.this.viewMenu.addAction(action);
                }
                MainMenuBar.this.viewMenu.addSeparator();
            }
            MainMenuBar.this.viewMenu.addAction(MainMenuBar.this.toggleToolbarAction);
            MainMenuBar.this.viewMenu.addAction(MainMenuBar.this.toggleStatusbarAction);
            MainMenuBar.this.viewMenu.addSeparator();
            tab = mainFrame.getTab(1000);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1101);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1003);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1004);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1007);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1005);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1006);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1008);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
            tab = mainFrame.getTab(1009);
            MainMenuBar.this.viewMenu.addAction(tab.getToggleTabViewAction());
        }
    }
}

