/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.DesktopIndicatorListener;
import phex.gui.common.FWLogoPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.SplashWindow;
import phex.gui.common.menubar.MainMenuBar;
import phex.gui.common.statusbar.MainStatusBar;
import phex.gui.dialogs.RespectCopyrightDialog;
import phex.gui.dialogs.configwizard.ConfigurationWizardDialog;
import phex.gui.prefs.UpdatePrefs;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.StatisticsTab;
import phex.gui.tabs.download.SWDownloadTab;
import phex.gui.tabs.library.LibraryTab;
import phex.gui.tabs.network.NetworkTab;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.monitor.ResultMonitorTab;
import phex.gui.tabs.search.monitor.SearchMonitorTab;
import phex.gui.tabs.security.SecurityTab;
import phex.gui.tabs.upload.UploadTab;
import phex.msg.QueryMsg;
import phex.prefs.core.ProxyPrefs;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.servent.Servent;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTab;

public class MainFrame
extends JFrame {
    public static final int NETWORK_TAB_ID = 1000;
    public static final int SEARCH_TAB_ID = 1101;
    public static final int DOWNLOAD_TAB_ID = 1003;
    public static final int UPLOAD_TAB_ID = 1004;
    public static final int SECURITY_TAB_ID = 1005;
    public static final int STATISTICS_TAB_ID = 1006;
    public static final int LIBRARY_TAB_ID = 1007;
    public static final int SEARCH_MONITOR_TAB_ID = 1008;
    public static final int RESULT_MONITOR_TAB_ID = 1009;
    public static final int NETWORK_TAB_INDEX = 0;
    public static final int SEARCH_TAB_INDEX = 1;
    public static final int DOWNLOAD_TAB_INDEX = 2;
    public static final int UPLOAD_TAB_INDEX = 3;
    public static final int LIBRARY_TAB_INDEX = 4;
    public static final int SECURITY_TAB_INDEX = 5;
    public static final int STATISTICS_TAB_INDEX = 6;
    public static final int SEARCH_MONITOR_TAB_INDEX = 7;
    public static final int RESULT_MONITOR_TAB_INDEX = 8;
    private JTabbedPane tabbedPane;
    private JPanel logoPanel;
    private FWToolBar toolbar;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private UploadTab uploadTab;
    private LibraryTab libraryTab;
    private SWDownloadTab swDownloadTab;
    private SecurityTab securityTab;
    private StatisticsTab statisticsTab;
    private SearchMonitorTab searchMonitorTab;
    private ResultMonitorTab resultMonitorTab;
    private MainStatusBar statusBar;

    public MainFrame(SplashWindow splash, DGuiSettings guiSettings) {
        Icon frameIcon = GUIRegistry.getInstance().getSystemIconPack().getIcon("Frame.IconImage");
        if (frameIcon != null) {
            this.setIconImage(((ImageIcon)frameIcon).getImage());
        }
        this.setupComponents(guiSettings);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        DesktopIndicator indicator = GUIRegistry.getInstance().getDesktopIndicator();
        if (indicator != null) {
            indicator.addDesktopIndicatorListener(new DesktopIndicatorHandler());
        }
        this.pack();
        this.initFrameSize(guiSettings);
        this.setTitle();
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    private void initFrameSize(DGuiSettings guiSettings) {
        GUIUtils.centerAndSizeWindow(this, 7, 8);
        if (guiSettings == null) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = this.getBounds();
        if (guiSettings.isSetWindowWidth()) {
            bounds.width = Math.min(screenSize.width, guiSettings.getWindowWidth());
        }
        if (guiSettings.isSetWindowHeight()) {
            bounds.height = Math.min(screenSize.height, guiSettings.getWindowHeight());
        }
        if (guiSettings.isSetWindowPosX()) {
            int posX = guiSettings.getWindowPosX();
            bounds.x = Math.max(0, Math.min(posX + bounds.width, (int)screenSize.getWidth()) - bounds.width);
        }
        if (guiSettings.isSetWindowPosY()) {
            int posY = guiSettings.getWindowPosY();
            bounds.y = Math.max(0, Math.min(posY + bounds.height, (int)screenSize.getHeight()) - bounds.height);
        }
        NLogger.debug(MainFrame.class, (Object)("Frame position: " + bounds));
        this.setBounds(bounds);
    }

    private void setupComponents(DGuiSettings guiSettings) {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(50, 50));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component comp = MainFrame.this.tabbedPane.getSelectedComponent();
                if (comp instanceof FWTab) {
                    ((FWTab)comp).tabSelectedNotify();
                }
            }
        });
        Servent servent = GUIRegistry.getInstance().getServent();
        this.networkTab = new NetworkTab();
        this.networkTab.initComponent(guiSettings);
        this.initializeTab(this.networkTab, 1000, guiSettings);
        QueryManager queryService = servent.getQueryService();
        this.searchTab = new SearchTab(queryService.getSearchContainer(), queryService.getSearchFilterRules(), servent.getDownloadService());
        this.searchTab.initComponent(guiSettings);
        this.initializeTab(this.searchTab, 1101, guiSettings);
        this.swDownloadTab = new SWDownloadTab(servent.getDownloadService());
        this.swDownloadTab.initComponent(guiSettings);
        this.initializeTab(this.swDownloadTab, 1003, guiSettings);
        this.uploadTab = new UploadTab();
        this.uploadTab.initComponent(guiSettings);
        this.initializeTab(this.uploadTab, 1004, guiSettings);
        this.libraryTab = new LibraryTab();
        this.libraryTab.initComponent(guiSettings);
        this.initializeTab(this.libraryTab, 1007, guiSettings);
        this.securityTab = new SecurityTab();
        this.securityTab.initComponent(guiSettings);
        this.initializeTab(this.securityTab, 1005, guiSettings);
        this.statisticsTab = new StatisticsTab();
        this.statisticsTab.initComponent(guiSettings);
        this.initializeTab(this.statisticsTab, 1006, guiSettings);
        QueryHistoryMonitor queryHistoryMonitor = new QueryHistoryMonitor();
        servent.getMessageService().addMessageSubscriber(QueryMsg.class, queryHistoryMonitor);
        this.searchMonitorTab = new SearchMonitorTab(queryHistoryMonitor);
        this.searchMonitorTab.initComponent(guiSettings);
        this.initializeTab(this.searchMonitorTab, 1008, guiSettings);
        this.resultMonitorTab = new ResultMonitorTab(servent.getDownloadService());
        this.resultMonitorTab.initComponent(guiSettings);
        this.initializeTab(this.resultMonitorTab, 1009, guiSettings);
        if (this.tabbedPane.getTabCount() == 0) {
            this.getContentPane().add("Center", this.getLogoPanel());
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.getContentPane().add("Center", this.tabbedPane);
        }
        MainMenuBar menubar = new MainMenuBar(this, guiSettings);
        this.setJMenuBar(menubar);
        menubar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        boolean isToolbarVisible = true;
        if (guiSettings != null && guiSettings.isSetToolbarVisible()) {
            isToolbarVisible = guiSettings.isToolbarVisible();
        }
        if (isToolbarVisible) {
            this.setToolbarVisible(true);
        }
        boolean isStatusbarVisible = true;
        if (guiSettings != null && guiSettings.isSetStatusbarVisible()) {
            isStatusbarVisible = guiSettings.isStatusbarVisible();
        }
        if (isStatusbarVisible) {
            this.setStatusbarVisible(true);
        }
    }

    public void setTitle() {
        StringBuilder builder = new StringBuilder(Environment.getPhexVendor());
        builder.append(" - ");
        builder.append(GUIRegistry.getInstance().getServent().getGnutellaNetwork().getName());
        if (ProxyPrefs.UseSocks5.get().booleanValue()) {
            builder.append("  (via Proxy Server)");
        }
        super.setTitle(builder.toString());
    }

    public void setTabVisible(FWTab tab, boolean state) {
        if (state) {
            int pos;
            int tabCount = this.tabbedPane.getTabCount();
            int modelPos = tab.getIndex();
            if (tabCount == 0) {
                pos = 0;
            } else {
                pos = tabCount;
                FWTab tmpTab = (FWTab)this.tabbedPane.getComponentAt(pos - 1);
                int tmpIdx = tmpTab.getIndex();
                while (tmpIdx > modelPos && --pos != 0) {
                    tmpTab = (FWTab)this.tabbedPane.getComponentAt(pos - 1);
                    tmpIdx = tmpTab.getIndex();
                }
            }
            int orgTabCount = this.tabbedPane.getTabCount();
            if (orgTabCount == 0) {
                this.getContentPane().remove(this.getLogoPanel());
                this.getContentPane().add("Center", this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
            }
            this.tabbedPane.insertTab(tab.getName(), tab.getIcon(), tab, tab.getToolTip(), pos);
            this.tabbedPane.setSelectedIndex(pos);
            if (orgTabCount == 0) {
                tab.setVisible(true);
            }
        } else {
            this.tabbedPane.remove(tab);
            if (this.tabbedPane.getTabCount() == 0) {
                this.getContentPane().remove(this.tabbedPane);
                this.getContentPane().add("Center", this.getLogoPanel());
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
                this.tabbedPane.setVisible(false);
            }
        }
    }

    public void setSelectedTab(int tabID) {
        FWTab tab = this.getTab(tabID);
        this.setSelectedTab(tab);
    }

    public FWTab getSelectedTab() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return (FWTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(FWTab tab) {
        if (tab == null) {
            return;
        }
        FWToggleAction action = tab.getToggleTabViewAction();
        if (!action.isSelected()) {
            action.actionPerformed(new ActionEvent(this, 0, null));
        }
        this.tabbedPane.setSelectedComponent(tab);
    }

    public FWTab getTab(int tabID) {
        switch (tabID) {
            case 1000: {
                return this.networkTab;
            }
            case 1101: {
                return this.searchTab;
            }
            case 1003: {
                return this.swDownloadTab;
            }
            case 1005: {
                return this.securityTab;
            }
            case 1006: {
                return this.statisticsTab;
            }
            case 1004: {
                return this.uploadTab;
            }
            case 1007: {
                return this.libraryTab;
            }
            case 1008: {
                return this.searchMonitorTab;
            }
            case 1009: {
                return this.resultMonitorTab;
            }
        }
        NLogger.warn(MainFrame.class, (Object)("Unknown tab id: " + tabID));
        return null;
    }

    public void saveGUISettings(DGuiSettings dSettings) {
        Rectangle bounds = this.getBounds();
        dSettings.setWindowHeight(bounds.height);
        dSettings.setWindowWidth(bounds.width);
        dSettings.setWindowPosX(bounds.x);
        dSettings.setWindowPosY(bounds.y);
        dSettings.setToolbarVisible(this.toolbar != null);
        this.networkTab.appendDGuiSettings(dSettings);
        this.searchTab.appendDGuiSettings(dSettings);
        this.swDownloadTab.appendDGuiSettings(dSettings);
        this.uploadTab.appendDGuiSettings(dSettings);
        this.libraryTab.appendDGuiSettings(dSettings);
        this.securityTab.appendDGuiSettings(dSettings);
        this.statisticsTab.appendDGuiSettings(dSettings);
        this.searchMonitorTab.appendDGuiSettings(dSettings);
        this.resultMonitorTab.appendDGuiSettings(dSettings);
    }

    private void initializeTab(FWTab tab, int tabID, DGuiSettings guiSettings) {
        DTab dTab = GUIUtils.getDGuiTabById(guiSettings, tabID);
        boolean state = tab.isVisibleByDefault();
        if (dTab != null && dTab.isSetVisible()) {
            state = dTab.isVisible();
        }
        this.setTabVisible(tab, state);
    }

    private JPanel getLogoPanel() {
        if (this.logoPanel == null) {
            ImageIcon icon = new ImageIcon(MainFrame.class.getResource("/phex/resources/splash.png"));
            Image image = icon.getImage();
            this.logoPanel = new FWLogoPanel(image);
            this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        return this.logoPanel;
    }

    public boolean isToolbarVisible() {
        return this.toolbar != null;
    }

    public void setToolbarVisible(boolean state) {
        if (state) {
            if (this.toolbar != null) {
                return;
            }
            this.toolbar = new FWToolBar(0);
            this.toolbar.setShowText(false);
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ExitPhexAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(this.networkTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchTab.getToggleTabViewAction());
            this.toolbar.addAction(this.swDownloadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.uploadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.libraryTab.getToggleTabViewAction());
            this.toolbar.addAction(this.securityTab.getToggleTabViewAction());
            this.toolbar.addAction(this.statisticsTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchMonitorTab.getToggleTabViewAction());
            this.toolbar.addAction(this.resultMonitorTab.getToggleTabViewAction());
            this.toolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.getJMenuBar().putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.getContentPane().add("North", this.toolbar);
            this.getContentPane().validate();
        } else {
            this.getContentPane().remove(this.toolbar);
            this.getContentPane().validate();
            this.toolbar = null;
        }
    }

    public void setStatusbarVisible(boolean state) {
        if (state) {
            if (this.statusBar != null) {
                return;
            }
            this.statusBar = new MainStatusBar();
            this.getContentPane().add("South", this.statusBar);
            this.getContentPane().validate();
        } else {
            this.getContentPane().remove(this.statusBar);
            this.getContentPane().validate();
            this.statusBar = null;
        }
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, phex.event.ChangeEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.setTitle();
            }
        });
    }

    private class DesktopIndicatorHandler
    implements DesktopIndicatorListener {
        private DesktopIndicatorHandler() {
        }

        public void onDesktopIndicatorClicked(DesktopIndicator source) {
            MainFrame.this.setVisible(true);
            source.hideIndicator();
            if (MainFrame.this.getState() != 0) {
                MainFrame.this.setState(0);
            }
            MainFrame.this.requestFocus();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            ExitPhexAction.performCloseGUIAction();
        }

        public void windowOpened(WindowEvent e) {
            JDialog dialog;
            if (GUIRegistry.getInstance().isRespectCopyrightNoticeShown()) {
                dialog = new RespectCopyrightDialog();
                dialog.setVisible(true);
            }
            if (UpdatePrefs.ShowConfigWizard.get().booleanValue()) {
                dialog = new ConfigurationWizardDialog();
                dialog.setVisible(true);
            }
        }
    }
}

