/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.chat.ChatEngine;
import phex.common.log.NLogger;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.utils.Localizer;

public class ChatFrame
extends JFrame {
    private static final int MAX_CHAT_LENGTH = 51200;
    private ChatEngine chatEngine;
    private JTextArea chatTextArea;
    private JTextField sendTextField;

    public ChatFrame(ChatEngine aChatEngine) {
        this.chatEngine = aChatEngine;
        Object[] args = new Object[]{this.chatEngine.getHostAddress().getFullHostName()};
        this.setTitle(Localizer.getFormatedString("ChattingWith", args));
        this.setSize(400, 200);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChatFrame.this.chatEngine.stopChat();
                ChatFrame.this.closeChatFrame();
            }
        });
        Icon frameIcon = GUIRegistry.getInstance().getSystemIconPack().getIcon("Frame.IconImage");
        if (frameIcon != null) {
            this.setIconImage(((ImageIcon)frameIcon).getImage());
        }
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        GUIUtils.setWindowLocationRelativeTo(this, mainFrame);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.chatTextArea = new JTextArea(10, 40);
        this.chatTextArea.setEditable(false);
        this.chatTextArea.setLineWrap(true);
        this.chatTextArea.setWrapStyleWord(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 2, 3, 2);
        mainPanel.add((Component)new JScrollPane(this.chatTextArea), constraints);
        this.sendTextField = new JTextField(40);
        this.sendTextField.registerKeyboardAction(new SendTextActionHandler(), KeyStroke.getKeyStroke(10, 0), 0);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 6, 3, 6);
        mainPanel.add((Component)this.sendTextField, constraints);
        this.getContentPane().add("Center", mainPanel);
    }

    public void addChatMessage(String message) {
        message = '<' + this.chatEngine.getChatNick() + "> " + message + '\n';
        try {
            Document doc = this.chatTextArea.getDocument();
            doc.insertString(doc.getLength(), message, null);
            if (doc.getLength() > 51200) {
                doc.remove(0, doc.getLength() - 51200);
            }
            this.chatTextArea.scrollRectToVisible(this.chatTextArea.modelToView(doc.getLength()));
        }
        catch (BadLocationException exp) {
            NLogger.warn(ChatFrame.class, (Object)exp, (Throwable)exp);
        }
    }

    public void addInfoMessage(String message) {
        try {
            Document doc = this.chatTextArea.getDocument();
            doc.insertString(doc.getLength(), message, null);
            if (doc.getLength() > 51200) {
                doc.remove(0, doc.getLength() - 51200);
            }
            this.chatTextArea.scrollRectToVisible(this.chatTextArea.modelToView(doc.getLength()));
        }
        catch (BadLocationException exp) {
            NLogger.warn(ChatFrame.class, (Object)exp, (Throwable)exp);
        }
    }

    private void closeChatFrame() {
        this.setVisible(false);
        this.dispose();
    }

    private class SendTextActionHandler
    implements ActionListener {
        private SendTextActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String text = ChatFrame.this.sendTextField.getText();
            if (text.length() == 0) {
                return;
            }
            if (!ChatFrame.this.chatEngine.isConnected()) {
                ChatFrame.this.addInfoMessage(Localizer.getString("NotConnected"));
                return;
            }
            Document doc = ChatFrame.this.sendTextField.getDocument();
            try {
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException exp) {
                NLogger.warn(ChatFrame.class, (Object)exp, (Throwable)exp);
            }
            String message = '<' + Localizer.getString("You") + "> " + text + '\n';
            try {
                doc = ChatFrame.this.chatTextArea.getDocument();
                doc.insertString(doc.getLength(), message, null);
                ChatFrame.this.chatTextArea.scrollRectToVisible(ChatFrame.this.chatTextArea.modelToView(doc.getLength()));
            }
            catch (BadLocationException exp) {
                NLogger.warn(ChatFrame.class, (Object)exp, (Throwable)exp);
            }
            ChatFrame.this.chatEngine.sendChatMessage(text);
        }
    }
}

