/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.host.FavoritesContainer;
import phex.host.HostManager;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.rules.SearchFilterRules;
import phex.share.FileRescanRunner;

public class GUIActionPerformer {
    public static void browseHost(DestAddress hostAddress) {
        QueryManager queryService = GUIRegistry.getInstance().getServent().getQueryService();
        SearchContainer searchContainer = queryService.getSearchContainer();
        SearchFilterRules filterRules = queryService.getSearchFilterRules();
        BrowseHostResults result = searchContainer.createBrowseHostSearch(hostAddress, null);
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(result, filterRules);
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
        mainFrame.setSelectedTab(1101);
        searchTab.setDisplayedSearch(searchResultsDataModel);
    }

    public static void chatToHost(DestAddress hostAddress) {
    }

    public static void addHostsToFavorites(DestAddress[] addresses) {
        HostManager mgr = GUIRegistry.getInstance().getServent().getHostService();
        FavoritesContainer container = mgr.getFavoritesContainer();
        container.addFavorites(addresses);
    }

    public static void rescanSharedFiles() {
        Runnable runnable = new Runnable(){

            public void run() {
                FileRescanRunner.rescan(GUIRegistry.getInstance().getServent().getSharedFilesService(), true, true);
            }
        };
        Environment.getInstance().executeOnThreadPool(runnable, "SharedFilesRescanExecute");
    }
}

