/*
 * Decompiled with CFR 0.152.
 */
package phex.download.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.ChunkedInputStream;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.download.DataDownloadScope;
import phex.download.DownloadEngine;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.MemoryFile;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.ThexVerificationData;
import phex.download.WrongHTTPHeaderException;
import phex.download.handler.AbstractHttpDownload;
import phex.download.handler.DownloadHandlerException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.host.UnusableHostException;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.HTTPRetryAfter;
import phex.http.XQueueParameters;
import phex.io.buffer.ByteBuffer;
import phex.net.connection.Connection;
import phex.prefs.core.DownloadPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.prefs.core.UploadPrefs;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.IOUtil;
import phex.utils.LengthLimitedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFileDownload
extends AbstractHttpDownload {
    private static final int BUFFER_LENGTH = 16384;
    private InputStream inStream;
    private ContentRange replyContentRange;
    private long replyContentLength;
    private boolean isDownloadSuccessful;

    public HttpFileDownload(DownloadEngine engine) {
        super(engine);
    }

    @Override
    public void preProcess() throws DownloadHandlerException {
        SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
        SWDownloadSegment segment = downloadSet.allocateSegment();
        if (segment == null) {
            NLogger.debug(SWDownloadWorker.class, (Object)"No segment to allocate found.");
            downloadSet.getCandidate().addToCandidateLog("No segment to allocate found.");
            downloadSet.getCandidate().setStatus(SWDownloadCandidate.CandidateStatus.WAITING);
            throw new DownloadHandlerException("No segment found to allocate.");
        }
    }

    @Override
    public void processHandshake() throws IOException, UnusableHostException, HTTPMessageException {
        HTTPHeader header;
        this.isDownloadSuccessful = false;
        Connection connection = this.downloadEngine.getConnection();
        SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
        Servent servent = downloadSet.getServent();
        PhexSecurityManager securityService = servent.getSecurityService();
        SWDownloadCandidate candidate = downloadSet.getCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadSegment segment = downloadSet.getDownloadSegment();
        long downloadOffset = segment.getTransferStartPosition();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        this.inStream = connection.getInputStream();
        String requestUrl = candidate.getDownloadRequestUrl();
        HTTPRequest request = new HTTPRequest("GET", requestUrl, true);
        request.addHeader(new HTTPHeader("Host", candidate.getHostAddress().getFullHostName()));
        long segmentEndOffset = segment.getEnd();
        if (segmentEndOffset == -1L) {
            request.addHeader(new HTTPHeader("Range", "bytes=" + downloadOffset + "-"));
        } else {
            request.addHeader(new HTTPHeader("Range", "bytes=" + downloadOffset + "-" + segmentEndOffset));
        }
        request.addHeader(new HTTPHeader("X-Queue", "0.1"));
        request.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        if (candidate.isG2FeatureAdded()) {
            request.addHeader(new HTTPHeader("X-Features", "g2/1.0"));
        }
        HttpFileDownload.buildAltLocRequestHeader(downloadFile, candidate, request, servent.getLocalAddress(), servent.isFirewalled());
        DestAddress localAdress = servent.getLocalAddress();
        if (!servent.isFirewalled()) {
            request.addHeader(new HTTPHeader("X-Node", localAdress.getFullHostName()));
            if (NetworkPrefs.AllowChatConnection.get().booleanValue()) {
                request.addHeader(new HTTPHeader("Chat", localAdress.getFullHostName()));
            }
        }
        String httpRequestStr = request.buildHTTPRequestString();
        NLogger.debug(DownloadEngine.class, (Object)("HTTP Request to: " + candidate.getHostAddress() + "\n" + httpRequestStr));
        candidate.addToCandidateLog("HTTP Request:\n" + httpRequestStr);
        writer.write(httpRequestStr);
        writer.flush();
        HTTPResponse response = HTTPProcessor.parseHTTPResponse(connection);
        if (NLogger.isDebugEnabled(DownloadEngine.class)) {
            NLogger.debug(DownloadEngine.class, (Object)("HTTP Response from: " + candidate.getHostAddress() + "\n" + response.buildHTTPResponseString()));
        }
        if (DownloadPrefs.CandidateLogBufferSize.get() > 0) {
            candidate.addToCandidateLog("HTTP Response:\n" + response.buildHTTPResponseString());
        }
        if ((header = response.getHeader("Server")) != null) {
            candidate.setVendor(header.getValue());
        }
        if ((header = response.getHeader("Transfer-Encoding")) != null && header.getValue().equals("chunked")) {
            this.inStream = new ChunkedInputStream((InputStream)connection.getInputStream());
        }
        this.replyContentRange = null;
        header = response.getHeader("Content-Range");
        if (header != null) {
            this.replyContentRange = this.parseContentRange(header.getValue());
            if (this.replyContentRange.startPos != -1L && this.replyContentRange.startPos != downloadOffset) {
                throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
            }
        }
        this.replyContentLength = -1L;
        header = response.getHeader("Content-Length");
        if (header != null) {
            try {
                this.replyContentLength = header.longValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        header = response.getHeader("X-Thex-URI");
        HttpFileDownload.handleThexUriHeader(downloadFile, candidate, header);
        ArrayList<HTTPHeader> contentURNHeaders = new ArrayList<HTTPHeader>();
        header = response.getHeader("X-Gnutella-Content-URN");
        if (header != null) {
            contentURNHeaders.add(header);
        }
        Object[] headers = response.getHeaders("X-Content-URN");
        CollectionUtils.addAll(contentURNHeaders, (Object[])headers);
        HttpFileDownload.handleContentUrnHeaders(downloadFile, contentURNHeaders);
        header = response.getHeader("Chat");
        if (header != null) {
            candidate.setChatSupported(true);
        }
        int httpCode = response.getStatusCode();
        header = response.getHeader("X-Available-Ranges");
        if (header != null) {
            HTTPRangeSet availableRanges = HTTPRangeSet.parseHTTPRangeSet(header.getValue(), false);
            if (availableRanges == null) {
                NLogger.error(DownloadEngine.class, (Object)("Failed to parse X-Available-Ranges in " + candidate.getVendor() + " request: " + response.buildHTTPResponseString()));
            }
            candidate.setAvailableRangeSet(availableRanges);
        } else if (httpCode >= 200 && httpCode < 300 && downloadFile.getTotalDataSize() != -1L) {
            candidate.setAvailableRangeSet(new HTTPRangeSet(0L, downloadFile.getTotalDataSize() - 1L));
        }
        URN downloadFileURN = downloadFile.getFileURN();
        ArrayList<AlternateLocation> altLocList = new ArrayList<AlternateLocation>();
        headers = response.getHeaders("Alt-Location");
        List<AlternateLocation> altLocTmpList = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])headers, securityService);
        altLocList.addAll(altLocTmpList);
        headers = response.getHeaders("X-Gnutella-Alternate-Location");
        altLocTmpList = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])headers, securityService);
        altLocList.addAll(altLocTmpList);
        headers = response.getHeaders("X-Alt");
        altLocTmpList = AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])headers, downloadFileURN, securityService);
        altLocList.addAll(altLocTmpList);
        Iterator iterator = altLocList.iterator();
        while (iterator.hasNext()) {
            downloadFile.addDownloadCandidate((AlternateLocation)iterator.next());
        }
        headers = response.getHeaders("X-Pushproxies");
        HttpFileDownload.handlePushProxyHeaders(candidate, (HTTPHeader[])headers, securityService);
        headers = response.getHeaders("X-Push-Proxies");
        HttpFileDownload.handlePushProxyHeaders(candidate, (HTTPHeader[])headers, securityService);
        headers = response.getHeaders("X-Push-Proxy");
        HttpFileDownload.handlePushProxyHeaders(candidate, (HTTPHeader[])headers, securityService);
        this.updateKeepAliveSupport(response);
        if (httpCode >= 200 && httpCode < 300) {
            if (contentURNHeaders.size() == 0 && requestUrl.startsWith("/uri-res/N2R?")) {
                throw new IOException("Response to uri-res request without valid Content-URN header.");
            }
            if (downloadFile.getTotalDataSize() == -1L) {
                assert (segment.getTotalDataSize() == -1L);
                if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                    downloadFile.setFileSize(this.replyContentRange.totalLength);
                    this.stopDownload();
                    throw new ReconnectException();
                }
            }
            NLogger.debug(DownloadEngine.class, (Object)"HTTP Handshake successfull.");
            return;
        }
        if (httpCode == 503) {
            int delta;
            header = response.getHeader("X-Queue");
            XQueueParameters xQueueParameters = null;
            if (header != null) {
                xQueueParameters = XQueueParameters.parseXQueueParameters(header.getValue());
            }
            if (xQueueParameters != null && this.isKeepAliveSupported) {
                throw new RemotelyQueuedException(xQueueParameters);
            }
            header = response.getHeader("Retry-After");
            if (header != null && (delta = HTTPRetryAfter.parseDeltaInSeconds(header)) > 0) {
                throw new HostBusyException(delta);
            }
            throw new HostBusyException();
        }
        if (httpCode == 401 || httpCode == 403) {
            if ("Network Disabled".equals(response.getStatusReason())) {
                if (candidate.isG2FeatureAdded()) {
                    throw new UnusableHostException("Request Forbidden");
                }
                candidate.setG2FeatureAdded(true);
                throw new HostBusyException(300);
            }
            throw new UnusableHostException("Request Forbidden");
        }
        if (httpCode == 408) {
            throw new HostBusyException();
        }
        if (httpCode == 404 || httpCode == 410) {
            throw new FileNotAvailableException();
        }
        if (httpCode == 416) {
            int delta;
            header = response.getHeader("Retry-After");
            if (header != null && (delta = HTTPRetryAfter.parseDeltaInSeconds(header)) > 0) {
                throw new RangeUnavailableException(delta);
            }
            throw new RangeUnavailableException();
        }
        if (httpCode == 500) {
            throw new UnusableHostException("Internal Server Error");
        }
        throw new IOException("Unknown HTTP code: " + httpCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDownload() throws IOException {
        SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
        SWDownloadCandidate candidate = downloadSet.getCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadSegment segment = downloadSet.getDownloadSegment();
        NLogger.debug(DownloadEngine.class, (Object)"Download Engine starts download.");
        LengthLimitedInputStream downloadStream = null;
        try {
            int len;
            long segmentDataSizeLeft;
            segment.downloadStartNotify();
            String snapshotOfSegment = segment.toString();
            long downloadLengthLeft = Long.MAX_VALUE;
            if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                downloadLengthLeft = this.replyContentRange.totalLength;
            }
            if (this.replyContentLength != -1L) {
                downloadLengthLeft = Math.min(this.replyContentLength, downloadLengthLeft);
            }
            if ((segmentDataSizeLeft = segment.getTransferDataSizeLeft()) != -1L) {
                downloadLengthLeft = Math.min(segmentDataSizeLeft, downloadLengthLeft);
            }
            downloadStream = new LengthLimitedInputStream(this.inStream, downloadLengthLeft);
            MemoryFile memoryFile = downloadFile.getMemoryFile();
            long fileOffset = segment.getStart() + segment.getTransferredDataSize();
            long lengthDownloaded = segment.getTransferredDataSize();
            byte[] buffer = new byte[16384];
            while ((len = downloadStream.read(buffer, 0, 16384)) > 0) {
                if (NLogger.isDebugEnabled(DownloadEngine.class)) {
                    NLogger.debug(DownloadEngine.class, (Object)("Reading in " + len + "bytes."));
                    candidate.addToCandidateLog("Reading in " + len + "bytes.");
                }
                SWDownloadSegment sWDownloadSegment = segment;
                synchronized (sWDownloadSegment) {
                    long tmpCheckLength = lengthDownloaded + (long)len;
                    if (tmpCheckLength < segment.getTransferredDataSize()) {
                        NLogger.error(DownloadEngine.class, (Object)("TransferredDataSize would be going down!  ll " + downloadLengthLeft + " l " + len + " ld " + lengthDownloaded + " gtds " + segment.getTransferredDataSize() + " seg: " + segment + " originally: " + snapshotOfSegment));
                        throw new IOException("TransferredDataSize would be going down!");
                    }
                    if (segment.getTransferDataSize() > -1L && tmpCheckLength > segment.getTransferDataSize()) {
                        NLogger.error(DownloadEngine.class, (Object)("TransferredDataSize would be larger then segment!  ll " + downloadLengthLeft + " l " + len + " ld " + lengthDownloaded + " gtds " + segment.getTransferredDataSize() + " seg: " + segment + " originally: " + snapshotOfSegment));
                        throw new IOException("TransferredDataSize would be larger then segment!");
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(len);
                    byteBuffer.put(buffer, 0, len);
                    byteBuffer.flip();
                    DataDownloadScope dataScope = new DataDownloadScope(fileOffset, fileOffset + (long)len - 1L, byteBuffer);
                    if (NLogger.isDebugEnabled(DownloadEngine.class)) {
                        NLogger.debug(DownloadEngine.class, (Object)("Buffering " + len + "bytes."));
                        candidate.addToCandidateLog("Buffering in " + len + "bytes.");
                    }
                    memoryFile.bufferDataScope(dataScope);
                    if (NLogger.isDebugEnabled(DownloadEngine.class)) {
                        NLogger.debug(DownloadEngine.class, (Object)("Buffered " + len + "bytes."));
                        candidate.addToCandidateLog("Buffered " + len + "bytes.");
                    }
                    fileOffset += (long)len;
                    segment.setTransferredDataSize(lengthDownloaded += (long)len);
                    candidate.incTotalDownloadSize(len);
                    segmentDataSizeLeft = segment.getTransferDataSizeLeft();
                    if (segmentDataSizeLeft != -1L) {
                        downloadLengthLeft = Math.min(segmentDataSizeLeft, downloadLengthLeft);
                        downloadStream.setLengthLimit(downloadLengthLeft);
                    }
                }
            }
            this.isDownloadSuccessful = true;
            if (downloadFile.getTotalDataSize() == -1L) {
                assert (segment.getTotalDataSize() == -1L);
                downloadFile.setFileSize(segment.getTransferredDataSize());
            }
        }
        finally {
            segment.downloadStopNotify();
            boolean isAcceptingNextSegment = this.isAcceptingNextRequest();
            candidate.addToCandidateLog("Is accepting next segment: " + isAcceptingNextSegment);
            if (isAcceptingNextSegment && downloadStream != null) {
                downloadStream.close();
            } else {
                this.stopDownload();
            }
        }
    }

    @Override
    public void postProcess() {
        SWDownloadSet downloadSet = this.downloadEngine.getDownloadSet();
        SWDownloadSegment downloadSegment = downloadSet.getDownloadSegment();
        SWDownloadCandidate candidate = downloadSet.getCandidate();
        if (downloadSegment == null) {
            candidate.addToCandidateLog("No download segment available.");
            NLogger.debug(HttpFileDownload.class, (Object)"No download segment available.");
        } else {
            candidate.addToCandidateLog("Completed a segment which started at " + downloadSegment.getStart() + " and was downloaded at a rate of " + downloadSegment.getLongTermTransferRate());
            NLogger.debug(HttpFileDownload.class, (Object)("Completed a segment which started at " + downloadSegment.getStart() + " and was downloaded at a rate of " + downloadSegment.getLongTermTransferRate()));
        }
        NLogger.debug(HttpFileDownload.class, (Object)("Releasing DownloadSegment: " + downloadSet.toString() + " - " + this));
        downloadSet.releaseDownloadSegment();
    }

    @Override
    public void stopDownload() {
        IOUtil.closeQuietly(this.inStream);
        SWDownloadSegment segment = this.downloadEngine.getDownloadSet().getDownloadSegment();
        if (segment != null) {
            segment.downloadStopNotify();
        }
    }

    @Override
    public boolean isAcceptingNextRequest() {
        return this.isDownloadSuccessful && this.isKeepAliveSupported && this.replyContentLength != -1L;
    }

    private static void handleContentUrnHeaders(SWDownloadFile downloadFile, List<HTTPHeader> headerList) throws IOException {
        URN downloadFileURN = downloadFile.getFileURN();
        if (downloadFileURN != null) {
            for (HTTPHeader urnHeader : headerList) {
                ThexVerificationData thexVerificationData;
                String expectedRootHash;
                String contentURNStr = urnHeader.getValue();
                if (!URN.isValidURN(contentURNStr)) continue;
                URN contentURN = new URN(contentURNStr);
                if (contentURN.isBitprintNid() && (expectedRootHash = (thexVerificationData = downloadFile.getThexVerificationData()).getRootHash()) != null && !expectedRootHash.equals(contentURN.getTigerTreeRootNss())) {
                    throw new IOException("Required TTR and content URN TTR do not match:" + expectedRootHash + " " + contentURN.getTigerTreeRootNss());
                }
                if (downloadFileURN.equals(contentURN)) continue;
                throw new IOException("Required URN and content URN do not match.");
            }
        }
    }

    private static void handleThexUriHeader(SWDownloadFile downloadFile, SWDownloadCandidate candidate, HTTPHeader header) {
        if (header == null) {
            return;
        }
        String value = header.getValue();
        int idx = value.indexOf(";");
        if (idx < 0) {
            return;
        }
        String thexUri = value.substring(0, idx);
        String root = value.substring(idx + 1);
        ThexVerificationData thexVerificationData = downloadFile.getThexVerificationData();
        String expectedRootHash = thexVerificationData.getRootHash();
        if (expectedRootHash == null) {
            thexVerificationData.setRootHash(root);
        }
        candidate.setThexUriRoot(thexUri, root);
    }

    private static void buildAltLocRequestHeader(SWDownloadFile downloadFile, SWDownloadCandidate candidate, HTTPRequest request, DestAddress serventAddress, boolean isFirewalled) {
        HTTPHeader header;
        URN downloadFileURN = downloadFile.getFileURN();
        if (downloadFileURN == null) {
            return;
        }
        AltLocContainer altLocContainer = new AltLocContainer(downloadFileURN);
        altLocContainer.addContainer(downloadFile.getGoodAltLocContainer());
        if (!isFirewalled && UploadPrefs.SharePartialFiles.get().booleanValue() && !serventAddress.isSiteLocalAddress()) {
            AlternateLocation newAltLoc = new AlternateLocation(serventAddress, downloadFileURN);
            altLocContainer.addAlternateLocation(newAltLoc);
        }
        if ((header = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", candidate.getHostAddress(), candidate.getSendAltLocsSet())) != null) {
            request.addHeader(header);
        }
        if ((header = (altLocContainer = downloadFile.getBadAltLocContainer()).getAltLocHTTPHeaderForAddress("X-NAlt", candidate.getHostAddress(), candidate.getSendAltLocsSet())) != null) {
            request.addHeader(header);
        }
    }

    private static void handlePushProxyHeaders(SWDownloadCandidate candidate, HTTPHeader[] headers, PhexSecurityManager securityService) {
        if (headers == null || headers.length == 0) {
            return;
        }
        ArrayList<DestAddress> proxyList = new ArrayList<DestAddress>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                String addressStr = tokenizer.nextToken().trim();
                try {
                    DestAddress address = AddressUtils.parseAndValidateAddress(addressStr, false, securityService);
                    proxyList.add(address);
                }
                catch (MalformedDestAddressException exp) {
                    NLogger.debug(DownloadEngine.class, (Object)("Malformed alt-location URL: " + exp.getMessage()));
                }
            }
        }
        if (proxyList.size() == 0) {
            return;
        }
        DestAddress[] pushProxyAddresses = new DestAddress[proxyList.size()];
        proxyList.toArray(pushProxyAddresses);
        candidate.setPushProxyAddresses(pushProxyAddresses);
    }

    private ContentRange parseContentRange(String contentRangeLine) throws WrongHTTPHeaderException {
        try {
            long fileLength;
            ContentRange range = new ContentRange();
            String line = contentRangeLine.toLowerCase();
            int idx = line.indexOf("bytes") + 6;
            String rangeStr = line.substring(idx).trim();
            int slashIdx = rangeStr.indexOf(47);
            String leadingPart = rangeStr.substring(0, slashIdx);
            String trailingPart = rangeStr.substring(slashIdx + 1);
            range.totalLength = trailingPart.charAt(0) == '*' ? -1L : (fileLength = Long.parseLong(trailingPart));
            if (leadingPart.charAt(0) == '*') {
                range.startPos = -1L;
                range.endPos = range.totalLength;
            } else {
                int dashIdx = rangeStr.indexOf(45);
                String startOffsetStr = leadingPart.substring(0, dashIdx);
                long startOffset = Long.parseLong(startOffsetStr);
                String endOffsetStr = leadingPart.substring(dashIdx + 1);
                long endOffset = Long.parseLong(endOffsetStr);
                range.startPos = startOffset;
                range.endPos = endOffset;
            }
            return range;
        }
        catch (NumberFormatException exp) {
            NLogger.warn(DownloadEngine.class, (Object)exp, (Throwable)exp);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + contentRangeLine);
        }
        catch (IndexOutOfBoundsException exp) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + contentRangeLine);
        }
    }

    private class ContentRange {
        long startPos;
        long endPos;
        long totalLength;

        private ContentRange() {
        }
    }
}

