/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import phex.common.FileHandlingException;
import phex.common.RunnerQueueWorker;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.download.BufferVolumeTracker;
import phex.download.DataDownloadScope;
import phex.download.DownloadDataWriter;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RatedDownloadScopeList;
import phex.download.ThexVerificationData;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.prefs.core.DownloadPrefs;
import phex.thex.TTHashCalcUtils;
import phex.xml.sax.downloads.DDownloadFile;
import phex.xml.sax.downloads.DDownloadScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryFile {
    private ScopeSelectionStrategy scopeSelectionStrategy;
    private DownloadScopeList missingScopeList;
    private DownloadScopeList blockedScopeList;
    private List<DataDownloadScope> bufferedDataScopeList;
    private BufferVolumeTracker bufferedVolume;
    private DownloadScopeList unverifiedScopeList;
    private DownloadScopeList toBeVerifiedScopeList;
    private DownloadScopeList finishedScopeList;
    private DownloadScopeList finalizationPhaseScopeList;
    private final ReentrantLock allocationLock;
    private final ReentrantLock finalizationLock;
    private RatedDownloadScopeList ratedScopeList;
    private long ratedScopeListBuildTime;
    private boolean isBufferWritingRequested;
    private boolean isBlockedScopeAllocated;
    private final SWDownloadFile downloadFile;
    private final RunnerQueueWorker downloadVerifyRunner;

    public MemoryFile(SWDownloadFile downloadFile, BufferVolumeTracker globalBufferVolumeTracker, DownloadDataWriter downloadDataWriter, RunnerQueueWorker downloadVerifyRunner) {
        this.downloadFile = downloadFile;
        this.downloadVerifyRunner = downloadVerifyRunner;
        this.isBufferWritingRequested = false;
        this.isBlockedScopeAllocated = false;
        this.missingScopeList = new DownloadScopeList();
        this.blockedScopeList = new DownloadScopeList();
        this.bufferedDataScopeList = new ArrayList<DataDownloadScope>();
        this.unverifiedScopeList = new DownloadScopeList();
        this.toBeVerifiedScopeList = new DownloadScopeList();
        this.finishedScopeList = new DownloadScopeList();
        this.finalizationPhaseScopeList = new DownloadScopeList();
        this.allocationLock = new ReentrantLock();
        this.finalizationLock = new ReentrantLock();
        this.bufferedVolume = new BufferVolumeTracker(globalBufferVolumeTracker, DownloadPrefs.MaxWriteBufferPerDownload.get(), downloadDataWriter);
        long fileSize = downloadFile.getTotalDataSize();
        if (fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, fileSize - 1L));
        }
        this.scopeSelectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
    }

    public void setScopeSelectionStrategy(ScopeSelectionStrategy strategy) {
        this.scopeSelectionStrategy = strategy;
    }

    public ScopeSelectionStrategy getScopeSelectionStrategy() {
        return this.scopeSelectionStrategy;
    }

    public void updateFileSize() {
        long fileSize = this.downloadFile.getTotalDataSize();
        this.allocationLock.lock();
        try {
            this.missingScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
            this.blockedScopeList.remove(new DownloadScope(fileSize, Long.MAX_VALUE));
        }
        finally {
            this.allocationLock.unlock();
        }
        this.scopeConsistencyCheck();
    }

    public DownloadScopeList getBlockedScopeList() {
        return this.blockedScopeList;
    }

    public DownloadScopeList getUnverifiedScopeList() {
        return this.unverifiedScopeList;
    }

    public DownloadScopeList getToBeVerifiedScopeList() {
        return this.toBeVerifiedScopeList;
    }

    public DownloadScopeList getFinishedScopeList() {
        return this.finishedScopeList;
    }

    public List<DownloadScope> getFinishedScopeListCopy() {
        this.finalizationLock.lock();
        try {
            List<DownloadScope> list = this.finishedScopeList.getScopeListCopy();
            return list;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public List<DownloadScope> getUnverifiedScopeListCopy() {
        this.finalizationLock.lock();
        try {
            List<DownloadScope> list = this.unverifiedScopeList.getScopeListCopy();
            return list;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public int getDownloadedFragmentCount() {
        this.finalizationLock.lock();
        try {
            int n = this.finishedScopeList.size() + this.unverifiedScopeList.size() + this.toBeVerifiedScopeList.size();
            return n;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public long getFinishedLength() {
        this.finalizationLock.lock();
        try {
            long l = this.finishedScopeList.getAggregatedLength();
            return l;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public long getMissingLength() {
        this.allocationLock.lock();
        try {
            long l = this.missingScopeList.getAggregatedLength();
            return l;
        }
        finally {
            this.allocationLock.unlock();
        }
    }

    private boolean isComplete() {
        this.finalizationLock.lock();
        try {
            boolean bl = this.finishedScopeList.getAggregatedLength() == this.downloadFile.getTotalDataSize();
            return bl;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public boolean isFileBeginningAvailable() {
        this.finalizationLock.lock();
        try {
            DownloadScope scope;
            if (this.unverifiedScopeList.size() > 0 && (scope = this.unverifiedScopeList.getScopeAt(0)).getStart() == 0L) {
                boolean bl = true;
                return bl;
            }
            if (this.finishedScopeList.size() > 0 && (scope = this.finishedScopeList.getScopeAt(0)).getStart() == 0L) {
                boolean bl = true;
                return bl;
            }
            if (this.toBeVerifiedScopeList.size() > 0 && (scope = this.toBeVerifiedScopeList.getScopeAt(0)).getStart() == 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileBeginningScopeLength() {
        this.finalizationLock.lock();
        try {
            DownloadScopeList scopeList = (DownloadScopeList)this.finishedScopeList.clone();
            scopeList.addAll(this.unverifiedScopeList);
            scopeList.addAll(this.toBeVerifiedScopeList);
            DownloadScope startScope = scopeList.getScopeAt(0);
            if (startScope == null || startScope.getStart() != 0L) {
                long l = 0L;
                return l;
            }
            long l = startScope.getLength();
            return l;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public RatedDownloadScopeList getRatedScopeList() {
        long now = System.currentTimeMillis();
        if (this.ratedScopeListBuildTime + 120000L > now) {
            return this.ratedScopeList;
        }
        if (this.ratedScopeList == null) {
            this.ratedScopeList = new RatedDownloadScopeList();
        } else {
            this.ratedScopeList.clear();
        }
        this.ratedScopeList.addAll(this.missingScopeList);
        this.downloadFile.rateDownloadScopeList(this.ratedScopeList);
        this.ratedScopeListBuildTime = System.currentTimeMillis();
        return this.ratedScopeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMissingScopeAllocateable(DownloadScopeList candidateScopeList) {
        this.allocationLock.lock();
        try {
            if (this.missingScopeList.isEmpty() && this.blockedScopeList.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (this.missingScopeList.isEmpty() && this.downloadFile.getTotalDataSize() == -1L) {
                boolean bl = false;
                return bl;
            }
            if (this.downloadFile.getTotalDataSize() != -1L && candidateScopeList != null) {
                DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
                wantedScopeList.addAll(this.blockedScopeList);
                wantedScopeList.retainAll(candidateScopeList);
                boolean bl = wantedScopeList.size() > 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.allocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScope allocateMissingScope(long preferredSize) {
        this.allocationLock.lock();
        try {
            if (this.missingScopeList.isEmpty()) {
                DownloadScope downloadScope = null;
                return downloadScope;
            }
            DownloadScope scope = this.missingScopeList.getScopeAt(0);
            this.missingScopeList.remove(scope);
            DownloadScope downloadScope = scope;
            synchronized (downloadScope) {
                if (this.downloadFile.getTotalDataSize() != -1L && scope.getLength() > preferredSize) {
                    DownloadScope beforeScope = new DownloadScope(scope.getStart(), scope.getStart() + preferredSize - 1L);
                    DownloadScope afterScope = new DownloadScope(scope.getStart() + preferredSize, scope.getEnd());
                    this.missingScopeList.add(afterScope);
                    scope = beforeScope;
                }
            }
            this.blockedScopeList.add(scope);
            downloadScope = scope;
            return downloadScope;
        }
        finally {
            this.allocationLock.unlock();
            this.scopeConsistencyCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScope allocateMissingScopeForCandidate(DownloadScopeList candidateScopeList, long preferredSize) {
        this.allocationLock.lock();
        try {
            int segmentMultiple = DownloadPrefs.SegmentMultiple.get();
            long missingLength = this.missingScopeList.getAggregatedLength();
            if (missingLength < preferredSize * 2L) {
                preferredSize = Math.max(missingLength / 2L, (long)segmentMultiple);
            }
            DownloadScopeList wantedScopeList = (DownloadScopeList)this.missingScopeList.clone();
            wantedScopeList.addAll(this.missingScopeList);
            wantedScopeList.retainAll(candidateScopeList);
            if (wantedScopeList.size() > 0) {
                DownloadScope scope = this.scopeSelectionStrategy.selectDownloadScope(this.downloadFile, wantedScopeList, preferredSize);
                if (scope == null) {
                    DownloadScope downloadScope = null;
                    return downloadScope;
                }
                this.missingScopeList.remove(scope);
                this.blockedScopeList.add(scope);
                DownloadScope downloadScope = scope;
                return downloadScope;
            }
            if (missingLength > 0L) {
                DownloadScope downloadScope = null;
                return downloadScope;
            }
            DownloadScope downloadScope = null;
            return downloadScope;
        }
        finally {
            this.allocationLock.unlock();
            this.scopeConsistencyCheck();
        }
    }

    public void releaseAllocatedScope(DownloadScope downloadScope, long transferredSize, SWDownloadCandidate downloadCandidate) {
        DownloadScope unblockScope;
        if (downloadScope.getEnd() == Long.MAX_VALUE && this.downloadFile.getTotalDataSize() != -1L) {
            downloadScope = new DownloadScope(downloadScope.getStart(), this.downloadFile.getTotalDataSize() - 1L);
        }
        if (transferredSize == 0L) {
            unblockScope = downloadScope;
        } else if (transferredSize < downloadScope.getLength()) {
            unblockScope = new DownloadScope(downloadScope.getStart() + transferredSize, downloadScope.getEnd());
        } else {
            return;
        }
        if (this.isBlockedScopeAllocated) {
            this.releaseMultiBlockedAllocScope(unblockScope, downloadCandidate);
            this.releaseMultiBlockedAllocScope(unblockScope, downloadCandidate);
        } else {
            this.releaseSingleAllocScope(unblockScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMultiBlockedAllocScope(@NonNull DownloadScope unblockScope, @NonNull SWDownloadCandidate downloadCandidate) {
        this.allocationLock.lock();
        try {
            this.finalizationLock.lock();
            try {
                DownloadScopeList unblockScopeList = new DownloadScopeList();
                unblockScopeList.add(unblockScope);
                unblockScopeList.removeAll(this.finalizationPhaseScopeList);
                long scopeStart = unblockScope.getStart();
                long scopeEnd = unblockScope.getEnd();
                List<SWDownloadCandidate> allocCandidatesList = this.downloadFile.getAllocatedCandidates();
                for (SWDownloadCandidate allocCandidate : allocCandidatesList) {
                    SWDownloadSegment downloadSegment;
                    if (allocCandidate == downloadCandidate || (downloadSegment = allocCandidate.getDownloadSegment()) == null) continue;
                    long segStart = downloadSegment.getStart();
                    long segEnd = downloadSegment.getEnd();
                    if (segEnd == -1L) {
                        segEnd = Long.MAX_VALUE;
                    }
                    if (scopeEnd < segStart || scopeStart > segEnd) continue;
                    if (segStart <= scopeStart && segEnd >= scopeEnd) {
                        return;
                    }
                    unblockScopeList.remove(new DownloadScope(segStart, segEnd));
                }
                if (unblockScopeList.size() > 0) {
                    this.blockedScopeList.removeAll(unblockScopeList);
                    this.missingScopeList.addAll(unblockScopeList);
                }
                this.scopeConsistencyCheck();
            }
            finally {
                this.finalizationLock.unlock();
            }
        }
        finally {
            this.allocationLock.unlock();
            this.scopeConsistencyCheck();
        }
    }

    private void releaseSingleAllocScope(DownloadScope unblockScope) {
        this.allocationLock.lock();
        try {
            this.blockedScopeList.remove(unblockScope);
            this.missingScopeList.add(unblockScope);
        }
        finally {
            this.allocationLock.unlock();
            this.scopeConsistencyCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDownloadedLength() {
        this.finalizationLock.lock();
        try {
            long length = this.unverifiedScopeList.getAggregatedLength();
            length += this.toBeVerifiedScopeList.getAggregatedLength();
            length += this.finishedScopeList.getAggregatedLength();
            long l = length += (long)this.bufferedVolume.getUsedBufferSize();
            return l;
        }
        finally {
            this.finalizationLock.unlock();
        }
    }

    public int getBufferedDataLength() {
        return this.bufferedVolume.getUsedBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferDataScope(DataDownloadScope dataScope) throws IOException {
        this.allocationLock.lock();
        try {
            this.finalizationLock.lock();
            try {
                for (DownloadScope finScope : this.finalizationPhaseScopeList) {
                    if (dataScope.isOverlapping(finScope)) {
                        throw new IOException("Double download.");
                    }
                    if (finScope.getStart() <= dataScope.getEnd()) continue;
                    break;
                }
                this.finalizationPhaseScopeList.add(dataScope);
                this.missingScopeList.remove(dataScope);
                this.blockedScopeList.remove(dataScope);
                this.bufferedDataScopeList.add(dataScope);
            }
            finally {
                this.finalizationLock.unlock();
            }
        }
        finally {
            this.allocationLock.unlock();
            this.scopeConsistencyCheck();
        }
        assert (dataScope.getLength() < Integer.MAX_VALUE);
        this.bufferedVolume.addBufferedSize((int)dataScope.getLength());
    }

    public boolean isBufferWritingRequested() {
        return this.isBufferWritingRequested;
    }

    public void requestBufferWriting() {
        NLogger.debug(MemoryFile.class, (Object)"MemoryFile requesting buffer write.");
        this.isBufferWritingRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffersToDisk() {
        if (this.bufferedDataScopeList.isEmpty()) {
            return;
        }
        NLogger.debug(MemoryFile.class, (Object)"MemoryFile write buffers to disk.");
        this.isBufferWritingRequested = false;
        try {
            ArrayList<DataDownloadScope> list;
            ManagedFile destFile = this.downloadFile.getIncompleteDownloadFile();
            this.finalizationLock.lock();
            try {
                list = new ArrayList<DataDownloadScope>(this.bufferedDataScopeList);
            }
            finally {
                this.finalizationLock.unlock();
            }
            for (DataDownloadScope dataScope : list) {
                destFile.write(dataScope.getDataBuffer(), dataScope.getStart());
                this.finalizationLock.lock();
                try {
                    this.bufferedDataScopeList.remove(dataScope);
                    this.unverifiedScopeList.add(dataScope);
                }
                finally {
                    this.finalizationLock.unlock();
                }
                assert (dataScope.getLength() < Integer.MAX_VALUE);
                this.bufferedVolume.reduceBufferedSize((int)dataScope.getLength());
                dataScope.releaseDataBuffer();
            }
            this.findScopesToVerify();
            this.scopeConsistencyCheck();
            if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
                this.downloadFile.setStatus(3);
                this.downloadFile.moveToDestinationFile();
            }
        }
        catch (FileHandlingException exp) {
            NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
        }
        catch (ManagedFileException exp) {
            NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findScopesToVerify() {
        this.finalizationLock.lock();
        try {
            int nodeSize;
            ArrayList<DownloadScope> verifyableScopes = new ArrayList<DownloadScope>();
            ThexVerificationData.ThexData thexData = this.downloadFile.getThexVerificationData().getThexData();
            if (thexData == null) {
                if (this.unverifiedScopeList.getAggregatedLength() == this.downloadFile.getTotalDataSize()) {
                    List<DownloadScope> scopes = this.unverifiedScopeList.getScopeListCopy();
                    for (DownloadScope scope : scopes) {
                        this.unverifiedScopeList.remove(scope);
                        this.finishedScopeList.add(scope);
                    }
                    if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
                        this.downloadFile.setStatus(3);
                        this.downloadFile.moveToDestinationFile();
                    }
                }
                return;
            }
            long totalFileSize = this.downloadFile.getTotalDataSize();
            long lastNodeStart = totalFileSize - totalFileSize % (long)(nodeSize = thexData.getNodeSize());
            if (lastNodeStart == totalFileSize) {
                lastNodeStart -= (long)nodeSize;
            }
            for (DownloadScope scope : this.unverifiedScopeList) {
                long nodeStart;
                boolean isLastScope;
                boolean bl = isLastScope = scope.getEnd() + 1L == totalFileSize;
                if (!isLastScope && scope.getLength() < (long)nodeSize) continue;
                if (scope.getStart() % (long)nodeSize == 0L) {
                    nodeStart = scope.getStart();
                } else if (isLastScope) {
                    nodeStart = totalFileSize - totalFileSize % (long)nodeSize;
                    if (nodeStart == totalFileSize) {
                        nodeStart -= (long)nodeSize;
                    }
                } else {
                    nodeStart = scope.getStart() + (long)nodeSize - scope.getStart() % (long)nodeSize;
                }
                long nodeEnd = (scope.getEnd() + 1L) % (long)nodeSize == 0L || isLastScope ? scope.getEnd() : scope.getEnd() - 1L - scope.getEnd() % (long)nodeSize;
                if (nodeEnd - nodeStart + 1L >= (long)nodeSize && (nodeEnd - nodeStart + 1L) % (long)nodeSize == 0L) {
                    long rangeEnd;
                    long rangeStart = nodeStart;
                    do {
                        rangeEnd = rangeStart + (long)nodeSize - 1L;
                        verifyableScopes.add(new DownloadScope(rangeStart, rangeEnd));
                    } while ((rangeStart = rangeEnd + 1L) < nodeEnd);
                    continue;
                }
                if (!isLastScope || scope.getStart() > nodeStart) continue;
                verifyableScopes.add(new DownloadScope(nodeStart, nodeEnd));
            }
            if (verifyableScopes.size() > 0) {
                for (DownloadScope scope : verifyableScopes) {
                    this.unverifiedScopeList.remove(scope);
                    this.toBeVerifiedScopeList.add(scope);
                    this.downloadVerifyRunner.add(new DownloadVerificationWorker(scope));
                }
            }
        }
        finally {
            this.finalizationLock.unlock();
            this.scopeConsistencyCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyScope(DownloadScope scope) {
        block18: {
            try {
                ManagedFile destFile = this.downloadFile.getIncompleteDownloadFile();
                boolean succ = TTHashCalcUtils.verifyTigerTreeHash(this.downloadFile.getThexVerificationData().getThexData(), destFile, scope.getStart(), scope.getLength());
                if (succ) {
                    this.finalizationLock.lock();
                    try {
                        this.toBeVerifiedScopeList.remove(scope);
                        this.finishedScopeList.add(scope);
                        break block18;
                    }
                    finally {
                        this.finalizationLock.unlock();
                    }
                }
                this.allocationLock.lock();
                try {
                    this.finalizationLock.lock();
                    try {
                        this.toBeVerifiedScopeList.remove(scope);
                        this.missingScopeList.add(scope);
                        this.finalizationPhaseScopeList.remove(scope);
                    }
                    finally {
                        this.finalizationLock.unlock();
                    }
                }
                finally {
                    this.allocationLock.unlock();
                }
            }
            catch (FileHandlingException exp) {
                NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
            }
            catch (ManagedFileException exp) {
                NLogger.error(MemoryFile.class, (Object)exp, (Throwable)exp);
            }
            finally {
                this.scopeConsistencyCheck();
            }
        }
        if (!this.downloadFile.isFileCompletedOrMoved() && this.isComplete()) {
            this.downloadFile.setStatus(3);
            this.downloadFile.moveToDestinationFile();
        }
    }

    public void createDownloadScopes(DDownloadFile dFile) {
        DownloadScope downloadScope;
        this.missingScopeList.clear();
        this.blockedScopeList.clear();
        this.unverifiedScopeList.clear();
        this.toBeVerifiedScopeList.clear();
        this.finishedScopeList.clear();
        this.setScopeSelectionStrategy(ScopeSelectionStrategyProvider.getByClassName(dFile.getScopeSelectionStrategy()));
        for (DDownloadScope dScope : dFile.getUnverifiedScopesList().getSubElementList()) {
            downloadScope = new DownloadScope(dScope.getStart(), dScope.getEnd());
            this.unverifiedScopeList.add(downloadScope);
        }
        for (DDownloadScope dScope : dFile.getFinishedScopesList().getSubElementList()) {
            downloadScope = new DownloadScope(dScope.getStart(), dScope.getEnd());
            this.finishedScopeList.add(downloadScope);
        }
        long fileSize = this.downloadFile.getTotalDataSize();
        if (fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, fileSize - 1L));
        }
        this.missingScopeList.removeAll(this.unverifiedScopeList);
        this.missingScopeList.removeAll(this.finishedScopeList);
        this.finalizationPhaseScopeList.addAll(this.unverifiedScopeList);
        this.finalizationPhaseScopeList.addAll(this.finishedScopeList);
        this.scopeConsistencyCheck();
    }

    public void createXJBFinishedScopes(DDownloadFile dFile) {
        dFile.setScopeSelectionStrategy(this.scopeSelectionStrategy.getClass().getName());
        List<DDownloadScope> list = dFile.getUnverifiedScopesList().getSubElementList();
        List<DownloadScope> unvScopeListCopy = this.getUnverifiedScopeListCopy();
        for (DownloadScope scope : unvScopeListCopy) {
            DDownloadScope dScope = new DDownloadScope("unverified-scopes");
            dScope.setStart(scope.getStart());
            dScope.setEnd(scope.getEnd());
            list.add(dScope);
        }
        list = dFile.getFinishedScopesList().getSubElementList();
        List<DownloadScope> finScopeListCopy = this.getFinishedScopeListCopy();
        for (DownloadScope scope : finScopeListCopy) {
            DDownloadScope dScope = new DDownloadScope("finished-scopes");
            dScope.setStart(scope.getStart());
            dScope.setEnd(scope.getEnd());
            list.add(dScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scopeConsistencyCheck() {
        this.allocationLock.lock();
        try {
            this.finalizationLock.lock();
            try {
                DownloadScopeList fullFile = new DownloadScopeList();
                fullFile.addAll(this.missingScopeList);
                fullFile.addAll(this.blockedScopeList);
                for (DownloadScope downloadScope : this.bufferedDataScopeList) {
                    fullFile.add(downloadScope);
                }
                fullFile.addAll(this.unverifiedScopeList);
                fullFile.addAll(this.toBeVerifiedScopeList);
                fullFile.addAll(this.finishedScopeList);
                DownloadScope fullScope = fullFile.getScopeAt(0);
                if (fullScope.getStart() != 0L || fullScope.getEnd() != this.downloadFile.getTotalDataSize() - 1L) {
                    System.out.println("ouch1");
                }
                fullFile = new DownloadScopeList();
                fullFile.addAll(this.missingScopeList);
                fullFile.addAll(this.blockedScopeList);
                long l = this.missingScopeList.getAggregatedLength() + this.blockedScopeList.getAggregatedLength();
                if (l != fullFile.getAggregatedLength()) {
                    System.out.println("ouch2");
                }
                fullFile.addAll(this.unverifiedScopeList);
                if ((l += this.unverifiedScopeList.getAggregatedLength()) != fullFile.getAggregatedLength()) {
                    System.out.println("ouch3");
                }
                fullFile.addAll(this.toBeVerifiedScopeList);
                if ((l += this.toBeVerifiedScopeList.getAggregatedLength()) != fullFile.getAggregatedLength()) {
                    System.out.println("ouch4");
                }
                fullFile.addAll(this.finishedScopeList);
                if ((l += this.finishedScopeList.getAggregatedLength()) != fullFile.getAggregatedLength()) {
                    System.out.println("ouch5");
                }
                l = 0L;
                fullFile = new DownloadScopeList();
                l += this.unverifiedScopeList.getAggregatedLength();
                fullFile.addAll(this.unverifiedScopeList);
                l += this.toBeVerifiedScopeList.getAggregatedLength();
                fullFile.addAll(this.toBeVerifiedScopeList);
                l += this.finishedScopeList.getAggregatedLength();
                fullFile.addAll(this.finishedScopeList);
                for (DownloadScope downloadScope : this.bufferedDataScopeList) {
                    fullFile.add(downloadScope);
                    l += downloadScope.getLength();
                }
                if (l != fullFile.getAggregatedLength()) {
                    System.out.println("ouch6");
                }
                if (l != this.finalizationPhaseScopeList.getAggregatedLength()) {
                    System.out.println("ouch7");
                }
            }
            finally {
                this.finalizationLock.unlock();
            }
        }
        finally {
            this.allocationLock.unlock();
        }
    }

    public class DownloadVerificationWorker
    implements Runnable {
        private DownloadScope scope;

        public DownloadVerificationWorker(DownloadScope scope) {
            this.scope = scope;
        }

        public void run() {
            try {
                MemoryFile.this.verifyScope(this.scope);
            }
            catch (Throwable th) {
                NLogger.error(MemoryFile.class, (Object)"Download scope consistency in danger!");
                NLogger.error(MemoryFile.class, (Object)th, th);
            }
        }
    }
}

