/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.BrowseHostException;
import phex.download.PushHandler;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseMsg;
import phex.net.connection.Connection;
import phex.net.connection.SocketFactory;
import phex.net.repres.SocketFacade;
import phex.query.BrowseHostResults;
import phex.servent.Servent;
import phex.utils.GnutellaInputStream;

public class BrowseHostConnection {
    private final Servent servent;
    private final BrowseHostResults results;
    private final DestAddress address;
    private final GUID hostGUID;

    public BrowseHostConnection(Servent servent, DestAddress aAddress, GUID aHostGUID, BrowseHostResults results) {
        this.servent = servent;
        this.address = aAddress;
        this.hostGUID = aHostGUID;
        this.results = results;
    }

    public void sendBrowseHostRequest() throws IOException, BrowseHostException {
        HTTPResponse response;
        SocketFacade socket;
        block14: {
            NLogger.debug(BrowseHostConnection.class, (Object)("Connection for Browse Host to " + this.address));
            this.results.setBrowseHostStatus(BrowseHostResults.BrowseHostStatus.CONNECTING);
            try {
                socket = SocketFactory.connect(this.address);
            }
            catch (IOException exp) {
                if (this.hostGUID == null) {
                    throw exp;
                }
                socket = PushHandler.requestSocketViaPush(this.servent, this.hostGUID, 50484558L);
                if (socket != null) break block14;
                throw new IOException("Push request failed");
            }
        }
        Connection connection = new Connection(socket, this.servent.getBandwidthService().getNetworkBandwidthController());
        HTTPRequest request = new HTTPRequest("GET", "/", true);
        request.addHeader(new HTTPHeader("Host", this.address.getFullHostName()));
        request.addHeader(new HTTPHeader("Accept", "application/x-gnutella-packets"));
        request.addHeader(new HTTPHeader("Content-Length", "0"));
        request.addHeader(new HTTPHeader("Connection", "close"));
        String httpRequestStr = request.buildHTTPRequestString();
        NLogger.debug(BrowseHostConnection.class, (Object)("Sending Browse Host request: " + httpRequestStr));
        connection.write(ByteBuffer.wrap(httpRequestStr.getBytes()));
        try {
            response = HTTPProcessor.parseHTTPResponse(connection);
        }
        catch (HTTPMessageException exp) {
            throw new BrowseHostException("Invalid HTTP Response: " + exp.getMessage());
        }
        NLogger.debug(BrowseHostConnection.class, (Object)("Received Browse Host response: " + response.buildHTTPResponseString()));
        if (response.getStatusCode() < 200 || response.getStatusCode() > 299) {
            throw new BrowseHostException("Browse host request not successfull. StatusCode: " + response.getStatusCode() + " " + response.getStatusReason());
        }
        HTTPHeader typeHeader = response.getHeader("Content-Type");
        if (typeHeader == null) {
            throw new BrowseHostException("Unknwon content-type.");
        }
        GnutellaInputStream inStream = connection.getInputStream();
        HTTPHeader encHeader = response.getHeader("Transfer-Encoding");
        if (encHeader != null && encHeader.getValue().equals("chunked")) {
            inStream = new ChunkedInputStream((InputStream)inStream);
        }
        if (typeHeader.getValue().equals("application/x-gnutella-packets")) {
            MsgHeader header;
            this.results.setBrowseHostStatus(BrowseHostResults.BrowseHostStatus.FETCHING);
            byte[] headerBuffer = new byte[23];
            while ((header = MessageProcessor.parseMessageHeader(inStream, headerBuffer)) != null) {
                if (header.getPayload() != -127) {
                    throw new BrowseHostException("Wrong header payload. Expecting query hit: " + header.getPayload());
                }
                try {
                    QueryResponseMsg message = (QueryResponseMsg)MessageProcessor.parseMessage(header, inStream, this.servent.getSecurityService());
                    message.getHeader().setTTL((byte)0);
                    this.servent.getMessageService().dispatchMessage(message, null);
                    this.results.processResponse(message);
                }
                catch (InvalidMessageException exp) {
                    NLogger.debug(BrowseHostConnection.class, (Object)exp, (Throwable)exp);
                    throw new IOException("Invalid message returned: " + exp.getMessage());
                }
            }
        } else {
            throw new BrowseHostException("Not supported content-type. " + typeHeader.getValue());
        }
    }
}

