/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Arrays;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;

public class DefaultDestAddress
implements DestAddress {
    public static final int DEFAULT_PORT = 6346;
    private int hash = 0;
    private String hostName;
    private IpAddress ipAddress;
    private int port;
    private long lastIpLookupTime = -1L;

    public DefaultDestAddress(String aHostName, int aPort) {
        throw new NullPointerException("Something tried creating a DefaultDestAddress!");
    }

    public DefaultDestAddress(IpAddress ipAddress, int port) {
        throw new NullPointerException("Something tried creating a DefaultDestAddress!");
    }

    public DefaultDestAddress(byte[] aHostIP, int aPort) {
        throw new NullPointerException("Something tried creating a DefaultDestAddress!");
    }

    public String getHostName() {
        if (this.hostName == null) {
            return this.ipAddress.getFormatedString();
        }
        return this.hostName;
    }

    public boolean isIpHostName() {
        if (this.hostName == null) {
            return true;
        }
        if (this.ipAddress == null) {
            return false;
        }
        return this.hostName.equals(this.ipAddress.getFormatedString());
    }

    public String getFullHostName() {
        StringBuffer buffer = new StringBuffer(21);
        buffer.append(this.getHostName());
        buffer.append(':');
        buffer.append(this.port);
        return buffer.toString();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPort) {
        this.port = newPort;
        this.hash = 0;
    }

    public IpAddress getIpAddress() {
        if (this.ipAddress == null || this.lastIpLookupTime > 0L && this.lastIpLookupTime + 60000L < System.currentTimeMillis()) {
            try {
                NLogger.debug(DefaultDestAddress.class, (Object)("Performing IP lookup " + this.hostName));
                byte[] ip = InetAddress.getByName(this.hostName).getAddress();
                this.ipAddress = new IpAddress(ip);
                this.lastIpLookupTime = System.currentTimeMillis();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.ipAddress;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultDestAddress) {
            return this.equals((DestAddress)obj);
        }
        return false;
    }

    public boolean equals(DestAddress address) {
        if (address == null) {
            return false;
        }
        if (this.ipAddress != null && address.getIpAddress() != null) {
            return this.ipAddress.equals(address.getIpAddress()) && this.port == address.getPort();
        }
        return this.getHostName().equals(address.getHostName()) && this.port == address.getPort();
    }

    public boolean equals(byte[] testIp, int testPort) {
        if (this.ipAddress != null) {
            return Arrays.equals(this.ipAddress.getHostIP(), testIp) && this.port == testPort;
        }
        return this.getHostName().equals(AddressUtils.ip2string(testIp)) && this.port == testPort;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = 0;
            h = 31 * h + this.port;
            h = this.ipAddress != null ? 31 * h + this.ipAddress.hashCode() : 127 * h + this.hostName.hashCode();
            this.hash = h;
        }
        return this.hash;
    }

    public String getCountryCode() {
        if (this.ipAddress != null) {
            return this.ipAddress.getCountryCode();
        }
        return null;
    }

    public boolean isLocalHost(DestAddress localAddress) {
        IpAddress ipAddr = this.getIpAddress();
        if (ipAddr != null && ipAddr.isLocalAddress(localAddress)) {
            return true;
        }
        return localAddress.equals(this);
    }

    public boolean isSiteLocalAddress() {
        IpAddress ip = this.getIpAddress();
        if (ip == null) {
            return false;
        }
        return ip.isSiteLocalIP();
    }

    public boolean isValidAddress() {
        boolean validPort = AddressUtils.isPortInRange(this.port);
        boolean validAddress = this.getIpAddress() != null ? this.getIpAddress().isValidIP() : true;
        return validPort && validAddress;
    }

    public String toString() {
        return this.getFullHostName();
    }

    static {
        Security.setProperty("networkaddress.cache.ttl", "120");
        Security.setProperty("networkaddress.cache.negative.ttl", "120");
    }
}

