/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.Localizer;

public class AltLocContainerTest
extends TestCase {
    private static final PhexSecurityManager securityService = new PhexSecurityManager();
    private static final String DEFAULT_URN = "urn:sha1:PLSTHIPQGSSATS5FJUPAKUZWUGYQYPFB";
    private static final String DEFAULT_ALTLOC = "http://1.1.1.1:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSATS5FJUPAKUZWUGYQYPFB 2002-04-30T08:30:00Z";
    private static final String ALT1_ALTLOC = "http://2.2.2.2:6347/uri-res/N2R?urn:sha1:PLSTHIPQGSSATS5FJUPAKUZWUGYQYPFB 2002-04-30T08:30:00Z";
    private int nextAltLocCounter;
    private AltLocContainer testContainer;

    public void setUp() {
        PhexCorePrefs.init();
        PhexGuiPrefs.init();
        Localizer.initialize(InterfacePrefs.LocaleName.get());
        Servent servent = Servent.getInstance();
        this.nextAltLocCounter = 0;
        this.testContainer = new AltLocContainer(new URN(DEFAULT_URN));
        AltLocContainerTest.assertEquals((int)0, (int)this.testContainer.getSize());
    }

    public void testAddContainer() {
        Object object;
        Object object2;
        for (int i = 0; i < 10; ++i) {
            object2 = "http://1.1.1." + i + ":6347/uri-res/N2R?" + DEFAULT_URN + " 2002-04-30T08:30:" + i % 60 + "Z";
            object = AlternateLocation.parseUriResAltLoc((String)object2, securityService);
            AltLocContainerTest.assertNotNull((Object)object);
            this.testContainer.addAlternateLocation((AlternateLocation)object);
        }
        AltLocContainerTest.assertEquals((int)10, (int)this.testContainer.getSize());
        AltLocContainer altLocContainer = new AltLocContainer(new URN(DEFAULT_URN));
        altLocContainer.addContainer(this.testContainer);
        AltLocContainerTest.assertEquals((int)10, (int)altLocContainer.getSize());
        object2 = this.testContainer.getAltLocsForExport();
        object = altLocContainer.getAltLocsForExport();
        AltLocContainerTest.assertTrue((boolean)object2.containsAll((Collection<?>)object));
        AltLocContainerTest.assertTrue((boolean)object.containsAll((Collection<?>)object2));
    }

    public void testAddAlternateLocation() {
        for (int i = 0; i < 10; ++i) {
            String string = "http://1.1.1." + i + ":6347/uri-res/N2R?" + DEFAULT_URN + " 2002-04-30T08:30:" + i % 60 + "Z";
            AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(string, securityService);
            AltLocContainerTest.assertNotNull((Object)alternateLocation);
            this.testContainer.addAlternateLocation(alternateLocation);
            AltLocContainerTest.assertEquals((int)Math.min(i + 1, 100), (int)this.testContainer.getSize());
        }
    }

    public void testDoubleAddAlternateLocation() {
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(DEFAULT_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation);
        this.testContainer.addAlternateLocation(alternateLocation);
        AltLocContainerTest.assertEquals((int)1, (int)this.testContainer.getSize());
        alternateLocation = AlternateLocation.parseUriResAltLoc(DEFAULT_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation);
        this.testContainer.addAlternateLocation(alternateLocation);
        AltLocContainerTest.assertEquals((int)1, (int)this.testContainer.getSize());
    }

    public void testLRUAddAlternateLocation() {
        int n;
        AlternateLocation alternateLocation;
        AlternateLocation alternateLocation2 = AlternateLocation.parseUriResAltLoc(ALT1_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation2);
        this.testContainer.addAlternateLocation(alternateLocation2);
        for (int i = 0; i < 99; ++i) {
            alternateLocation = this.generateNextUniqueAltLoc();
            AltLocContainerTest.assertNotNull((Object)alternateLocation);
            this.testContainer.addAlternateLocation(alternateLocation);
        }
        Set<DestAddress> set = this.testContainer.getAltLocsForExport();
        AltLocContainerTest.assertTrue((boolean)set.contains(alternateLocation2.getHostAddress()));
        this.testContainer.addAlternateLocation(alternateLocation2);
        for (n = 0; n < 99; ++n) {
            alternateLocation = this.generateNextUniqueAltLoc();
            AltLocContainerTest.assertNotNull((Object)alternateLocation);
            this.testContainer.addAlternateLocation(alternateLocation);
        }
        set = this.testContainer.getAltLocsForExport();
        AltLocContainerTest.assertTrue((boolean)set.contains(alternateLocation2.getHostAddress()));
        for (n = 0; n < 200; ++n) {
            alternateLocation = this.generateNextUniqueAltLoc();
            AltLocContainerTest.assertNotNull((Object)alternateLocation);
            this.testContainer.addAlternateLocation(alternateLocation);
        }
        Set<DestAddress> set2 = this.testContainer.getAltLocsForExport();
        AltLocContainerTest.assertFalse((boolean)set2.contains(alternateLocation2.getHostAddress()));
    }

    public void testRemoveAlternateLocation() {
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(DEFAULT_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation);
        this.testContainer.addAlternateLocation(alternateLocation);
        AltLocContainerTest.assertEquals((int)1, (int)this.testContainer.getSize());
        AlternateLocation alternateLocation2 = AlternateLocation.parseUriResAltLoc(DEFAULT_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation2);
        this.testContainer.removeAlternateLocation(alternateLocation2);
        AltLocContainerTest.assertEquals((int)0, (int)this.testContainer.getSize());
    }

    public void testIsEmpty() {
        AltLocContainerTest.assertTrue((boolean)this.testContainer.isEmpty());
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(DEFAULT_ALTLOC, securityService);
        AltLocContainerTest.assertNotNull((Object)alternateLocation);
        this.testContainer.addAlternateLocation(alternateLocation);
        AltLocContainerTest.assertFalse((boolean)this.testContainer.isEmpty());
    }

    private AlternateLocation generateNextUniqueAltLoc() {
        ++this.nextAltLocCounter;
        String string = AddressUtils.ip2string(this.nextAltLocCounter);
        AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc("http://" + string + ":6347/uri-res/N2R?" + DEFAULT_URN, securityService);
        return alternateLocation;
    }
}

