/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import junit.framework.TestCase;
import phex.common.bandwidth.BandwidthController;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.net.connection.Connection;
import phex.net.repres.SocketFacade;
import phex.utils.DummySocketFacade;

public class TestHTTPProcessor
extends TestCase {
    private String fullHTTPRequest;

    public TestHTTPProcessor(String string) {
        super(string);
    }

    protected void setUp() {
        this.fullHTTPRequest = "GET / HTTP/1.1\r\nHeader1: header1 value\r\nHeader2: header2\r\n value\r\nHeader3: header3\r\n\t  \tval\r\n ue\r\nHeader4: header4\r\n\t  \tvalue\r\nHeader5: header5\r\n\r\nDATA...DATA...DATA";
    }

    protected void tearDown() {
    }

    public void testParseHTTPRequest() {
        DummySocketFacade dummySocketFacade = new DummySocketFacade(this.fullHTTPRequest.getBytes());
        Connection connection = new Connection((SocketFacade)dummySocketFacade, new BandwidthController("JUnitText", Long.MAX_VALUE));
        try {
            HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest((Connection)connection);
            TestHTTPProcessor.assertEquals((String)"GET", (String)hTTPRequest.getRequestMethod());
            TestHTTPProcessor.assertEquals((String)"/", (String)hTTPRequest.getRequestURI());
            TestHTTPProcessor.assertEquals((String)"HTTP/1.1", (String)hTTPRequest.getHTTPVersion());
            TestHTTPProcessor.assertEquals((String)"header1 value", (String)hTTPRequest.getHeader("Header1").getValue());
            TestHTTPProcessor.assertEquals((String)"header2 value", (String)hTTPRequest.getHeader("Header2").getValue());
            TestHTTPProcessor.assertEquals((String)"header3 val ue", (String)hTTPRequest.getHeader("Header3").getValue());
            TestHTTPProcessor.assertEquals((String)"header4 value", (String)hTTPRequest.getHeader("Header4").getValue());
            TestHTTPProcessor.assertEquals((String)"header5", (String)hTTPRequest.getHeader("Header5").getValue());
        }
        catch (Exception exception) {
            System.err.println("Exception thrown:  " + exception);
            TestHTTPProcessor.fail((String)exception.getMessage());
        }
    }
}

