/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import junit.framework.TestCase;
import phex.common.bandwidth.BandwidthController;
import phex.io.buffer.ByteBuffer;
import phex.net.connection.Connection;
import phex.net.repres.SocketFacade;
import phex.utils.DummySocketFacade;

public class TestConnection
extends TestCase {
    public void testWriteByteBuffer() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)20);
        byte[] byArray = "Hello World".getBytes();
        byteBuffer.put(byArray, 0, byArray.length);
        byteBuffer.flip();
        DummySocketFacade dummySocketFacade = new DummySocketFacade(byArray);
        Connection connection = new Connection((SocketFacade)dummySocketFacade, new BandwidthController("JUnitText", Long.MAX_VALUE));
        connection.write(byteBuffer);
        byte[] byArray2 = dummySocketFacade.getOutData();
        TestConnection.assertTrue((boolean)Arrays.equals(byArray, byArray2));
        TestConnection.assertEquals((int)byteBuffer.position(), (int)byArray.length);
        TestConnection.assertEquals((int)byteBuffer.remaining(), (int)0);
    }

    public void testReadByteBuffer() throws IOException {
        String string = "Hello World";
        byte[] byArray = string.getBytes();
        DummySocketFacade dummySocketFacade = new DummySocketFacade(byArray);
        Connection connection = new Connection((SocketFacade)dummySocketFacade, new BandwidthController("JUnitText", Long.MAX_VALUE));
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)20);
        connection.read(byteBuffer);
        byteBuffer.flip();
        int n = byteBuffer.remaining();
        TestConnection.assertEquals((int)byArray.length, (int)n);
        String string2 = byteBuffer.getString(Charset.forName("UTF-8").newDecoder());
        TestConnection.assertEquals((String)string, (String)string2);
        TestConnection.assertEquals((int)byteBuffer.position(), (int)byArray.length);
        TestConnection.assertEquals((int)byteBuffer.remaining(), (int)0);
    }
}

