/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.SchedulerImpl;
import net.i2p.util.Log;

class SchedulerReceived
extends SchedulerImpl {
    private Log _log;

    public SchedulerReceived(I2PAppContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(SchedulerReceived.class);
    }

    public boolean accept(Connection con) {
        return con != null && con.getLastSendId() < 0L && con.getSendStreamId() > 0L;
    }

    public void eventOccurred(Connection con) {
        if (con.getUnackedPacketsReceived() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("hmm, state is received, but no unacked packets received?");
            }
            return;
        }
        long timeTillSend = con.getNextSendTime() - this._context.clock().now();
        if (timeTillSend <= 0L) {
            if (con.getNextSendTime() > 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("received con... send a packet");
                }
                con.sendAvailable();
                con.setNextSendTime(-1L);
            } else {
                con.setNextSendTime(this._context.clock().now() + (long)con.getOptions().getSendAckDelay());
                this.reschedule(con.getOptions().getSendAckDelay(), con);
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("received con... time till next send: " + timeTillSend);
            }
            this.reschedule(timeTillSend, con);
        }
    }
}

