/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.util.Log;

public class I2PThread
extends Thread {
    private static volatile Log _log;
    private static Set _listeners;
    private String _name;
    private Exception _createdBy;
    static /* synthetic */ Class class$net$i2p$util$I2PThread;

    public I2PThread() {
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(String name) {
        super(name);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r) {
        super(r);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r, String name) {
        super(r, name);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r, String name, boolean isDaemon) {
        super(r, name);
        this.setDaemon(isDaemon);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    private void log(int level, String msg) {
        this.log(level, msg, null);
    }

    private void log(int level, String msg, Throwable t) {
        if (_log == null) {
            _log = new Log(class$net$i2p$util$I2PThread == null ? (class$net$i2p$util$I2PThread = I2PThread.class$("net.i2p.util.I2PThread")) : class$net$i2p$util$I2PThread);
        }
        if (_log.shouldLog(level)) {
            _log.log(level, msg, t);
        }
    }

    public void run() {
        block4: {
            this._name = Thread.currentThread().getName();
            this.log(10, "New thread started: " + this._name, this._createdBy);
            try {
                super.run();
            }
            catch (Throwable t) {
                try {
                    this.log(50, "Killing thread " + this.getName(), t);
                }
                catch (Throwable woof) {
                    System.err.println("Died within the OOM itself");
                    t.printStackTrace();
                }
                if (!(t instanceof OutOfMemoryError)) break block4;
                this.fireOOM((OutOfMemoryError)t);
            }
        }
        this.log(10, "Thread finished gracefully: " + this._name);
    }

    protected void finalize() throws Throwable {
        this.log(10, "Thread finalized: " + this._name);
        super.finalize();
    }

    private void fireOOM(OutOfMemoryError oom) {
        Iterator iter = _listeners.iterator();
        while (iter.hasNext()) {
            OOMEventListener listener = (OOMEventListener)iter.next();
            listener.outOfMemory(oom);
        }
    }

    public static void addOOMEventListener(OOMEventListener lsnr) {
        _listeners.add(lsnr);
    }

    public static void removeOOMEventListener(OOMEventListener lsnr) {
        _listeners.remove(lsnr);
    }

    public static void main(String[] args) {
        I2PThread t = new I2PThread(new Runnable(){

            public void run() {
                throw new NullPointerException("blah");
            }
        });
        t.start();
        try {
            Thread.sleep(10000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _listeners = new HashSet(4);
    }

    public static interface OOMEventListener {
        public void outOfMemory(OutOfMemoryError var1);
    }
}

