/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.crypto.prng.AsyncFortunaStandalone;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.util.RandomSource;

public class FortunaRandomSource
extends RandomSource
implements EntropyHarvester {
    private AsyncFortunaStandalone _fortuna = new AsyncFortunaStandalone();
    private double _nextGaussian;
    private boolean _haveNextGaussian;

    public FortunaRandomSource(I2PAppContext context) {
        super(context);
        byte[] seed = new byte[1024];
        if (this.initSeed(seed)) {
            this._fortuna.seed(seed);
        } else {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(seed);
            this._fortuna.seed(seed);
        }
        this._fortuna.startup();
        this._fortuna.nextBytes(seed);
        this._haveNextGaussian = false;
    }

    public synchronized void setSeed(byte[] buf) {
        this._fortuna.addRandomBytes(buf);
    }

    public int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        int rv = this.signedNextInt(n);
        if (rv < 0) {
            rv = 0 - rv;
        }
        return rv %= n;
    }

    public int nextInt() {
        return this.signedNextInt(Integer.MAX_VALUE);
    }

    private int signedNextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int numBits = 0;
        int remaining = n;
        int rv = 0;
        while (remaining > 0) {
            remaining >>= 1;
            rv += this.nextBits(8) << numBits * 8;
            ++numBits;
        }
        if (rv < 0) {
            rv += n;
        }
        return rv % n;
    }

    public long nextLong(long n) {
        if (n == 0L) {
            return 0L;
        }
        long rv = this.signedNextLong(n);
        if (rv < 0L) {
            rv = 0L - rv;
        }
        return rv %= n;
    }

    public long nextLong() {
        return this.signedNextLong(Long.MAX_VALUE);
    }

    private long signedNextLong(long n) {
        return ((long)this.nextBits(32) << 32) + (long)this.nextBits(32);
    }

    public synchronized boolean nextBoolean() {
        byte val = this._fortuna.nextByte();
        return (val & 1) == 1;
    }

    public synchronized void nextBytes(byte[] buf) {
        this._fortuna.nextBytes(buf);
    }

    public double nextDouble() {
        return (double)(((long)this.nextBits(26) << 27) + (long)this.nextBits(27)) / 9.007199254740992E15;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this._haveNextGaussian) {
            this._haveNextGaussian = false;
            return this._nextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this._nextGaussian = v2 * multiplier;
        this._haveNextGaussian = true;
        return v1 * multiplier;
    }

    protected synchronized int nextBits(int numBits) {
        long rv = 0L;
        int bytes = (numBits + 7) / 8;
        for (int i = 0; i < bytes; ++i) {
            rv += (long)((this._fortuna.nextByte() & 0xFF) << i * 8);
        }
        if (rv < 0L) {
            rv = 0L - rv;
        }
        int off = 8 * bytes - numBits;
        return (int)(rv >>>= off);
    }

    public EntropyHarvester harvester() {
        return this;
    }

    public synchronized void feedEntropy(String source, long data, int bitoffset, int bits) {
        this._fortuna.addRandomByte((byte)(data & 0xFFL));
    }

    public synchronized void feedEntropy(String source, byte[] data, int offset, int len) {
        this._fortuna.addRandomBytes(data, offset, len);
    }

    public static void main(String[] args) {
        try {
            RandomSource rand = I2PAppContext.getGlobalContext().random();
            for (int i = 0; i < 1000; ++i) {
                if (!(rand.nextFloat() < 0.0f)) continue;
                throw new RuntimeException("negative!");
            }
            System.out.println("All positive");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

