/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.time.Timestamper;
import net.i2p.util.Log;

public class Clock
implements Timestamper.UpdateListener {
    protected I2PAppContext _context;
    private Timestamper _timestamper;
    protected long _startedOn;
    protected boolean _statCreated;
    protected volatile long _offset;
    protected boolean _alreadyChanged;
    private Set _listeners;
    public static final long MAX_OFFSET = 259200000L;
    public static final long MAX_LIVE_OFFSET = 600000L;
    public static final long MIN_OFFSET_CHANGE = 10000L;
    static /* synthetic */ Class class$net$i2p$util$Clock;

    public Clock(I2PAppContext context) {
        this._context = context;
        this._offset = 0L;
        this._alreadyChanged = false;
        this._listeners = new HashSet(64);
        this._timestamper = new Timestamper(context, this);
        this._startedOn = System.currentTimeMillis();
        this._statCreated = false;
    }

    public static Clock getInstance() {
        return I2PAppContext.getGlobalContext().clock();
    }

    public Timestamper getTimestamper() {
        return this._timestamper;
    }

    protected Log getLog() {
        return this._context.logManager().getLog(class$net$i2p$util$Clock == null ? (class$net$i2p$util$Clock = Clock.class$("net.i2p.util.Clock")) : class$net$i2p$util$Clock);
    }

    public void setOffset(long offsetMs) {
        this.setOffset(offsetMs, false);
    }

    public void setOffset(long offsetMs, boolean force) {
        long delta = offsetMs - this._offset;
        if (!force) {
            if (offsetMs > 259200000L || offsetMs < -259200000L) {
                this.getLog().error("Maximum offset shift exceeded [" + offsetMs + "], NOT HONORING IT");
                return;
            }
            if (this._alreadyChanged && System.currentTimeMillis() - this._startedOn > 600000L && (delta > 600000L || delta < -600000L)) {
                this.getLog().log(50, "The clock has already been updated, but you want to change it by " + delta + " to " + offsetMs + "?  Did something break?");
                return;
            }
            if (delta < 10000L && delta > -10000L) {
                this.getLog().debug("Not changing offset since it is only " + delta + "ms");
                this._alreadyChanged = true;
                return;
            }
        }
        if (this._alreadyChanged) {
            if (delta > 15000L) {
                this.getLog().log(50, "Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            } else if (this.getLog().shouldLog(20)) {
                this.getLog().info("Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            }
            if (!this._statCreated) {
                this._context.statManager().createRateStat("clock.skew", "How far is the already adjusted clock being skewed?", "Clock", new long[]{600000L, 10800000L, 5184000L});
            }
            this._statCreated = true;
            this._context.statManager().addRateData("clock.skew", delta, 0L);
        } else {
            this.getLog().log(20, "Initializing clock offset to " + offsetMs + "ms from " + this._offset + "ms");
        }
        this._alreadyChanged = true;
        this._offset = offsetMs;
        this.fireOffsetChanged(delta);
    }

    public long getOffset() {
        return this._offset;
    }

    public boolean getUpdatedSuccessfully() {
        return this._alreadyChanged;
    }

    public void setNow(long realTime) {
        long diff = realTime - System.currentTimeMillis();
        this.setOffset(diff);
    }

    public long now() {
        return this._offset + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(ClockUpdateListener lsnr) {
        Set set = this._listeners;
        synchronized (set) {
            this._listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(ClockUpdateListener lsnr) {
        Set set = this._listeners;
        synchronized (set) {
            this._listeners.remove(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOffsetChanged(long delta) {
        Set set = this._listeners;
        synchronized (set) {
            Iterator iter = this._listeners.iterator();
            while (iter.hasNext()) {
                ClockUpdateListener lsnr = (ClockUpdateListener)iter.next();
                lsnr.offsetChanged(delta);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ClockUpdateListener {
        public void offsetChanged(long var1);
    }
}

