/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class StatLogSplitter {
    private static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss.SSS";
    private static SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: StatLogSplitter filename");
            return;
        }
        StatLogSplitter.splitLog(args[0]);
    }

    private static void splitLog(String filename) {
        HashMap<String, FileWriter> outputFiles = new HashMap<String, FileWriter>(4);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            long first = 0L;
            while ((line = in.readLine()) != null) {
                String date = line.substring(0, DATE_FORMAT.length()).trim();
                int endGroup = line.indexOf(32, DATE_FORMAT.length() + 1);
                int endStat = line.indexOf(32, endGroup + 1);
                int endValue = line.indexOf(32, endStat + 1);
                String group = line.substring(DATE_FORMAT.length() + 1, endGroup).trim();
                String stat = line.substring(endGroup, endStat).trim();
                String value = line.substring(endStat, endValue).trim();
                String duration = line.substring(endValue).trim();
                try {
                    Date when = _fmt.parse(date);
                    if (first <= 0L) {
                        first = when.getTime();
                    }
                    long val = Long.parseLong(value);
                    long time = Long.parseLong(duration);
                    if (!outputFiles.containsKey(stat)) {
                        outputFiles.put(stat, new FileWriter(stat + ".dat"));
                        System.out.println("Including data to " + stat + ".dat");
                    }
                    FileWriter out = (FileWriter)outputFiles.get(stat);
                    double s = (double)(when.getTime() - first) / 1000.0;
                    out.write(s + " " + val + " [" + line + "]\n");
                    out.flush();
                }
                catch (ParseException pe) {
                }
                catch (NumberFormatException nfe) {}
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Iterator iter = outputFiles.values().iterator();
        while (iter.hasNext()) {
            FileWriter out = (FileWriter)iter.next();
            try {
                out.close();
            }
            catch (IOException ioe) {}
        }
    }
}

