/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import gnu.crypto.hash.Sha256Standalone;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataStructure;
import net.i2p.util.ByteCache;
import net.i2p.util.OrderedProperties;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.ReusableGZIPOutputStream;

public class DataHelper {
    private static final byte[] _equalBytes = "=".getBytes();
    private static final byte[] _semicolonBytes = ";".getBytes();
    private static final byte[] EMPTY_BUFFER = "".getBytes();
    public static final int DATE_LENGTH = 8;
    public static final byte BOOLEAN_TRUE = 1;
    public static final byte BOOLEAN_FALSE = 0;
    public static final byte BOOLEAN_UNKNOWN = 2;
    public static final int BOOLEAN_LENGTH = 1;
    private static final int MAX_UNCOMPRESSED = 40960;

    public static Properties readProperties(InputStream rawStream) throws DataFormatException, IOException {
        OrderedProperties props = new OrderedProperties();
        long size = DataHelper.readLong(rawStream, 2);
        byte[] data = new byte[(int)size];
        int read = DataHelper.read(rawStream, data);
        if ((long)read != size) {
            throw new DataFormatException("Not enough data to read the properties");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        byte[] eqBuf = new byte[_equalBytes.length];
        byte[] semiBuf = new byte[_semicolonBytes.length];
        while (in.available() > 0) {
            String key = DataHelper.readString(in);
            read = DataHelper.read(in, eqBuf);
            if (read != eqBuf.length || !DataHelper.eq(eqBuf, _equalBytes)) break;
            String val = DataHelper.readString(in);
            read = DataHelper.read(in, semiBuf);
            if (read != semiBuf.length || !DataHelper.eq(semiBuf, _semicolonBytes)) break;
            ((Properties)props).put(key, val);
        }
        return props;
    }

    public static void writeProperties(OutputStream rawStream, Properties props) throws DataFormatException, IOException {
        if (props != null) {
            OrderedProperties p = new OrderedProperties();
            p.putAll((Map)props);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
            Iterator iter = p.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = p.getProperty(key);
                DataHelper.writeString(baos, key);
                baos.write(_equalBytes);
                DataHelper.writeString(baos, val);
                baos.write(_semicolonBytes);
            }
            baos.close();
            byte[] propBytes = baos.toByteArray();
            DataHelper.writeLong(rawStream, 2, propBytes.length);
            rawStream.write(propBytes);
        } else {
            DataHelper.writeLong(rawStream, 2, 0L);
        }
    }

    public static int toProperties(byte[] target, int offset, Properties props) throws DataFormatException, IOException {
        if (props != null) {
            OrderedProperties p = new OrderedProperties();
            p.putAll((Map)props);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
            Iterator iter = p.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = p.getProperty(key);
                DataHelper.writeString(baos, key);
                baos.write(_equalBytes);
                DataHelper.writeString(baos, val);
                baos.write(_semicolonBytes);
            }
            baos.close();
            byte[] propBytes = baos.toByteArray();
            DataHelper.toLong(target, offset, 2, propBytes.length);
            System.arraycopy(propBytes, 0, target, offset += 2, propBytes.length);
            return offset += propBytes.length;
        }
        DataHelper.toLong(target, offset, 2, 0L);
        return offset + 2;
    }

    public static int fromProperties(byte[] source, int offset, Properties target) throws DataFormatException, IOException {
        int size = (int)DataHelper.fromLong(source, offset, 2);
        ByteArrayInputStream in = new ByteArrayInputStream(source, offset += 2, size);
        byte[] eqBuf = new byte[_equalBytes.length];
        byte[] semiBuf = new byte[_semicolonBytes.length];
        while (in.available() > 0) {
            String key = DataHelper.readString(in);
            int read = DataHelper.read(in, eqBuf);
            if (read != eqBuf.length || !DataHelper.eq(eqBuf, _equalBytes)) break;
            String val = DataHelper.readString(in);
            read = DataHelper.read(in, semiBuf);
            if (read != semiBuf.length || !DataHelper.eq(semiBuf, _semicolonBytes)) break;
            target.put(key, val);
        }
        return offset + size;
    }

    public static byte[] toProperties(Properties opts) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
            DataHelper.writeProperties(baos, opts);
            return baos.toByteArray();
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException("Format error writing to memory?! " + dfe.getMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO error writing to memory?! " + ioe.getMessage());
        }
    }

    public static String toString(Properties options) {
        StringBuffer buf = new StringBuffer();
        if (options != null) {
            Iterator<Object> iter = options.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = options.getProperty(key);
                buf.append("[").append(key).append("] = [").append(val).append("]");
            }
        } else {
            buf.append("(null properties map)");
        }
        return buf.toString();
    }

    public static void loadProps(Properties props, File file) throws IOException {
        DataHelper.loadProps(props, file, false);
    }

    public static void loadProps(Properties props, File file, boolean forceLowerCase) throws IOException {
        DataHelper.loadProps(props, new FileInputStream(file), forceLowerCase);
    }

    public static void loadProps(Properties props, InputStream inStr) throws IOException {
        DataHelper.loadProps(props, inStr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadProps(Properties props, InputStream inStr, boolean forceLowerCase) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStr, "UTF-8"), 16384);
            String line = null;
            while ((line = in.readLine()) != null) {
                int split;
                if (line.trim().length() <= 0 || line.charAt(0) == '#' || line.charAt(0) == ';') continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                String val = line.substring(split + 1);
                if (key.length() <= 0 || val.length() <= 0) continue;
                if (forceLowerCase) {
                    props.setProperty(key.toLowerCase(), val);
                    continue;
                }
                props.setProperty(key, val);
            }
            Object var9_8 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ioe) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProps(Properties props, File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String val = props.getProperty(name);
                out.println(name + "=" + val);
            }
            out.flush();
            out.close();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String toString(Collection col) {
        StringBuffer buf = new StringBuffer();
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                buf.append("[").append(o).append("]");
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public static String toString(byte[] buf) {
        if (buf == null) {
            return "";
        }
        return DataHelper.toString(buf, buf.length);
    }

    public static String toString(byte[] buf, int len) {
        int i;
        if (buf == null) {
            buf = EMPTY_BUFFER;
        }
        StringBuffer out = new StringBuffer();
        if (len > buf.length) {
            for (i = 0; i < len - buf.length; ++i) {
                out.append("00");
            }
        }
        for (i = 0; i < buf.length && i < len; ++i) {
            StringBuffer temp = new StringBuffer(Integer.toHexString(buf[i]));
            while (temp.length() < 2) {
                temp.insert(0, '0');
            }
            temp = new StringBuffer(temp.substring(temp.length() - 2));
            out.append(temp.toString());
        }
        return out.toString();
    }

    public static String toDecimalString(byte[] buf, int len) {
        if (buf == null) {
            buf = EMPTY_BUFFER;
        }
        BigInteger val = new BigInteger(1, buf);
        return val.toString(10);
    }

    public static final String toHexString(byte[] data) {
        if (data == null || data.length <= 0) {
            return "00";
        }
        BigInteger bi = new BigInteger(1, data);
        return bi.toString(16);
    }

    public static final byte[] fromHexString(String val) {
        BigInteger bv = new BigInteger(val, 16);
        return bv.toByteArray();
    }

    public static long readLong(InputStream rawStream, int numBytes) throws DataFormatException, IOException {
        if (numBytes > 8) {
            throw new DataFormatException("readLong doesn't currently support reading numbers > 8 bytes [as thats bigger than java's long]");
        }
        long rv = 0L;
        for (int i = 0; i < numBytes; ++i) {
            long cur = rawStream.read() & 0xFF;
            if (cur == -1L) {
                throw new DataFormatException("Not enough bytes for the field");
            }
            if (cur == 0L) continue;
            long remaining = numBytes - i;
            int j = 0;
            while ((long)j < remaining) {
                long shiftAmount = 8L * (remaining - (long)j - 1L);
                rv += (cur <<= (int)shiftAmount);
                if ((long)(j + 1) < remaining && (cur = (long)(rawStream.read() & 0xFF)) == -1L) {
                    throw new DataFormatException("Not enough bytes for the field");
                }
                ++j;
            }
            break;
        }
        return rv;
    }

    public static void writeLong(OutputStream rawStream, int numBytes, long value) throws DataFormatException, IOException {
        if (value < 0L) {
            throw new DataFormatException("Value is negative (" + value + ")");
        }
        for (int i = numBytes - 1; i >= 0; --i) {
            byte cur = (byte)(value >>> i * 8 & 0xFFL);
            rawStream.write(cur);
        }
    }

    public static byte[] toLong(int numBytes, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        byte[] val = new byte[numBytes];
        DataHelper.toLong(val, 0, numBytes, value);
        return val;
    }

    public static void toLong(byte[] target, int offset, int numBytes, long value) throws IllegalArgumentException {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        for (int i = 0; i < numBytes; ++i) {
            target[offset + numBytes - i - 1] = (byte)(value >>> i * 8);
        }
    }

    public static long fromLong(byte[] src, int offset, int numBytes) {
        if (src == null || src.length == 0) {
            return 0L;
        }
        long rv = 0L;
        for (int i = 0; i < numBytes; ++i) {
            long cur = src[offset + i] & 0xFF;
            if (cur < 0L) {
                cur += 256L;
            }
            rv += (cur <<= 8 * (numBytes - i - 1));
        }
        if (rv < 0L) {
            throw new IllegalArgumentException("wtf, fromLong got a negative? " + rv + ": offset=" + offset + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static Date readDate(InputStream in) throws DataFormatException, IOException {
        long date = DataHelper.readLong(in, 8);
        if (date == 0L) {
            return null;
        }
        return new Date(date);
    }

    public static void writeDate(OutputStream out, Date date) throws DataFormatException, IOException {
        if (date == null) {
            DataHelper.writeLong(out, 8, 0L);
        } else {
            DataHelper.writeLong(out, 8, date.getTime());
        }
    }

    public static byte[] toDate(Date date) throws IllegalArgumentException {
        if (date == null) {
            return DataHelper.toLong(8, 0L);
        }
        return DataHelper.toLong(8, date.getTime());
    }

    public static void toDate(byte[] target, int offset, long when) throws IllegalArgumentException {
        DataHelper.toLong(target, offset, 8, when);
    }

    public static Date fromDate(byte[] src, int offset) throws DataFormatException {
        if (src == null || offset + 8 > src.length) {
            throw new DataFormatException("Not enough data to read a date");
        }
        try {
            long when = DataHelper.fromLong(src, offset, 8);
            if (when <= 0L) {
                return null;
            }
            return new Date(when);
        }
        catch (IllegalArgumentException iae) {
            throw new DataFormatException(iae.getMessage());
        }
    }

    public static String readString(InputStream in) throws DataFormatException, IOException {
        int size = (int)DataHelper.readLong(in, 1);
        byte[] raw = new byte[size];
        int read = DataHelper.read(in, raw);
        if (read != size) {
            throw new DataFormatException("Not enough bytes to read the string");
        }
        return new String(raw);
    }

    public static void writeString(OutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            DataHelper.writeLong(out, 1, 0L);
        } else {
            int len = string.length();
            if (len > 255) {
                throw new DataFormatException("The I2P data spec limits strings to 255 bytes or less, but this is " + string.length() + " [" + string + "]");
            }
            DataHelper.writeLong(out, 1, len);
            for (int i = 0; i < len; ++i) {
                out.write((byte)(string.charAt(i) & 0xFF));
            }
        }
    }

    public static Boolean readBoolean(InputStream in) throws DataFormatException, IOException {
        int val = (int)DataHelper.readLong(in, 1);
        switch (val) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return null;
            }
        }
        throw new DataFormatException("Uhhh.. readBoolean read a value that isn't a known ternary val (0,1,2): " + val);
    }

    public static void writeBoolean(OutputStream out, Boolean bool) throws DataFormatException, IOException {
        if (bool == null) {
            DataHelper.writeLong(out, 1, 2L);
        } else if (Boolean.TRUE.equals(bool)) {
            DataHelper.writeLong(out, 1, 1L);
        } else {
            DataHelper.writeLong(out, 1, 0L);
        }
    }

    public static Boolean fromBoolean(byte[] data, int offset) {
        if (data[offset] == 1) {
            return Boolean.TRUE;
        }
        if (data[offset] == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static void toBoolean(byte[] data, int offset, boolean value) {
        data[offset] = value ? (byte)1 : 0;
    }

    public static void toBoolean(byte[] data, int offset, Boolean value) {
        data[offset] = value == null ? 2 : (value != false ? 1 : 0);
    }

    public static final boolean eq(Object lhs, Object rhs) {
        try {
            boolean eq = lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
            return eq;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static final boolean eq(Collection lhs, Collection rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator liter = lhs.iterator();
        Iterator riter = rhs.iterator();
        while (liter.hasNext() && riter.hasNext()) {
            if (DataHelper.eq(liter.next(), riter.next())) continue;
            return false;
        }
        return true;
    }

    public static final boolean eq(byte[] lhs, byte[] rhs) {
        boolean eq = lhs == null && rhs == null || lhs != null && rhs != null && Arrays.equals(lhs, rhs);
        return eq;
    }

    public static final boolean eq(int lhs, int rhs) {
        return lhs == rhs;
    }

    public static final boolean eq(long lhs, long rhs) {
        return lhs == rhs;
    }

    public static final boolean eq(byte lhs, byte rhs) {
        return lhs == rhs;
    }

    public static final boolean eq(byte[] lhs, int offsetLeft, byte[] rhs, int offsetRight, int length) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs[offsetLeft + i] == rhs[offsetRight + i]) continue;
            return false;
        }
        return true;
    }

    public static final int compareTo(byte[] lhs, byte[] rhs) {
        if (rhs == null && lhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhs.length < lhs.length) {
            return 1;
        }
        if (rhs.length > lhs.length) {
            return -1;
        }
        for (int i = 0; i < rhs.length; ++i) {
            if (rhs[i] > lhs[i]) {
                return -1;
            }
            if (rhs[i] >= lhs[i]) continue;
            return 1;
        }
        return 0;
    }

    public static final byte[] xor(byte[] lhs, byte[] rhs) {
        if (lhs == null || rhs == null || lhs.length != rhs.length) {
            return null;
        }
        byte[] rv = new byte[lhs.length];
        byte[] diff = new byte[lhs.length];
        DataHelper.xor(lhs, 0, rhs, 0, diff, 0, lhs.length);
        return diff;
    }

    public static final void xor(byte[] lhs, int startLeft, byte[] rhs, int startRight, byte[] out, int startOut, int len) {
        if (lhs == null || rhs == null || out == null) {
            throw new NullPointerException("Invalid params to xor (" + lhs + ", " + rhs + ", " + out + ")");
        }
        if (lhs.length < startLeft + len) {
            throw new IllegalArgumentException("Left hand side is too short");
        }
        if (rhs.length < startRight + len) {
            throw new IllegalArgumentException("Right hand side is too short");
        }
        if (out.length < startOut + len) {
            throw new IllegalArgumentException("Result is too short");
        }
        for (int i = 0; i < len; ++i) {
            out[startOut + i] = (byte)(lhs[startLeft + i] ^ rhs[startRight + i]);
        }
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static int hashCode(Date obj) {
        if (obj == null) {
            return 0;
        }
        return (int)obj.getTime();
    }

    public static int hashCode(byte[] b) {
        int rv = 0;
        if (b != null) {
            for (int i = 0; i < b.length && i < 32; ++i) {
                rv += b[i] << i;
            }
        }
        return rv;
    }

    public static int hashCode(Collection col) {
        if (col == null) {
            return 0;
        }
        int c = 0;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            c = 7 * c + DataHelper.hashCode(iter.next());
        }
        return c;
    }

    public static int read(InputStream in, byte[] target) throws IOException {
        return DataHelper.read(in, target, 0, target.length);
    }

    public static int read(InputStream in, byte[] target, int offset, int length) throws IOException {
        int cur;
        int numRead;
        for (cur = offset; cur < length; cur += numRead) {
            numRead = in.read(target, cur, length - cur);
            if (numRead != -1) continue;
            if (cur == offset) {
                return -1;
            }
            return cur;
        }
        return cur;
    }

    public static String readLine(InputStream in) throws IOException {
        return DataHelper.readLine(in, (Sha256Standalone)null);
    }

    public static String readLine(InputStream in, Sha256Standalone hash) throws IOException {
        StringBuffer buf = new StringBuffer(128);
        boolean ok = DataHelper.readLine(in, buf, hash);
        if (ok) {
            return buf.toString();
        }
        return null;
    }

    public static boolean readLine(InputStream in, StringBuffer buf) throws IOException {
        return DataHelper.readLine(in, buf, null);
    }

    public static boolean readLine(InputStream in, StringBuffer buf, Sha256Standalone hash) throws IOException {
        int c = -1;
        while ((c = in.read()) != -1) {
            if (hash != null) {
                hash.update((byte)c);
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        return c != -1;
    }

    public static void write(OutputStream out, byte[] data, Sha256Standalone hash) throws IOException {
        hash.update(data);
        out.write(data);
    }

    public static List sortStructures(Collection dataStructures) {
        if (dataStructures == null) {
            return new ArrayList();
        }
        ArrayList rv = new ArrayList(dataStructures.size());
        TreeMap<String, DataStructure> tm = new TreeMap<String, DataStructure>();
        Iterator<Object> iter = dataStructures.iterator();
        while (iter.hasNext()) {
            DataStructure struct = (DataStructure)iter.next();
            tm.put(struct.calculateHash().toString(), struct);
        }
        iter = tm.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            rv.add(tm.get(k));
        }
        return rv;
    }

    public static String formatDuration(long ms) {
        if (ms < 30000L) {
            return ms + "ms";
        }
        if (ms < 300000L) {
            return ms / 1000L + "s";
        }
        if (ms < 0x6DDD00L) {
            return ms / 60000L + "m";
        }
        if (ms < 259200000L) {
            return ms / 3600000L + "h";
        }
        if (ms > 31536000000L) {
            return "n/a";
        }
        return ms / 86400000L + "d";
    }

    public static String stripHTML(String orig) {
        if (orig == null) {
            return "";
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        return rv;
    }

    public static byte[] compress(byte[] orig) {
        return DataHelper.compress(orig, 0, orig.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] orig, int offset, int size) {
        if (orig == null || orig.length <= 0) {
            return orig;
        }
        if (size >= 40960) {
            throw new IllegalArgumentException("tell jrandom size=" + size);
        }
        ReusableGZIPOutputStream out = ReusableGZIPOutputStream.acquire();
        try {
            byte[] rv;
            out.write(orig, offset, size);
            out.finish();
            out.flush();
            byte[] byArray = rv = out.getData();
            return byArray;
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            ReusableGZIPOutputStream.release(out);
        }
    }

    public static byte[] decompress(byte[] orig) throws IOException {
        return orig != null ? DataHelper.decompress(orig, 0, orig.length) : null;
    }

    public static byte[] decompress(byte[] orig, int offset, int length) throws IOException {
        int read;
        if (orig == null || orig.length <= 0) {
            return orig;
        }
        ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
        in.initialize(new ByteArrayInputStream(orig, offset, length));
        ByteCache cache = ByteCache.getInstance(8, 40960);
        ByteArray outBuf = cache.acquire();
        int written = 0;
        while ((read = in.read(outBuf.getData(), written, 40960 - written)) != -1) {
            written += read;
        }
        byte[] rv = new byte[written];
        System.arraycopy(outBuf.getData(), 0, rv, 0, written);
        cache.release(outBuf);
        ReusableGZIPInputStream.release(in);
        return rv;
    }

    public static byte[] getUTF8(String orig) {
        if (orig == null) {
            return null;
        }
        try {
            return orig.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static byte[] getUTF8(StringBuffer orig) {
        if (orig == null) {
            return null;
        }
        return DataHelper.getUTF8(orig.toString());
    }

    public static String getUTF8(byte[] orig) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static String getUTF8(byte[] orig, int offset, int len) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, offset, len, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("No utf8!?");
        }
    }
}

