/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class TrustedUpdate {
    private static final String DEFAULT_TRUSTED_KEY = "W4kJbnv9KSVwbnapV7SaNW2kMIZKs~hwL0ro9pZXFo1xTwqz45nykCp1HM7sAKYDZay5z1HvYYOl9CNVz00xF03KPU9RUCVxhDZ1YXhZIskPKjUPUsCIpE~Z1C~N9KSEV6~2stDlBNH10VZ4T0X1TrcXwb3IBXliWo2y2GAx~Ow=";
    private static final String VALID_VERSION_CHARS = "0123456789.";
    private static final int VERSION_BYTES = 16;
    private static final int HEADER_BYTES = 56;
    private static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";
    private static I2PAppContext _context;
    private Log _log;
    private ArrayList _trustedKeys;
    static /* synthetic */ Class class$net$i2p$crypto$TrustedUpdate;

    public TrustedUpdate() {
        this(I2PAppContext.getGlobalContext());
    }

    public TrustedUpdate(I2PAppContext context) {
        _context = context;
        this._log = _context.logManager().getLog(class$net$i2p$crypto$TrustedUpdate == null ? (class$net$i2p$crypto$TrustedUpdate = TrustedUpdate.class$("net.i2p.crypto.TrustedUpdate")) : class$net$i2p$crypto$TrustedUpdate);
        this._trustedKeys = new ArrayList();
        String propertyTrustedKeys = context.getProperty(PROP_TRUSTED_KEYS);
        if (propertyTrustedKeys != null && propertyTrustedKeys.length() > 0) {
            StringTokenizer propertyTrustedKeysTokens = new StringTokenizer(propertyTrustedKeys, ",");
            while (propertyTrustedKeysTokens.hasMoreTokens()) {
                this._trustedKeys.add(propertyTrustedKeysTokens.nextToken().trim());
            }
        } else {
            this._trustedKeys.add(DEFAULT_TRUSTED_KEY);
        }
    }

    public static void main(String[] args) {
        try {
            if ("keygen".equals(args[0])) {
                TrustedUpdate.genKeysCLI(args[1], args[2]);
            } else if ("showversion".equals(args[0])) {
                TrustedUpdate.showVersionCLI(args[1]);
            } else if ("sign".equals(args[0])) {
                TrustedUpdate.signCLI(args[1], args[2], args[3], args[4]);
            } else if ("verifysig".equals(args[0])) {
                TrustedUpdate.verifySigCLI(args[1]);
            } else if ("verifyupdate".equals(args[0])) {
                TrustedUpdate.verifyUpdateCLI(args[1]);
            } else {
                TrustedUpdate.showUsageCLI();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            TrustedUpdate.showUsageCLI();
        }
    }

    public static final boolean needsUpdate(String currentVersion, String newVersion) {
        StringTokenizer newVersionTokens = new StringTokenizer(TrustedUpdate.sanitize(newVersion), ".");
        StringTokenizer currentVersionTokens = new StringTokenizer(TrustedUpdate.sanitize(currentVersion), ".");
        while (newVersionTokens.hasMoreTokens() && currentVersionTokens.hasMoreTokens()) {
            String newNumber = newVersionTokens.nextToken();
            String currentNumber = currentVersionTokens.nextToken();
            switch (TrustedUpdate.compare(newNumber, currentNumber)) {
                case -1: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
            }
        }
        return newVersionTokens.hasMoreTokens() && !currentVersionTokens.hasMoreTokens();
    }

    private static final int compare(String lop, String rop) {
        try {
            int left = Integer.parseInt(lop);
            int right = Integer.parseInt(rop);
            if (left < right) {
                return -1;
            }
            if (left == right) {
                return 0;
            }
            return 1;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void genKeysCLI(String publicKeyFile, String privateKeyFile) {
        FileOutputStream fileOutputStream = null;
        Object[] signingKeypair = _context.keyGenerator().generateSigningKeypair();
        SigningPublicKey signingPublicKey = (SigningPublicKey)signingKeypair[0];
        SigningPrivateKey signingPrivateKey = (SigningPrivateKey)signingKeypair[1];
        fileOutputStream = new FileOutputStream(publicKeyFile);
        signingPublicKey.writeBytes(fileOutputStream);
        fileOutputStream.close();
        fileOutputStream = null;
        fileOutputStream = new FileOutputStream(privateKeyFile);
        signingPrivateKey.writeBytes(fileOutputStream);
        System.out.println("\r\nPrivate key written to: " + privateKeyFile);
        System.out.println("Public key written to: " + publicKeyFile);
        System.out.println("\r\nPublic key: " + signingPublicKey.toBase64() + "\r\n");
        Object var7_7 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (Exception e) {
                System.err.println("Error writing keys:");
                e.printStackTrace();
                Object var7_8 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static final String sanitize(String versionString) {
        StringBuffer versionStringBuffer = new StringBuffer(versionString);
        for (int i = 0; i < versionStringBuffer.length(); ++i) {
            if (VALID_VERSION_CHARS.indexOf(versionStringBuffer.charAt(i)) != -1) continue;
            versionStringBuffer.deleteCharAt(i);
            --i;
        }
        return versionStringBuffer.toString();
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: TrustedUpdate keygen       publicKeyFile privateKeyFile");
        System.err.println("       TrustedUpdate showversion  signedFile");
        System.err.println("       TrustedUpdate sign         inputFile signedFile privateKeyFile version");
        System.err.println("       TrustedUpdate verifysig    signedFile");
        System.err.println("       TrustedUpdate verifyupdate signedFile");
    }

    private static final void showVersionCLI(String signedFile) {
        String versionString = new TrustedUpdate().getVersionString(signedFile);
        if (versionString == "") {
            System.out.println("No version string found in file '" + signedFile + "'");
        } else {
            System.out.println("Version: " + versionString);
        }
    }

    private static final void signCLI(String inputFile, String signedFile, String privateKeyFile, String version) {
        Signature signature = new TrustedUpdate().sign(inputFile, signedFile, privateKeyFile, version);
        if (signature != null) {
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
        } else {
            System.out.println("Error signing input file '" + inputFile + "'");
        }
    }

    private static final void verifySigCLI(String signedFile) {
        boolean isValidSignature = new TrustedUpdate().verify(signedFile);
        if (isValidSignature) {
            System.out.println("Signature VALID");
        } else {
            System.out.println("Signature INVALID");
        }
    }

    private static final void verifyUpdateCLI(String signedFile) {
        boolean isUpdate = new TrustedUpdate().isUpdatedVersion("0.6.1.30", signedFile);
        if (isUpdate) {
            System.out.println("File version is newer than current version.");
        } else {
            System.out.println("File version is older than or equal to current version.");
        }
    }

    public ArrayList getTrustedKeys() {
        return this._trustedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionString(String signedFile) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        fileInputStream = null;
                        try {
                            try {
                                fileInputStream = new FileInputStream(signedFile);
                                skipped = fileInputStream.skip(40L);
                                if (skipped != 40L) {
                                    var5_6 = "";
                                    var10_8 = null;
                                    if (fileInputStream == null) return var5_6;
                                    break block16;
                                }
                                data = new byte[16];
                                bytesRead = DataHelper.read(fileInputStream, data);
                                if (bytesRead != 16) {
                                    var7_21 = "";
                                    break block17;
                                }
                                for (i = 0; i < 16; ++i) {
                                    if (data[i] != 0) continue;
                                    var8_24 = new String(data, 0, i, "UTF-8");
                                    break block18;
                                }
                                var7_23 = new String(data, "UTF-8");
                                break block19;
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
                            }
                            catch (IOException ioe) {
                                var4_25 = "";
                                var10_12 = null;
                                if (fileInputStream == null) return var4_25;
                                try {
                                    fileInputStream.close();
                                    return var4_25;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                return var4_25;
                            }
                        }
                        catch (Throwable var9_26) {
                            var10_13 = null;
                            if (fileInputStream == null) throw var9_26;
                            try {}
                            catch (IOException ioe) {
                                throw var9_26;
                            }
                            fileInputStream.close();
                            throw var9_26;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [14 : 189->196)] { 
lbl50:
                    // 1 sources

                    fileInputStream.close();
                    return var5_6;
lbl52:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var5_6;
                }
                var10_9 = null;
                if (fileInputStream == null) return var7_21;
                ** try [egrp 2[TRYBLOCK] [14 : 189->196)] { 
lbl59:
                // 1 sources

                fileInputStream.close();
                return var7_21;
lbl61:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return var7_21;
            }
            var10_10 = null;
            if (fileInputStream == null) return var8_24;
            ** try [egrp 2[TRYBLOCK] [14 : 189->196)] { 
lbl68:
            // 1 sources

            fileInputStream.close();
            return var8_24;
lbl70:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var8_24;
        }
        var10_11 = null;
        if (fileInputStream == null) return var7_23;
        try {}
        catch (IOException ioe) {
            // empty catch block
            return var7_23;
        }
        fileInputStream.close();
        return var7_23;
    }

    public boolean isUpdatedVersion(String currentVersion, String signedFile) {
        return TrustedUpdate.needsUpdate(currentVersion, this.getVersionString(signedFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean migrateVerified(String currentVersion, String signedFile, String outputFile) {
        block24: {
            IOException ioe222;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block21: {
                if (!this.isUpdatedVersion(currentVersion, signedFile)) {
                    return false;
                }
                if (!this.verify(signedFile)) {
                    return false;
                }
                fileInputStream = null;
                fileOutputStream = null;
                fileInputStream = new FileInputStream(signedFile);
                fileOutputStream = new FileOutputStream(outputFile);
                for (long skipped = 0L; skipped < 56L; skipped += fileInputStream.skip(56L - skipped)) {
                }
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                Object var11_10 = null;
                if (fileInputStream == null) break block21;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe222) {}
            }
            break block24;
            {
                catch (IOException ioe3) {
                    IOException ioe222;
                    boolean bl = false;
                    Object var11_11 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                IOException ioe222;
                Object var11_12 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Signature sign(String inputFile, String signedFile, String privateKeyFile, String version) {
        FileInputStream fileInputStream = null;
        SigningPrivateKey signingPrivateKey = new SigningPrivateKey();
        fileInputStream = new FileInputStream(privateKeyFile);
        signingPrivateKey.readBytes(fileInputStream);
        Object var10_7 = null;
        if (fileInputStream == null) return this.sign(inputFile, signedFile, signingPrivateKey, version);
        try {
            fileInputStream.close();
            return this.sign(inputFile, signedFile, signingPrivateKey, version);
        }
        catch (IOException ioe2) {}
        return this.sign(inputFile, signedFile, signingPrivateKey, version);
        {
            catch (IOException ioe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to load the signing key", ioe);
                }
                Signature signature = null;
                Object var10_8 = null;
                if (fileInputStream == null) return signature;
                try {
                    fileInputStream.close();
                    return signature;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return signature;
            }
            catch (DataFormatException dfe) {
                Signature signature;
                try {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to load the signing key", dfe);
                    }
                    signature = null;
                    Object var10_9 = null;
                    if (fileInputStream == null) return signature;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                    return signature;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return signature;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Signature sign(String inputFile, String signedFile, SigningPrivateKey signingPrivateKey, String version) {
        Signature signature;
        block38: {
            IOException ioe322;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block35: {
                byte[] versionHeader;
                block33: {
                    versionHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    byte[] versionRawBytes = null;
                    if (version.length() > 16) {
                        version = version.substring(0, 16);
                    }
                    try {
                        versionRawBytes = version.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + e.getMessage());
                    }
                    System.arraycopy(versionRawBytes, 0, versionHeader, 0, versionRawBytes.length);
                    fileInputStream = null;
                    signature = null;
                    SequenceInputStream bytesToSignInputStream = null;
                    ByteArrayInputStream versionHeaderInputStream = null;
                    fileInputStream = new FileInputStream(inputFile);
                    versionHeaderInputStream = new ByteArrayInputStream(versionHeader);
                    bytesToSignInputStream = new SequenceInputStream(versionHeaderInputStream, fileInputStream);
                    signature = _context.dsa().sign(bytesToSignInputStream, signingPrivateKey);
                    Object var14_12 = null;
                    if (bytesToSignInputStream == null) break block33;
                    try {
                        bytesToSignInputStream.close();
                        break block33;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    {
                        break block33;
                        catch (Exception e) {
                            if (this._log.shouldLog(40)) {
                                this._log.error("Error signing", e);
                            }
                            Signature signature2 = null;
                            Object var14_13 = null;
                            if (bytesToSignInputStream != null) {
                                try {
                                    bytesToSignInputStream.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                            }
                            fileInputStream = null;
                            return signature2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        if (bytesToSignInputStream != null) {
                            try {
                                bytesToSignInputStream.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        fileInputStream = null;
                        throw throwable;
                    }
                }
                fileInputStream = null;
                fileOutputStream = null;
                fileOutputStream = new FileOutputStream(signedFile);
                fileOutputStream.write(signature.getData());
                fileOutputStream.write(versionHeader);
                fileInputStream = new FileInputStream(inputFile);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                fileOutputStream.close();
                Object var17_26 = null;
                if (fileInputStream == null) break block35;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe322) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe322) {}
            }
            break block38;
            {
                catch (IOException ioe4) {
                    IOException ioe322;
                    if (this._log.shouldLog(30)) {
                        this._log.log(30, "Error writing signed file " + signedFile, ioe4);
                    }
                    Signature signature3 = null;
                    Object var17_27 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    return signature3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe322;
                Object var17_28 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return signature;
    }

    public boolean verify(String signedFile) {
        for (int i = 0; i < this._trustedKeys.size(); ++i) {
            SigningPublicKey signingPublicKey = new SigningPublicKey();
            try {
                signingPublicKey.fromBase64((String)this._trustedKeys.get(i));
                boolean isValidSignature = this.verify(signedFile, signingPublicKey);
                if (!isValidSignature) continue;
                return true;
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Trusted key " + i + " is not valid");
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("None of the keys match");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String signedFile, String publicKeyFile) {
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(signedFile);
        signingPublicKey.readBytes(fileInputStream);
        Object var8_5 = null;
        if (fileInputStream == null) return this.verify(signedFile, signingPublicKey);
        try {
            fileInputStream.close();
            return this.verify(signedFile, signingPublicKey);
        }
        catch (IOException ioe2) {}
        return this.verify(signedFile, signingPublicKey);
        {
            catch (IOException ioe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to load the signature", ioe);
                }
                boolean bl = false;
                Object var8_6 = null;
                if (fileInputStream == null) return bl;
                try {
                    fileInputStream.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
            catch (DataFormatException dfe) {
                boolean bl;
                try {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to load the signature", dfe);
                    }
                    bl = false;
                    Object var8_7 = null;
                    if (fileInputStream == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean verify(String signedFile, SigningPublicKey signingPublicKey) {
        boolean bl;
        FileInputStream fileInputStream;
        block13: {
            fileInputStream = null;
            fileInputStream = new FileInputStream(signedFile);
            Signature signature = new Signature();
            signature.readBytes(fileInputStream);
            bl = _context.dsa().verifySignature(signature, fileInputStream, signingPublicKey);
            Object var7_10 = null;
            if (fileInputStream == null) break block13;
            try {
                fileInputStream.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        return bl;
        catch (IOException ioe) {
            boolean bl2;
            block14: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error reading " + signedFile + " to verify", ioe);
                }
                bl2 = false;
                Object var7_11 = null;
                if (fileInputStream == null) break block14;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl2;
        }
        catch (DataFormatException dfe) {
            boolean bl3;
            block15: {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error reading the signature", dfe);
                }
                bl3 = false;
                Object var7_12 = null;
                if (fileInputStream == null) break block15;
                {
                    catch (Throwable throwable) {
                        block16: {
                            Object var7_13 = null;
                            if (fileInputStream == null) break block16;
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException ioe2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl3;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

