/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.util.PooledRandomSource;
import net.i2p.util.RandomSource;

public class DummyPooledRandomSource
extends PooledRandomSource {
    public DummyPooledRandomSource(I2PAppContext context) {
        super(context);
    }

    protected void initializePool(I2PAppContext context) {
        this._pool = new RandomSource[16];
        for (int i = 0; i < 16; ++i) {
            this._pool[i] = new DummyRandomSource(context);
            this._pool[i].nextBoolean();
        }
        this._nextPool = 0;
    }

    private class DummyRandomSource
    extends RandomSource {
        private Random _prng = new Random();

        public DummyRandomSource(I2PAppContext context) {
            super(context);
        }

        public int nextInt(int n) {
            if (n == 0) {
                return 0;
            }
            int val = this._prng.nextInt(n);
            if (val < 0) {
                val = 0 - val;
            }
            if (val >= n) {
                val %= n;
            }
            return val;
        }

        public long nextLong(long n) {
            long v = this._prng.nextLong();
            if (v < 0L) {
                v = 0L - v;
            }
            if (v >= n) {
                v %= n;
            }
            return v;
        }

        public boolean nextBoolean() {
            return this._prng.nextBoolean();
        }

        public void nextBytes(byte[] buf) {
            this._prng.nextBytes(buf);
        }

        public double nextDouble() {
            return this._prng.nextDouble();
        }

        public float nextFloat() {
            return this._prng.nextFloat();
        }

        public double nextGaussian() {
            return this._prng.nextGaussian();
        }

        public int nextInt() {
            return this._prng.nextInt();
        }

        public long nextLong() {
            return this._prng.nextLong();
        }
    }
}

