/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class HostsTxtNamingService
extends NamingService {
    public static final String PROP_HOSTS_FILE = "i2p.hostsfilelist";
    public static final String DEFAULT_HOSTS_FILE = "privatehosts.txt,userhosts.txt,hosts.txt";
    private static final Log _log = new Log(class$net$i2p$client$naming$HostsTxtNamingService == null ? (class$net$i2p$client$naming$HostsTxtNamingService = HostsTxtNamingService.class$("net.i2p.client.naming.HostsTxtNamingService")) : class$net$i2p$client$naming$HostsTxtNamingService);
    static /* synthetic */ Class class$net$i2p$client$naming$HostsTxtNamingService;

    public HostsTxtNamingService(I2PAppContext context) {
        super(context);
    }

    private HostsTxtNamingService() {
        super(null);
    }

    private List getFilenames() {
        String list = this._context.getProperty(PROP_HOSTS_FILE, DEFAULT_HOSTS_FILE);
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    public Destination lookup(String hostname) {
        List filenames = this.getFilenames();
        for (int i = 0; i < filenames.size(); ++i) {
            String hostsfile = (String)filenames.get(i);
            Properties hosts = new Properties();
            try {
                File f = new File(hostsfile);
                if (f.exists() && f.canRead()) {
                    DataHelper.loadProps(hosts, f, true);
                    String key = hosts.getProperty(hostname.toLowerCase());
                    if (key == null || key.trim().length() <= 0) continue;
                    return this.lookupBase64(key);
                }
                _log.warn("Hosts file " + hostsfile + " does not exist.");
                continue;
            }
            catch (Exception ioe) {
                _log.error("Error loading hosts file " + hostsfile, ioe);
            }
        }
        return this.lookupBase64(hostname);
    }

    public String reverseLookup(Destination dest) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

