/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.i2p.client.I2PSession;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;

public final class I2PDatagramMaker {
    private static Log _log = new Log(class$net$i2p$client$datagram$I2PDatagramMaker == null ? (class$net$i2p$client$datagram$I2PDatagramMaker = I2PDatagramMaker.class$("net.i2p.client.datagram.I2PDatagramMaker")) : class$net$i2p$client$datagram$I2PDatagramMaker);
    private static int DGRAM_BUFSIZE = 32768;
    private SHA256Generator hashGen = SHA256Generator.getInstance();
    private DSAEngine dsaEng = DSAEngine.getInstance();
    private SigningPrivateKey sxPrivKey = null;
    private byte[] sxDestBytes = null;
    private ByteArrayOutputStream sxDGram = new ByteArrayOutputStream(DGRAM_BUFSIZE);
    static /* synthetic */ Class class$net$i2p$client$datagram$I2PDatagramMaker;

    public I2PDatagramMaker(I2PSession session) {
        this.sxPrivKey = session.getPrivateKey();
        this.sxDestBytes = session.getMyDestination().toByteArray();
    }

    public byte[] makeI2PDatagram(byte[] payload) {
        this.sxDGram.reset();
        try {
            this.sxDGram.write(this.sxDestBytes);
            this.dsaEng.sign(this.hashGen.calculateHash(payload).toByteArray(), this.sxPrivKey).writeBytes(this.sxDGram);
            this.sxDGram.write(payload);
            return this.sxDGram.toByteArray();
        }
        catch (IOException e) {
            _log.error("Caught IOException", e);
            return null;
        }
        catch (DataFormatException e) {
            _log.error("Caught DataFormatException", e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

