/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Signature;
import net.i2p.util.Log;

public final class I2PDatagramDissector {
    private static Log _log = new Log(class$net$i2p$client$datagram$I2PDatagramDissector == null ? (class$net$i2p$client$datagram$I2PDatagramDissector = I2PDatagramDissector.class$("net.i2p.client.datagram.I2PDatagramDissector")) : class$net$i2p$client$datagram$I2PDatagramDissector);
    private static int DGRAM_BUFSIZE = 32768;
    private DSAEngine dsaEng = DSAEngine.getInstance();
    private SHA256Generator hashGen = SHA256Generator.getInstance();
    private byte[] rxHashBytes = null;
    private Signature rxSign = new Signature();
    private Destination rxDest = new Destination();
    private byte[] rxPayload = new byte[DGRAM_BUFSIZE];
    private int rxPayloadLen = 0;
    static /* synthetic */ Class class$net$i2p$client$datagram$I2PDatagramDissector;

    public void loadI2PDatagram(byte[] dgram) throws DataFormatException {
        ByteArrayInputStream dgStream = new ByteArrayInputStream(dgram);
        try {
            this.rxDest.readBytes(dgStream);
            this.rxSign.readBytes(dgStream);
            this.rxPayloadLen = dgStream.read(this.rxPayload);
            byte[] rxTrimmedPayload = new byte[this.rxPayloadLen];
            System.arraycopy(this.rxPayload, 0, rxTrimmedPayload, 0, this.rxPayloadLen);
            this.rxHashBytes = this.hashGen.calculateHash(rxTrimmedPayload).toByteArray();
        }
        catch (IOException e) {
            _log.error("Caught IOException - INCONSISTENT STATE!", e);
        }
    }

    public byte[] getPayload() throws I2PInvalidDatagramException {
        if (!this.dsaEng.verifySignature(this.rxSign, this.rxHashBytes, this.rxDest.getSigningPublicKey())) {
            throw new I2PInvalidDatagramException("Incorrect I2P repliable datagram signature");
        }
        byte[] retPayload = new byte[this.rxPayloadLen];
        System.arraycopy(this.rxPayload, 0, retPayload, 0, this.rxPayloadLen);
        return retPayload;
    }

    public Destination getSender() throws I2PInvalidDatagramException {
        if (!this.dsaEng.verifySignature(this.rxSign, this.rxHashBytes, this.rxDest.getSigningPublicKey())) {
            throw new I2PInvalidDatagramException("Incorrect I2P repliable datagram signature");
        }
        Destination retDest = new Destination();
        try {
            retDest.fromByteArray(this.rxDest.toByteArray());
        }
        catch (DataFormatException e) {
            _log.error("Caught DataFormatException", e);
            return null;
        }
        return retDest;
    }

    public byte[] extractPayload() {
        byte[] retPayload = new byte[this.rxPayloadLen];
        System.arraycopy(this.rxPayload, 0, retPayload, 0, this.rxPayloadLen);
        return retPayload;
    }

    public Destination extractSender() {
        Destination retDest = new Destination();
        try {
            retDest.fromByteArray(this.rxDest.toByteArray());
        }
        catch (DataFormatException e) {
            _log.error("Caught DataFormatException", e);
            return null;
        }
        return retDest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

