/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class ATalk
implements I2PSessionListener,
Runnable {
    private static final Log _log = new Log(class$net$i2p$client$ATalk == null ? (class$net$i2p$client$ATalk = ATalk.class$("net.i2p.client.ATalk")) : class$net$i2p$client$ATalk);
    private static final String NL = System.getProperty("line.separator");
    private I2PSession _session;
    private Destination _myDestination;
    private Destination _peerDestination;
    private String _myKeyFile;
    private String _theirDestinationFile;
    private BufferedReader _in;
    private BufferedWriter _out;
    private static final String FILE_COMMAND = ".file: ";
    private static final String MANUAL = "ATalk: Anonymous Talk, a demo program for the Invisible Internet Project SDK" + NL + "To generate a new destination:" + NL + "\tATalk [fileToSavePrivateKeyIn] [fileToSavePublicKeyIn]" + NL + "To talk to another destination:" + NL + "\tATalk [myPrivateKeyFile] [peerPublicKey] [shouldLogToScreen]" + NL + "shouldLogToScreen is 'true' or 'false', depending on whether you want log info on the screen" + NL + "When talking to another destination, messages are sent after you hit return" + NL + "To send a file, send a message saying:" + NL + "\t" + ".file: " + "[filenameToSend]" + NL + "The peer will then recieve the file and be notified of where it has been saved" + NL + "To end the talk session, enter a period on a line by itself and hit return" + NL;
    public static final String PROP_CONFIG_LOCATION = "configFile";
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("hh:mm:ss.SSS");
    static /* synthetic */ Class class$net$i2p$client$ATalk;

    public ATalk(String myKeyFile, String theirDestFile) {
        this._myKeyFile = myKeyFile;
        this._theirDestinationFile = theirDestFile;
    }

    public void connect() throws IOException, I2PSessionException, DataFormatException {
        I2PClient client = I2PClientFactory.createClient();
        File myFile = new File(this._myKeyFile);
        Properties props = new Properties();
        String configLocation = System.getProperty(PROP_CONFIG_LOCATION, "atalk.config");
        try {
            props.load(new FileInputStream(configLocation));
        }
        catch (FileNotFoundException fnfe) {
            _log.warn("Unable to load up the ATalk config file " + configLocation);
        }
        if (!props.containsKey("i2cp.tcp.host")) {
            props.setProperty("i2cp.tcp.host", "localhost");
        }
        if (!props.containsKey("i2cp.tcp.port")) {
            props.setProperty("i2cp.tcp.port", "7654");
        }
        if (!props.containsKey("i2cp.messageReliability")) {
            props.setProperty("i2cp.messageReliability", "BestEffort");
        }
        this._session = client.createSession(new FileInputStream(myFile), props);
        this._session.setSessionListener(this);
        this._session.connect();
        File peerDestFile = new File(this._theirDestinationFile);
        this._peerDestination = new Destination();
        this._peerDestination.readBytes(new FileInputStream(peerDestFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block42: {
            this.connect();
            this._in = new BufferedReader(new InputStreamReader(System.in));
            this._out = new BufferedWriter(new OutputStreamWriter(System.out));
            this._out.write("Starting up anonymous talk session" + NL);
            while (true) {
                String line;
                if ((line = this._in.readLine()) == null || line.trim().length() <= 0) continue;
                if (".".equals(line)) break;
                if (line.startsWith(FILE_COMMAND) && line.trim().length() > FILE_COMMAND.length()) {
                    try {
                        String file = line.substring(FILE_COMMAND.length());
                        boolean sent = this.sendFile(file);
                        if (sent) continue;
                        this._out.write("Failed sending the file: " + file + NL);
                    }
                    catch (IOException ioe) {
                        this._out.write("Error sending the file: " + ioe.getMessage() + NL);
                        _log.error("Error sending the file", ioe);
                    }
                    continue;
                }
                boolean ok = this._session.sendMessage(this._peerDestination, ("[" + this.now() + "] " + line).getBytes());
                if (ok) continue;
                this._out.write("Failed sending message.  Peer disconnected?" + NL);
            }
            boolean ok = this._session.sendMessage(this._peerDestination, ("Peer disconnected at " + this.now()).getBytes());
            Object var5_11 = null;
            try {
                _log.debug("Exiting anonymous talk session");
                if (this._out != null) {
                    this._out.write("Exiting anonymous talk session");
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            if (this._session != null) {
                try {
                    this._session.destroySession();
                }
                catch (I2PSessionException ise2) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {}
            break block42;
            {
                catch (IOException ioe) {
                    _log.error("Error running", ioe);
                    Object var5_12 = null;
                    try {
                        _log.debug("Exiting anonymous talk session");
                        if (this._out != null) {
                            this._out.write("Exiting anonymous talk session");
                        }
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    if (this._session != null) {
                        try {
                            this._session.destroySession();
                        }
                        catch (I2PSessionException ise2) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {}
                    break block42;
                }
                catch (I2PSessionException ise) {
                    _log.error("Error communicating", ise);
                    Object var5_13 = null;
                    try {
                        _log.debug("Exiting anonymous talk session");
                        if (this._out != null) {
                            this._out.write("Exiting anonymous talk session");
                        }
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    if (this._session != null) {
                        try {
                            this._session.destroySession();
                        }
                        catch (I2PSessionException ise2) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {}
                    break block42;
                }
                catch (DataFormatException dfe) {
                    _log.error("Peer destination file is not valid", dfe);
                    Object var5_14 = null;
                    try {
                        _log.debug("Exiting anonymous talk session");
                        if (this._out != null) {
                            this._out.write("Exiting anonymous talk session");
                        }
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    if (this._session != null) {
                        try {
                            this._session.destroySession();
                        }
                        catch (I2PSessionException ise2) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_15 = null;
                try {
                    _log.debug("Exiting anonymous talk session");
                    if (this._out != null) {
                        this._out.write("Exiting anonymous talk session");
                    }
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                if (this._session != null) {
                    try {
                        this._session.destroySession();
                    }
                    catch (I2PSessionException ise2) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private String now() {
        Date now = new Date(Clock.getInstance().now());
        return _fmt.format(now);
    }

    private boolean sendFile(String filename) throws IOException, I2PSessionException {
        _log.debug("Sending file [" + filename + "]");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        baos.write((FILE_COMMAND + filename + "\n").getBytes());
        FileInputStream fin = new FileInputStream(filename);
        byte[] buf = new byte[4096];
        try {
            int len;
            while ((len = fin.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
        }
        catch (IOException ioe) {
            _log.debug("Failed reading the file", ioe);
            return false;
        }
        baos.close();
        byte[] val = baos.toByteArray();
        _log.debug("Sending " + filename + " with a full payload of " + val.length);
        try {
            boolean rv = this._session.sendMessage(this._peerDestination, val);
            _log.debug("Sending " + filename + " complete: rv = " + rv);
            return rv;
        }
        catch (Throwable t) {
            _log.error("Error sending file", t);
            return false;
        }
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        _log.debug("Message available: id = " + msgId + " size = " + size);
        try {
            byte[] msg = session.receiveMessage(msgId);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(msg)));
            String line = reader.readLine();
            if (line.startsWith(FILE_COMMAND)) {
                this.handleRecieveFile(line, msg);
            } else {
                this._out.write(this.now() + " --> " + new String(msg));
                this._out.write(NL);
                this._out.flush();
            }
        }
        catch (I2PSessionException ise) {
            _log.error("Error fetching available message", ise);
        }
        catch (IOException ioe) {
            _log.error("Error writing out the message", ioe);
        }
    }

    private void handleRecieveFile(String firstline, byte[] msg) throws IOException {
        _log.debug("handleRecieveFile called");
        File f = File.createTempFile("recieve", ".dat", new File("."));
        FileOutputStream fos = new FileOutputStream(f);
        int lineLen = firstline.getBytes().length + "\n".getBytes().length;
        int lenToCopy = msg.length - lineLen;
        byte[] buf = new byte[lenToCopy];
        System.arraycopy(msg, lineLen, buf, 0, lenToCopy);
        fos.write(buf);
        fos.close();
        String name = firstline.substring(FILE_COMMAND.length());
        this._out.write("Recieved a file called [" + name + "] of size [" + lenToCopy + "] bytes, saved as [" + f.getAbsolutePath() + "]" + NL);
        this._out.flush();
    }

    public static void main(String[] args) {
        I2PAppContext context = new I2PAppContext();
        if (args.length == 2) {
            String myKeyFile = args[0];
            String myDestinationFile = args[1];
            boolean success = ATalk.generateKeys(myKeyFile, myDestinationFile);
            if (success) {
                _log.debug("Keys generated (private key file: " + myKeyFile + " destination file: " + myDestinationFile + ")");
            } else {
                _log.debug("Keys generation failed");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {}
        } else if (args.length == 3) {
            _log.debug("Starting chat");
            String myKeyfile = args[0];
            String peerDestFile = args[1];
            String shouldLog = args[2];
            if (Boolean.TRUE.toString().equalsIgnoreCase(shouldLog)) {
                context.logManager().setDisplayOnScreen(true);
            } else {
                context.logManager().setDisplayOnScreen(false);
            }
            String logFile = args[2];
            I2PThread talkThread = new I2PThread(new ATalk(myKeyfile, peerDestFile));
            talkThread.start();
        } else {
            System.out.println(MANUAL);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    private static boolean generateKeys(String privKeyFile, String destinationFile) {
        try {
            Destination d = I2PClientFactory.createClient().createDestination(new FileOutputStream(privKeyFile));
            FileOutputStream fos = new FileOutputStream(destinationFile);
            d.writeBytes(fos);
            fos.flush();
            fos.close();
            return true;
        }
        catch (IOException ioe) {
            _log.error("Error generating keys", ioe);
        }
        catch (I2PException ipe) {
            _log.error("Error generating keys", ipe);
        }
        return false;
    }

    public void disconnected(I2PSession session) {
        _log.debug("Disconnected");
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        _log.debug("Error occurred: " + message, error);
    }

    public void reportAbuse(I2PSession session, int severity) {
        _log.debug("Abuse reported of severity " + severity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

