/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class StreamSinkServer {
    private Log _log;
    private String _sinkDir;
    private String _destFile;
    private String _i2cpHost;
    private int _i2cpPort;
    private int _handlers;
    static /* synthetic */ Class class$net$i2p$client$streaming$StreamSinkServer;

    public StreamSinkServer(String sinkDir, String ourDestFile) {
        this(sinkDir, ourDestFile, null, -1, 3);
    }

    public StreamSinkServer(String sinkDir, String ourDestFile, String i2cpHost, int i2cpPort, int handlers) {
        this._sinkDir = sinkDir;
        this._destFile = ourDestFile;
        this._i2cpHost = i2cpHost;
        this._i2cpPort = i2cpPort;
        this._handlers = handlers;
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(class$net$i2p$client$streaming$StreamSinkServer == null ? (class$net$i2p$client$streaming$StreamSinkServer = StreamSinkServer.class$("net.i2p.client.streaming.StreamSinkServer")) : class$net$i2p$client$streaming$StreamSinkServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runServer() {
        block15: {
            mgr = null;
            mgr = this._i2cpHost != null ? I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, new Properties()) : I2PSocketManagerFactory.createManager();
            dest = mgr.getSession().getMyDestination();
            if (this._log.shouldLog(20)) {
                this._log.info("Listening for connections on: " + dest.calculateHash().toBase64());
            }
            fos = null;
            try {
                fos = new FileOutputStream(this._destFile);
                dest.writeBytes((OutputStream)fos);
                var6_4 = null;
                ** if (fos == null) goto lbl-1000
            }
            catch (Throwable var5_15) {
                var6_7 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw var5_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (IOException ioe) {
                    this._log.error("Error writing out our destination to " + this._destFile, (Throwable)ioe);
                    var6_5 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (DataFormatException dfe) {
                    this._log.error("Error formatting the destination", (Throwable)dfe);
                    var6_6 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        sock = mgr.getServerSocket();
        this.startup(sock);
    }

    public void startup(I2PServerSocket sock) {
        for (int i = 0; i < this._handlers; ++i) {
            I2PThread t = new I2PThread((Runnable)new ClientRunner(sock));
            t.setName("Handler " + i);
            t.setDaemon(false);
            t.start();
        }
    }

    public static void main(String[] args) {
        StreamSinkServer server = null;
        switch (args.length) {
            case 0: {
                server = new StreamSinkServer("dataDir", "server.key", "localhost", 7654, 3);
                break;
            }
            case 2: {
                server = new StreamSinkServer(args[0], args[1]);
                break;
            }
            case 4: 
            case 5: {
                int handlers = 3;
                if (args.length == 5) {
                    try {
                        handlers = Integer.parseInt(args[4]);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                try {
                    int port = Integer.parseInt(args[1]);
                    server = new StreamSinkServer(args[2], args[3], args[0], port, handlers);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Usage: StreamSinkServer [i2cpHost i2cpPort] sinkDir ourDestFile [handlers]");
                }
                break;
            }
            default: {
                System.out.println("Usage: StreamSinkServer [i2cpHost i2cpPort] sinkDir ourDestFile [handlers]");
            }
        }
        if (server != null) {
            server.runServer();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClientRunner
    implements Runnable {
        private I2PServerSocket _socket;

        public ClientRunner(I2PServerSocket socket) {
            this._socket = socket;
        }

        public void run() {
            try {
                while (true) {
                    I2PSocket socket;
                    if ((socket = this._socket.accept()) == null) {
                        continue;
                    }
                    this.handle(socket);
                }
            }
            catch (I2PException ie) {
                StreamSinkServer.this._log.error("Error accepting connection", (Throwable)ie);
                return;
            }
            catch (ConnectException ce) {
                StreamSinkServer.this._log.error("Connection already dropped", (Throwable)ce);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void handle(I2PSocket sock) {
            block24: {
                IOException ioe322;
                FileOutputStream fos;
                block22: {
                    fos = null;
                    try {
                        File sink = new File(StreamSinkServer.this._sinkDir);
                        if (!sink.exists()) {
                            sink.mkdirs();
                        }
                        File cur = File.createTempFile("clientSink", ".dat", sink);
                        fos = new FileOutputStream(cur);
                        if (StreamSinkServer.this._log.shouldLog(10)) {
                            StreamSinkServer.this._log.debug("Writing to " + cur.getAbsolutePath());
                        }
                    }
                    catch (IOException ioe2) {
                        StreamSinkServer.this._log.error("Error creating sink", (Throwable)ioe2);
                        return;
                    }
                    long start = System.currentTimeMillis();
                    InputStream in = sock.getInputStream();
                    byte[] buf = new byte[4096];
                    long written = 0L;
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                        written += (long)read;
                        if (!StreamSinkServer.this._log.shouldLog(10)) continue;
                        StreamSinkServer.this._log.debug("read and wrote " + read + " (" + written + ")");
                    }
                    fos.write(("written: [" + written + "]\n").getBytes());
                    long lifetime = System.currentTimeMillis() - start;
                    StreamSinkServer.this._log.info("Got EOF from client socket [written=" + written + " lifetime=" + lifetime + "]");
                    Object var13_13 = null;
                    if (fos == null) break block22;
                    try {
                        fos.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                StreamSinkServer.this._log.debug("Client socket closed");
                {
                    break block24;
                    catch (IOException ioe4) {
                        IOException ioe322;
                        StreamSinkServer.this._log.error("Error writing the sink", (Throwable)ioe4);
                        Object var13_14 = null;
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException ioe322) {
                                // empty catch block
                            }
                        }
                        if (sock != null) {
                            try {
                                sock.close();
                            }
                            catch (IOException ioe322) {
                                // empty catch block
                            }
                        }
                        StreamSinkServer.this._log.debug("Client socket closed");
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe322;
                    Object var13_15 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    StreamSinkServer.this._log.debug("Client socket closed");
                    throw throwable;
                }
            }
        }
    }
}

