/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class StreamSinkSend {
    private Log _log;
    private String _sendFile;
    private int _writeDelay;
    private String _peerDestFile;
    static /* synthetic */ Class class$net$i2p$client$streaming$StreamSinkClient;

    public StreamSinkSend(String filename, int writeDelayMs, String serverDestFile) {
        this._sendFile = filename;
        this._writeDelay = writeDelayMs;
        this._peerDestFile = serverDestFile;
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(class$net$i2p$client$streaming$StreamSinkClient == null ? (class$net$i2p$client$streaming$StreamSinkClient = StreamSinkSend.class$("net.i2p.client.streaming.StreamSinkClient")) : class$net$i2p$client$streaming$StreamSinkClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runClient() {
        block24: {
            mgr = I2PSocketManagerFactory.createManager();
            peer = null;
            fis = null;
            try {
                fis = new FileInputStream(this._peerDestFile);
                peer = new Destination();
                peer.readBytes((InputStream)fis);
                var6_4 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var5_21) {
                var6_7 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw var5_21;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
lbl-1000:
            // 2 sources

            {
                break block24;
                catch (IOException ioe) {
                    this._log.error("Error finding the peer destination to contact in " + this._peerDestFile, (Throwable)ioe);
                    var6_5 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (DataFormatException dfe) {
                    this._log.error("Peer destination is not valid in " + this._peerDestFile, (Throwable)dfe);
                    var6_6 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    return;
                }
            }
        }
        System.out.println("Send " + this._sendFile + " to " + peer.calculateHash().toBase64());
        try {
            sock = mgr.connect(peer);
            buf = new byte[32768];
            out = sock.getOutputStream();
            beforeSending = System.currentTimeMillis();
            fis = new FileInputStream(this._sendFile);
            size = 0L;
            while ((read = fis.read(buf)) >= 0) {
                out.write(buf, 0, read);
                size += (long)read;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Wrote " + read);
                }
                if (this._writeDelay <= 0) continue;
                try {
                    Thread.sleep(this._writeDelay);
                }
                catch (InterruptedException ie) {}
            }
            fis.close();
            sock.close();
            afterSending = System.currentTimeMillis();
            System.out.println("Sent " + size / 1024L + "KB in " + (afterSending - beforeSending) + "ms");
        }
        catch (InterruptedIOException iie) {
            this._log.error("Timeout connecting to the peer", (Throwable)iie);
            return;
        }
        catch (NoRouteToHostException nrthe) {
            this._log.error("Unable to connect to the peer", (Throwable)nrthe);
            return;
        }
        catch (ConnectException ce) {
            this._log.error("Connection already dropped", (Throwable)ce);
            return;
        }
        catch (I2PException ie) {
            this._log.error("Error connecting to the peer", (Throwable)ie);
            return;
        }
        catch (IOException ioe) {
            this._log.error("IO error sending", (Throwable)ioe);
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: StreamSinkClient sendFile writeDelayMs serverDestFile");
        } else {
            int writeDelayMs = -1;
            try {
                writeDelayMs = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Write delay ms invalid [" + args[1] + "]");
                return;
            }
            StreamSinkSend client = new StreamSinkSend(args[0], writeDelayMs, args[2]);
            client.runClient();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

