/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.share;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.parser.share.AlternateLocationHandler;
import phex.xml.sax.share.DAlternateLocation;
import phex.xml.sax.share.DSharedFile;

public class SharedFileHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "SF";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DSharedFile dFile;
    private DefaultHandler parent;

    public SharedFileHandler(DSharedFile dFile, DefaultHandler parent, SAXParser parser) {
        this.dFile = dFile;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("AltLoc")) {
            DAlternateLocation altloc = new DAlternateLocation();
            this.dFile.getAltLocList().add(altloc);
            AlternateLocationHandler handler = new AlternateLocationHandler(altloc, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("FID")) {
            this.dFile.setFileName(this.text.toString());
        } else if (qName.equals("SHA1")) {
            this.dFile.setSha1(this.text.toString());
        } else if (qName.equals("TxRH")) {
            this.dFile.setThexRootHash(this.text.toString());
        } else if (qName.equals("TxD")) {
            try {
                this.dFile.setThexTreeDepth(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("TxLLN")) {
            this.dFile.setThexLowestLevelNodes(this.text.toString());
        } else if (qName.equals("CT")) {
            try {
                this.dFile.setCreationTime(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("LM")) {
            try {
                this.dFile.setLastModified(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("LS")) {
            try {
                this.dFile.setLastSeen(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("HC")) {
            try {
                this.dFile.setHitCount(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("UC")) {
            try {
                this.dFile.setUploadCount(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(SharedFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

