/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.file.ManagedFileInputStream;
import phex.common.file.ManagedFileOutputStream;
import phex.common.log.NLogger;
import phex.utils.IOUtil;
import phex.xml.sax.DPhex;
import phex.xml.sax.PhexXmlSaxParser;
import phex.xml.sax.PhexXmlSaxWriter;
import phex.xml.sax.parser.UnicodeInputStream;

public class XMLBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DPhex loadDPhexFromFile(ManagedFile managedFile) throws IOException, ManagedFileException {
        DPhex dPhex;
        if (!managedFile.exists()) {
            return null;
        }
        NLogger.debug(XMLBuilder.class, (Object)("Loading DPhex from: " + managedFile));
        ManagedFileInputStream inStream = null;
        try {
            managedFile.acquireFileLock();
            inStream = new ManagedFileInputStream(managedFile, 0L);
            dPhex = XMLBuilder.readDPhexFromStream(inStream);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(inStream);
            IOUtil.closeQuietly(managedFile);
            managedFile.releaseFileLock();
            throw throwable;
        }
        IOUtil.closeQuietly(inStream);
        IOUtil.closeQuietly(managedFile);
        managedFile.releaseFileLock();
        return dPhex;
    }

    public static DPhex readDPhexFromStream(InputStream inStream) throws IOException {
        UnicodeInputStream ucInStream = new UnicodeInputStream(inStream, "UTF-8");
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("Thread interrupted.");
        }
        try {
            ucInStream.getEncoding();
        }
        catch (IllegalStateException exp) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("Thread interrupted.");
            }
            NLogger.error(XMLBuilder.class, (Object)exp, (Throwable)exp);
        }
        DPhex phex = PhexXmlSaxParser.parsePhexXml(ucInStream);
        return phex;
    }

    public static byte[] serializeToBytes(DPhex dPhex) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PhexXmlSaxWriter.serializePhexXml(bos, dPhex);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(ManagedFile managedFile, DPhex dPhex) throws IOException, ManagedFileException {
        ManagedFileOutputStream outStream = null;
        try {
            managedFile.acquireFileLock();
            managedFile.setLength(0L);
            outStream = new ManagedFileOutputStream(managedFile, 0L);
            PhexXmlSaxWriter.serializePhexXml(outStream, dPhex);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(outStream);
            IOUtil.closeQuietly(managedFile);
            managedFile.releaseFileLock();
            throw throwable;
        }
        IOUtil.closeQuietly(outStream);
        IOUtil.closeQuietly(managedFile);
        managedFile.releaseFileLock();
    }
}

