/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.HashMap;
import phex.common.log.NLogger;

public class ReadWriteLock {
    private static final long MAX_WAIT_TIME = 120000L;
    private Thread writeLockOwner;
    private Integer writeLockerHadReadLockCount = null;
    private HashMap readLockOwners = new HashMap(10);

    public synchronized void readLock() {
        Thread currentThread = Thread.currentThread();
        if (this.writeLockOwner == currentThread) {
            return;
        }
        Integer readLockCount = (Integer)this.readLockOwners.get(currentThread);
        if (readLockCount != null) {
            this.readLockOwners.put(currentThread, readLockCount + 1);
            return;
        }
        boolean wasInterrupted = false;
        while (this.writeLockOwner != null) {
            try {
                long startTime = System.currentTimeMillis();
                this.wait(120000L);
                long stopTime = System.currentTimeMillis();
                if (stopTime < startTime + 120000L) continue;
                this.throwWaitedTooLongError();
            }
            catch (InterruptedException exp) {
                wasInterrupted = true;
            }
        }
        this.readLockOwners.put(currentThread, 1);
        if (wasInterrupted) {
            currentThread.interrupt();
        }
    }

    public synchronized void readUnlock() throws IllegalAccessException {
        Thread currentThread = Thread.currentThread();
        if (this.writeLockOwner == currentThread) {
            return;
        }
        Integer readLockCount = (Integer)this.readLockOwners.remove(currentThread);
        if (readLockCount == null) {
            throw new IllegalAccessException("Thread without holding read lock trys to unlock.");
        }
        int newCount = readLockCount - 1;
        if (newCount > 0) {
            this.readLockOwners.put(currentThread, newCount);
        } else if (this.readLockOwners.size() == 0) {
            this.notifyAll();
        }
    }

    public synchronized void writeLock() {
        Integer readLockCount;
        Thread currentThread = Thread.currentThread();
        if (this.writeLockOwner == currentThread) {
            return;
        }
        boolean wasInterrupted = false;
        while (this.writeLockOwner != null) {
            try {
                long startTime = System.currentTimeMillis();
                this.wait(120000L);
                long stopTime = System.currentTimeMillis();
                if (stopTime < startTime + 120000L) continue;
                this.throwWaitedTooLongError();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        this.writeLockOwner = currentThread;
        this.writeLockerHadReadLockCount = readLockCount = (Integer)this.readLockOwners.remove(currentThread);
        while (this.readLockOwners.size() > 0) {
            try {
                long startTime = System.currentTimeMillis();
                this.wait(120000L);
                long stopTime = System.currentTimeMillis();
                if (stopTime < startTime + 120000L) continue;
                this.writeLockOwner = null;
                NLogger.error(ReadWriteLock.class, (Object)"Waited too long to ensure write lock.");
                throw new RuntimeException("Waited too long to ensure write lock.");
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            currentThread.interrupt();
        }
    }

    public synchronized void writeUnlock() throws IllegalAccessException {
        Thread currentThread = Thread.currentThread();
        if (this.writeLockOwner != currentThread) {
            throw new IllegalAccessException("Current thread not owner of write lock.");
        }
        this.writeLockOwner = null;
        if (this.writeLockerHadReadLockCount != null) {
            this.readLockOwners.put(currentThread, this.writeLockerHadReadLockCount);
        }
        this.notifyAll();
    }

    public void assertWriteLock() throws IllegalAccessException {
        Thread currentThread = Thread.currentThread();
        if (this.writeLockOwner != currentThread) {
            throw new IllegalAccessException("Current thread not owner of write lock.");
        }
    }

    private void throwWaitedTooLongError() {
        NLogger.error(ReadWriteLock.class, (Object)("Waited too long to aquire lock. WriteOwner: " + this.writeLockOwner));
        if (this.writeLockOwner != null) {
            StackTraceElement[] stack = this.writeLockOwner.getStackTrace();
            for (int i = 0; i < 5 && i < stack.length; ++i) {
                NLogger.error(ReadWriteLock.class, (Object)("Stack: " + stack[i]));
            }
        }
        throw new RuntimeException("Waited too long to aquire lock.");
    }
}

