/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.ExpiryDate;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.event.ContainerEvent;
import phex.prefs.core.SecurityPrefs;
import phex.security.AccessType;
import phex.security.IpCidrPair;
import phex.security.IpPortAddress;
import phex.security.IpPortSystemRuleList;
import phex.security.IpSecurityRule;
import phex.security.IpSystemRuleList;
import phex.security.IpSystemSecurityRule;
import phex.security.IpUserSecurityRule;
import phex.security.SecurityRule;
import phex.servent.Servent;
import phex.share.SharedResource;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.security.DIpAccessRule;
import phex.xml.sax.security.DSecurity;
import phex.xml.sax.security.DSecurityRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhexSecurityManager
extends AbstractLifeCycle {
    private static final String[] SHA1_FILES = new String[]{"BearShare and LimeWire Pro scams and worms.SHA1", "Fakes.SHA1", "SPAM - 0-8K bytes - How2 [open with notepad.avi].SHA1", "SPAM - 15,872, 70-170K bytes - EFreeClub.SHA1", "SPAM - 22 bytes - Empty zip files.SHA1", "SPAM - Various.SHA1", "TROJAN - 50-80K bytes - ISTbar.SHA1", "TROJAN - 61-62K bytes - Mainpean StarDialer.SHA1", "TROJAN - 81,964 bytes - WinVBIE Toolbar.SHA1", "TROJAN - 233472 bytes - Dropper.Generic.DZD.SHA1", "TROJAN - 783843 bytes - Crypt.B.SHA1", "WORM - 71,070 bytes - W32.Alcra.C.SHA1", "WORM - 123897 bytes - GEDZAC VBS-Israfel.SHA1", "WORM - 178861 bytes - IRC.Backdoor.SdBot.LFI.SHA1", "WORM - 202477 bytes - Generic.FX!CME-24.SHA1", "WORM - 535082 bytes - W32.Alcra.D.SHA1", "WORM - 643767 bytes - VB.FL.SHA1", "WORM - 872159 bytes - VB.CC.SHA1", "Phex Collected.SHA1"};
    private ArrayList<IpSecurityRule> ipAccessRuleList = new ArrayList();
    private final IpSystemRuleList ipSystemRuleList = new IpSystemRuleList();
    private final IpSystemRuleList ipUserRuleList = new IpSystemRuleList();
    private final Set<String> blockedUrnSet = new HashSet<String>();
    private final HashMap<SharedResource, IpPortSystemRuleList> eligibleIpListMap = new HashMap();

    public void addIpSystemRuleListToSharedResource(Object key, String IpAddressStr, int port) {
        int ip = AddressUtils.parseDottedIpToInt(IpAddressStr);
        IpSystemSecurityRule rule = new IpSystemSecurityRule(ip, 32);
        IpPortSystemRuleList rulesList = this.eligibleIpListMap.get(key);
        if (rulesList == null) {
            rulesList = new IpPortSystemRuleList();
            this.eligibleIpListMap.put((SharedResource)key, rulesList);
        }
        rulesList.add(new IpPortAddress(IpAddressStr, port), rule);
    }

    public void removeIpSystemRuleListFromSharedResource(Object key) {
        IpPortSystemRuleList rulesList = this.eligibleIpListMap.get(key);
        if (rulesList != null) {
            this.eligibleIpListMap.remove(key);
            rulesList.removeAll();
        }
    }

    public boolean isEligibleIpAddress(byte[] hostIP, Object key) {
        IpPortSystemRuleList rulesList = null;
        IpCidrPair checkPair = null;
        if (hostIP != null) {
            checkPair = new IpCidrPair(AddressUtils.byteIpToIntIp(hostIP));
        }
        if ((rulesList = this.eligibleIpListMap.get(key)) == null) {
            return true;
        }
        if (checkPair == null) {
            return false;
        }
        return rulesList.containsRuleAndPort(checkPair, new IpPortAddress(hostIP));
    }

    public AccessType controlUrnAccess(URN urn) {
        if (urn.isSha1Nid() && this.blockedUrnSet.contains(urn.getSHA1Nss())) {
            return AccessType.ACCESS_STRONGLY_DENIED;
        }
        return AccessType.ACCESS_GRANTED;
    }

    private void loadHostileSha1List() {
        if (!SecurityPrefs.LoadHostileSha1List.get().booleanValue()) {
            return;
        }
        try {
            NLogger.debug(PhexSecurityManager.class, (Object)"Load hostile sha1 files.");
            long start = System.currentTimeMillis();
            for (int i = 0; i < SHA1_FILES.length; ++i) {
                String line;
                BufferedReader br;
                InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/sha1/" + SHA1_FILES[i]);
                if (inStream != null) {
                    br = new BufferedReader(new InputStreamReader(inStream));
                } else {
                    NLogger.debug(PhexSecurityManager.class, (Object)("Hostile sha1 file not found: " + SHA1_FILES[i]));
                    continue;
                }
                while ((line = br.readLine()) != null) {
                    if (StringUtils.isEmpty(line) || line.startsWith("#")) continue;
                    if (line.length() != 32) {
                        NLogger.warn(PhexSecurityManager.class, (Object)("Skip invalid line: " + line + " in " + SHA1_FILES[i]));
                        continue;
                    }
                    boolean succ = this.blockedUrnSet.add(line);
                    if (succ || !NLogger.isDebugEnabled(PhexSecurityManager.class)) continue;
                    NLogger.warn(PhexSecurityManager.class, (Object)("Found dupplicate: " + line + " in " + SHA1_FILES[i]));
                }
                br.close();
            }
            long end = System.currentTimeMillis();
            NLogger.debug(PhexSecurityManager.class, (Object)("Loaded hostile sha1 file: " + (end - start)));
        }
        catch (IOException exp) {
            NLogger.warn(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPAccessRuleCount() {
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            return this.ipAccessRuleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpSecurityRule getIPAccessRule(int index) {
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            if (index < 0 || index >= this.ipAccessRuleList.size()) {
                return null;
            }
            return this.ipAccessRuleList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpSecurityRule[] getIPAccessRulesAt(int[] indices) {
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int length = indices.length;
            IpSecurityRule[] rules = new IpSecurityRule[length];
            int listSize = this.ipAccessRuleList.size();
            for (int i = 0; i < length; ++i) {
                rules[i] = indices[i] < 0 || indices[i] >= listSize ? null : this.ipAccessRuleList.get(indices[i]);
            }
            return rules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpUserSecurityRule createIPAccessRule(String description, byte[] ip, byte cidr, boolean isDisabled, ExpiryDate expiryDate, boolean isDeletedOnExpiry) {
        int position;
        IpUserSecurityRule rule = new IpUserSecurityRule(description, ip, cidr, isDisabled, isDeletedOnExpiry, expiryDate);
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            position = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(rule);
        }
        this.ipUserRuleList.add(rule);
        this.fireSecurityRuleAdded(rule, position);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpUserSecurityRule updateIpUserSecurityRule(IpUserSecurityRule oldRule, String description, byte[] ip, byte cidr, boolean isDisabled, ExpiryDate expiryDate, boolean isDeletedOnExpiry) {
        int position;
        IpUserSecurityRule rule = new IpUserSecurityRule(description, ip, cidr, isDisabled, isDeletedOnExpiry, expiryDate);
        rule.setTriggerCount(oldRule.getTriggerCount());
        this.removeSecurityRule(oldRule);
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            position = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(rule);
        }
        this.ipUserRuleList.add(rule);
        this.fireSecurityRuleAdded(rule, position);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRule(SecurityRule rule) {
        int idx;
        ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            idx = this.ipAccessRuleList.indexOf(rule);
            if (idx != -1) {
                this.ipAccessRuleList.remove(idx);
            }
        }
        if (idx != -1) {
            this.ipUserRuleList.remove((IpSecurityRule)rule);
            this.fireSecurityRuleRemoved(rule, idx);
        }
    }

    public AccessType controlHostAddressAccess(DestAddress address) {
        IpAddress ipAddress = address.getIpAddress();
        if (ipAddress == null) {
            return AccessType.ACCESS_GRANTED;
        }
        byte[] hostIP = ipAddress.getHostIP();
        return this.controlHostIPAccess(hostIP);
    }

    public AccessType controlHostIPAccess(byte[] hostIP) {
        IpCidrPair checkPair = new IpCidrPair(AddressUtils.byteIpToIntIp(hostIP));
        boolean contains = this.ipSystemRuleList.contains(checkPair);
        if (contains) {
            return AccessType.ACCESS_STRONGLY_DENIED;
        }
        contains = this.ipUserRuleList.contains(checkPair);
        if (contains) {
            return AccessType.ACCESS_DENIED;
        }
        return AccessType.ACCESS_GRANTED;
    }

    private void loadHostileHostList(Map<String, DIpAccessRule> systemRuleMap) {
        if (!SecurityPrefs.LoadHostileHostList.get().booleanValue()) {
            return;
        }
        try {
            String line;
            BufferedReader br;
            NLogger.debug(PhexSecurityManager.class, (Object)"Load hostile hosts file.");
            long start = System.currentTimeMillis();
            InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/hostiles/i2phex-hostiles.txt");
            if (inStream != null) {
                br = new BufferedReader(new InputStreamReader(inStream));
            } else {
                NLogger.debug(PhexSecurityManager.class, (Object)"Hostile hosts file not found.");
                return;
            }
            while ((line = br.readLine()) != null) {
                byte cidr;
                int ip;
                if (line.startsWith("#") || StringUtils.isEmpty(line = line.trim())) continue;
                int slashIdx = line.indexOf(47);
                if (slashIdx == -1) {
                    ip = AddressUtils.parseDottedIpToInt(line);
                    cidr = 32;
                } else {
                    String ipStr = line.substring(0, slashIdx).trim();
                    String extensionStr = line.substring(slashIdx + 1).trim();
                    ip = AddressUtils.parseDottedIpToInt(ipStr);
                    cidr = AddressUtils.parseNetmaskToCidr(extensionStr);
                }
                IpSystemSecurityRule rule = new IpSystemSecurityRule(ip, cidr);
                DSecurityRule xjbRule = this.findSystemXJBRule(systemRuleMap, ip, cidr);
                if (xjbRule != null) {
                    rule.setTriggerCount(xjbRule.getTriggerCount());
                }
                this.ipAccessRuleList.add(rule);
                this.ipSystemRuleList.add(rule);
            }
            br.close();
            long end = System.currentTimeMillis();
            NLogger.debug(PhexSecurityManager.class, (Object)("Loaded hostile hosts file: " + (end - start)));
        }
        catch (IOException exp) {
            NLogger.warn(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
        }
    }

    private DSecurityRule findSystemXJBRule(Map<String, DIpAccessRule> systemRuleMap, int ip, byte cidr) {
        DSecurityRule xjbRule = systemRuleMap.get(AddressUtils.ip2string(ip) + "/" + cidr);
        if (xjbRule == null || !xjbRule.isSystemRule()) {
            return null;
        }
        return xjbRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecurityRuleList() {
        NLogger.debug(PhexSecurityManager.class, (Object)"Loading security rule list...");
        File securityFile = Environment.getInstance().getPhexConfigFile("security.xml");
        try {
            DPhex dPhex;
            if (securityFile.exists()) {
                FileManager fileMgr = FileManager.getInstance();
                ManagedFile managedFile = fileMgr.getReadWriteManagedFile(securityFile);
                dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            } else {
                dPhex = new DPhex();
            }
            DSecurity dSecurity = dPhex.getSecurityList();
            if (dSecurity == null) {
                NLogger.debug(PhexSecurityManager.class, (Object)"No security definition found.");
                dSecurity = new DSecurity();
            }
            ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                List<DSecurityRule> dRuleList = dSecurity.getIpAccessRuleList();
                HashMap<String, DIpAccessRule> systemRuleMap = new HashMap<String, DIpAccessRule>();
                for (DSecurityRule dRule : dRuleList) {
                    DIpAccessRule dIpRule = (DIpAccessRule)dRule;
                    if (dIpRule.hasDenyingRule() && !dIpRule.isDenyingRule()) continue;
                    if (!dRule.isSystemRule()) {
                        IpUserSecurityRule rule;
                        if (dIpRule.hasCidr()) {
                            rule = new IpUserSecurityRule(dIpRule.getDescription(), dIpRule.getIp(), dIpRule.getCidr(), dIpRule.isDisabled(), dIpRule.isDeletedOnExpiry(), dIpRule.getExpiryDate());
                            rule.setTriggerCount(dIpRule.getTriggerCount());
                            this.ipAccessRuleList.add(rule);
                            this.ipUserRuleList.add(rule);
                            continue;
                        }
                        if (dIpRule.getAddressType() == 2) {
                            rule = new IpUserSecurityRule(dIpRule.getDescription(), dIpRule.getIp(), AddressUtils.calculateCidr(dIpRule.getCompareIp()), dIpRule.isDisabled(), dIpRule.isDeletedOnExpiry(), dIpRule.getExpiryDate());
                            rule.setTriggerCount(dIpRule.getTriggerCount());
                            this.ipAccessRuleList.add(rule);
                            this.ipUserRuleList.add(rule);
                            continue;
                        }
                        if (dIpRule.getAddressType() == 1) {
                            rule = new IpUserSecurityRule(dIpRule.getDescription(), dIpRule.getIp(), 32, dIpRule.isDisabled(), dIpRule.isDeletedOnExpiry(), dIpRule.getExpiryDate());
                            rule.setTriggerCount(dIpRule.getTriggerCount());
                            this.ipAccessRuleList.add(rule);
                            this.ipUserRuleList.add(rule);
                            continue;
                        }
                        if (dIpRule.getAddressType() != 3) continue;
                        List<IpCidrPair> pairList = AddressUtils.range2cidr(dIpRule.getIp(), dIpRule.getCompareIp());
                        for (IpCidrPair pair : pairList) {
                            IpUserSecurityRule rule2 = new IpUserSecurityRule(dIpRule.getDescription(), pair.ipAddr, pair.cidr, dIpRule.isDisabled(), dIpRule.isDeletedOnExpiry(), dIpRule.getExpiryDate());
                            rule2.setTriggerCount(dIpRule.getTriggerCount());
                            this.ipAccessRuleList.add(rule2);
                            this.ipUserRuleList.add(rule2);
                        }
                        continue;
                    }
                    if (dIpRule.hasCidr()) {
                        String keyStr = AddressUtils.ip2string(dIpRule.getIp()) + "/" + String.valueOf(dIpRule.getCidr());
                        systemRuleMap.put(keyStr, dIpRule);
                        continue;
                    }
                    StringBuffer keyBuf = new StringBuffer(AddressUtils.ip2string(dIpRule.getIp()));
                    keyBuf.append("/");
                    if (dIpRule.getCompareIp() == null) {
                        keyBuf.append("32");
                    } else {
                        keyBuf.append(AddressUtils.calculateCidr(dIpRule.getCompareIp()));
                    }
                    systemRuleMap.put(keyBuf.toString(), dIpRule);
                }
                this.loadHostileHostList(systemRuleMap);
                this.ipAccessRuleList.trimToSize();
            }
        }
        catch (IOException exp) {
            NLogger.error(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecurityRuleList() {
        NLogger.debug(PhexSecurityManager.class, (Object)"Saving security rule list...");
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSecurity security = new DSecurity();
            dPhex.setSecurityList(security);
            ArrayList<IpSecurityRule> arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                for (IpSecurityRule rule : this.ipAccessRuleList) {
                    if (!rule.isSystemRule() && rule.isDeletedOnExpiry() && (rule.getExpiryDate().isExpiringEndOfSession() || rule.getExpiryDate().isExpired()) || rule.isSystemRule() && rule.getTriggerCount() == 0) continue;
                    DSecurityRule dRule = rule.createDSecurityRule();
                    security.getIpAccessRuleList().add(dRule);
                }
            }
            File securityFile = Environment.getInstance().getPhexConfigFile("security.xml");
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(securityFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
        }
        catch (IOException exp) {
            NLogger.error(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error(PhexSecurityManager.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    @Override
    public void doStart() {
        this.loadSecurityRuleList();
        this.loadHostileSha1List();
    }

    @Override
    public void doStop() {
        this.saveSecurityRuleList();
    }

    private void fireSecurityRuleAdded(SecurityRule rule, int position) {
        Servent.getInstance().getEventService().publish("phex:security/rule", new ContainerEvent(ContainerEvent.Type.ADDED, rule, this, position));
    }

    private void fireSecurityRuleRemoved(SecurityRule rule, int position) {
        Servent.getInstance().getEventService().publish("phex:security/rule", new ContainerEvent(ContainerEvent.Type.REMOVED, rule, this, position));
    }
}

