/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import phex.common.ExpiryDate;
import phex.security.SecurityRule;
import phex.xml.sax.security.DIpAccessRule;
import phex.xml.sax.security.DSecurityRule;

public abstract class AbstractSecurityRule
implements SecurityRule {
    protected String description;
    protected boolean isSystemRule;
    protected boolean isStrongFilter;
    protected boolean isDenyingRule;
    protected boolean isDisabled;
    protected int triggerCount;
    protected ExpiryDate expiryDate;
    protected boolean isDeletedOnExpiry;

    public AbstractSecurityRule(String description, boolean isDenyingRule) {
        this(description, isDenyingRule, false, false, false);
    }

    public AbstractSecurityRule(String description, boolean isDenyingRule, boolean isSystemRule, boolean isStrongFilter, boolean isDisabled) {
        this.description = description;
        this.isDenyingRule = isDenyingRule;
        this.isSystemRule = isSystemRule;
        this.isStrongFilter = isStrongFilter;
        this.isDisabled = isDisabled;
        this.expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
        this.isDeletedOnExpiry = false;
        this.triggerCount = 0;
    }

    public AbstractSecurityRule(DIpAccessRule dRule) {
        this.description = dRule.getDescription();
        this.isDenyingRule = dRule.isDenyingRule();
        this.isDisabled = dRule.isDisabled();
        long expiryTime = dRule.getExpiryDate();
        this.expiryDate = ExpiryDate.getExpiryDate(expiryTime);
        this.isDeletedOnExpiry = dRule.isDeletedOnExpiry();
        this.triggerCount = dRule.getTriggerCount();
        this.isSystemRule = false;
        this.isStrongFilter = false;
    }

    public void setDisabled(boolean isDisabled) {
        if (this.isDisabled != isDisabled) {
            this.isDisabled = isDisabled;
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        if (!this.expiryDate.equals(expiryDate)) {
            this.expiryDate = expiryDate;
        }
    }

    public ExpiryDate getExpiryDate() {
        return this.expiryDate;
    }

    public int getTriggerCount() {
        return this.triggerCount;
    }

    protected void incrementTriggerCount() {
        ++this.triggerCount;
    }

    public void setTriggerCount(int count) {
        this.triggerCount = count;
    }

    public boolean isDenyingRule() {
        return this.isDenyingRule;
    }

    public void setDenyingRule(boolean isDenyingRule) {
        if (this.isDenyingRule != isDenyingRule) {
            this.isDenyingRule = isDenyingRule;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        if (!this.description.equals(aDescription)) {
            this.description = aDescription;
        }
    }

    public void setDeleteOnExpiry(boolean isDeletedOnExpiry) {
        if (this.isDeletedOnExpiry != isDeletedOnExpiry) {
            this.isDeletedOnExpiry = isDeletedOnExpiry;
        }
    }

    public boolean isDeletedOnExpiry() {
        return this.isDeletedOnExpiry;
    }

    public void setSystemRule(boolean isSystemRule) {
        if (this.isSystemRule != isSystemRule) {
            this.isSystemRule = isSystemRule;
        }
    }

    public boolean isSystemRule() {
        return this.isSystemRule;
    }

    public void setStrongFilter(boolean isStrongFilter) {
        if (this.isStrongFilter != isStrongFilter) {
            this.isStrongFilter = isStrongFilter;
        }
    }

    public boolean isStrongFilter() {
        return this.isStrongFilter;
    }

    public int hashCode() {
        int PRIME = 89;
        int result = 1;
        result = 89 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 89 * result + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = 89 * result + (this.isDeletedOnExpiry ? 1231 : 1237);
        result = 89 * result + (this.isDenyingRule ? 1231 : 1237);
        result = 89 * result + (this.isDisabled ? 1231 : 1237);
        result = 89 * result + (this.isStrongFilter ? 1231 : 1237);
        result = 89 * result + (this.isSystemRule ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSecurityRule other = (AbstractSecurityRule)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expiryDate == null ? other.expiryDate != null : !this.expiryDate.equals(other.expiryDate)) {
            return false;
        }
        if (this.isDeletedOnExpiry != other.isDeletedOnExpiry) {
            return false;
        }
        if (this.isDenyingRule != other.isDenyingRule) {
            return false;
        }
        if (this.isDisabled != other.isDisabled) {
            return false;
        }
        if (this.isStrongFilter != other.isStrongFilter) {
            return false;
        }
        return this.isSystemRule == other.isSystemRule;
    }

    public abstract DSecurityRule createDSecurityRule();
}

