/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.consequence;

import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.query.Search;
import phex.rules.consequence.Consequence;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.utils.StringUtils;
import phex.xml.sax.rules.DConsequence;
import phex.xml.sax.rules.DDownloadFileConsequence;

public class DownloadFileConsequence
implements Consequence {
    public static final DownloadFileConsequence INSTANCE = new DownloadFileConsequence();
    private static final DDownloadFileConsequence DELEMENT = new DDownloadFileConsequence();

    public void invoke(Search search, RemoteFile remoteFile, Servent servent) {
        URN urn = remoteFile.getURN();
        if (urn == null) {
            return;
        }
        SwarmingManager swarmingMgr = Servent.getInstance().getDownloadService();
        if (swarmingMgr.isURNDownloaded(urn)) {
            return;
        }
        SharedFilesService fileService = Servent.getInstance().getSharedFilesService();
        if (fileService.isURNShared(urn)) {
            return;
        }
        remoteFile.setInDownloadQueue(true);
        RemoteFile dfile = new RemoteFile(remoteFile);
        String searchTerm = StringUtils.createNaturalSearchTerm(dfile.getFilename());
        swarmingMgr.addFileToDownload(dfile, dfile.getFilename(), searchTerm);
    }

    public Object clone() {
        return INSTANCE;
    }

    public DConsequence createDConsequence() {
        return DELEMENT;
    }
}

