/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.TimerTask;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.query.BackgroundSearchContainer;
import phex.query.DynamicQueryEngine;
import phex.query.DynamicQueryWorker;
import phex.query.SearchContainer;
import phex.rules.SearchFilterRules;
import phex.servent.Servent;

public class QueryManager
extends AbstractLifeCycle {
    private final Servent servent;
    private final SearchContainer searchContainer;
    private final BackgroundSearchContainer backgroundSearchContainer;
    private final SearchFilterRules searchFilterRules;
    private final DynamicQueryWorker dynamicQueryWorker;

    public QueryManager(Servent servent) {
        this.servent = servent;
        this.searchContainer = new SearchContainer(servent);
        servent.getMessageService().addMessageSubscriber(QueryResponseMsg.class, this.searchContainer);
        this.backgroundSearchContainer = new BackgroundSearchContainer(servent);
        servent.getMessageService().addMessageSubscriber(QueryResponseMsg.class, this.backgroundSearchContainer);
        this.searchFilterRules = new SearchFilterRules();
        this.dynamicQueryWorker = new DynamicQueryWorker();
    }

    protected void doStart() {
        this.searchFilterRules.load();
        this.dynamicQueryWorker.startQueryWorker();
        Environment.getInstance().scheduleTimerTask(new ExpiredSearchCheckTimer(), 5000L, 5000L);
    }

    public void doStop() {
        this.searchFilterRules.save();
    }

    public SearchContainer getSearchContainer() {
        return this.searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer() {
        return this.backgroundSearchContainer;
    }

    public void removeHostQueries(Host host) {
        if (host.isUltrapeerLeafConnection()) {
            this.dynamicQueryWorker.removeDynamicQuerysForHost(host);
        }
    }

    public DynamicQueryEngine sendDynamicQuery(QueryMsg query, int desiredResults) {
        DynamicQueryEngine engine = new DynamicQueryEngine(query, desiredResults, this.servent.getHostService().getNetworkHostsContainer(), this.servent.getMessageService());
        this.dynamicQueryWorker.addDynamicQueryEngine(engine);
        return engine;
    }

    public DynamicQueryEngine sendMyQuery(QueryMsg queryMsg) {
        return this.servent.getMessageService().sendQuery(queryMsg);
    }

    public SearchFilterRules getSearchFilterRules() {
        return this.searchFilterRules;
    }

    private class ExpiredSearchCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5000L;

        private ExpiredSearchCheckTimer() {
        }

        public void run() {
            try {
                long currentTime = System.currentTimeMillis();
                QueryManager.this.searchContainer.stopExpiredSearches(currentTime);
                QueryManager.this.backgroundSearchContainer.stopExpiredSearches(currentTime);
            }
            catch (Throwable th) {
                NLogger.error(ExpiredSearchCheckTimer.class, (Object)th, th);
            }
        }
    }
}

