/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.address.DestAddress;
import phex.common.format.HostSpeedFormatUtils;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.query.QHDConstants;
import phex.servent.Servent;
import phex.utils.VendorCodes;

public class QueryHitHost
implements QHDConstants {
    private GUID hostGUID;
    private int hostSpeed;
    private String cachedHostSpeedFormatted;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private String vendor;
    private boolean isChatSupported;
    private boolean isThexSupported;
    private boolean isBrowseHostSupported;
    private short hostRating;
    private DestAddress hostAddress;
    private DestAddress[] pushProxyAddresses;

    public QueryHitHost(GUID aHostGUID, DestAddress address, int aHostSpeed) {
        this.hostGUID = aHostGUID;
        this.hostAddress = address;
        this.hostSpeed = aHostSpeed;
        this.cachedHostSpeedFormatted = null;
        this.setQHDFlags((short)-1, (short)-1, (short)-1, (short)-1);
        this.hostRating = (short)-1;
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] pushProxyAddresses) {
        this.pushProxyAddresses = pushProxyAddresses;
    }

    public void setVendorCode(String aVendorCode) {
        if (aVendorCode != null) {
            this.vendor = VendorCodes.getVendorName(aVendorCode);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setChatSupported(boolean state) {
        this.isChatSupported = state;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setThexSupported(boolean state) {
        this.isThexSupported = state;
    }

    public boolean isThexSupported() {
        return this.isThexSupported;
    }

    public void setBrowseHostSupported(boolean state) {
        this.isBrowseHostSupported = state;
    }

    public boolean isBrowseHostSupported() {
        return this.isBrowseHostSupported;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void setHostGUID(GUID guid) {
        this.hostGUID = guid;
    }

    public int getHostSpeed() {
        return this.hostSpeed;
    }

    public String getFormattedHostSpeed() {
        if (this.cachedHostSpeedFormatted == null) {
            this.cachedHostSpeedFormatted = HostSpeedFormatUtils.formatHostSpeed(this.hostSpeed);
        }
        return this.cachedHostSpeedFormatted;
    }

    public void setHostSpeed(int speed) {
        this.hostSpeed = speed;
        this.cachedHostSpeedFormatted = null;
        this.calculateHostRating();
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(short aPushNeededFlag, short aServerBusyFlag, short aHasUploadedFlag, short aUploadSpeedFlag) {
        this.pushNeededFlag = aPushNeededFlag;
        this.serverBusyFlag = aServerBusyFlag;
        this.hasUploadedFlag = aHasUploadedFlag;
        this.uploadSpeedFlag = aUploadSpeedFlag;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == 1;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        Servent servent = Servent.getInstance();
        if (this.pushNeededFlag == 1 && servent.isFirewalled()) {
            this.hostRating = 0;
            return;
        }
        if (this.serverBusyFlag == 1) {
            this.hostRating = 1;
            return;
        }
        int tmpHostRating = this.pushNeededFlag == 1 ? (this.serverBusyFlag == 0 ? 3 : 2) : (this.pushNeededFlag == 0 ? (this.serverBusyFlag == 0 ? 6 : 5) : (servent.isFirewalled() ? 3 : 4));
        if (this.hasUploadedFlag == 1) {
            tmpHostRating = (short)(tmpHostRating + 2);
        } else if (this.hasUploadedFlag == -1) {
            tmpHostRating = (short)(tmpHostRating + 1);
        }
        this.hostRating = (short)tmpHostRating;
    }

    public static QueryHitHost createFrom(QueryResponseMsg sourceMsg) throws InvalidMessageException {
        QueryHitHost qhh = new QueryHitHost(sourceMsg.getRemoteServentID(), sourceMsg.getDestAddress(), sourceMsg.getRemoteHostSpeed());
        qhh.setQHDFlags(sourceMsg.getPushNeededFlag(), sourceMsg.getServerBusyFlag(), sourceMsg.getHasUploadedFlag(), sourceMsg.getUploadSpeedFlag());
        qhh.setVendorCode(sourceMsg.getVendorCode());
        qhh.setChatSupported(sourceMsg.isChatSupported());
        qhh.setBrowseHostSupported(sourceMsg.isBrowseHostSupported());
        qhh.setPushProxyAddresses(sourceMsg.getPushProxyAddresses());
        return qhh;
    }
}

