/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.PongCache;
import phex.common.QueryRoutingTable;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.msg.GUID;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongFactory;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.msghandling.MessageDispatcher;
import phex.msghandling.MessageRouting;
import phex.msghandling.MessageSubscriber;
import phex.msghandling.QueryMsgRoutingHandler;
import phex.query.DynamicQueryEngine;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.udp.UdpMessageEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageService
extends AbstractLifeCycle {
    private final Servent servent;
    private final MessageRouting messageRouting;
    private final MessageDispatcher messageDispatcher;
    private final QueryMsgRoutingHandler queryMsgRoutingHandler;
    private final PongFactory pongFactory;
    private UdpMessageEngine udpMsgEngine;
    private PongCache pongCache;
    private QRPUpdateTimer qrpUpdateTimer;
    private QueryRoutingTable lastSentQueryRoutingTable;
    private int numberOfTCPRedirectsSent;
    public static final int UDP_PING_PERIOD = 30000;

    public MessageService(Servent servent) {
        if (servent == null) {
            throw new NullPointerException("Servent missing.");
        }
        this.servent = servent;
        this.pongCache = new PongCache(servent);
        this.messageRouting = new MessageRouting();
        this.pongFactory = new PongFactory();
        this.messageDispatcher = new MessageDispatcher(servent, this.messageRouting, this.pongFactory);
        this.queryMsgRoutingHandler = new QueryMsgRoutingHandler(servent);
        this.messageDispatcher.addMessageSubscriber(QueryMsg.class, this.queryMsgRoutingHandler);
    }

    @Override
    public void doStart() {
        this.messageDispatcher.initStats(this.servent.getStatisticsService());
        this.qrpUpdateTimer = new QRPUpdateTimer(this.servent.getSharedFilesService());
        Environment.getInstance().scheduleTimerTask(this.qrpUpdateTimer, 10000L, 10000L);
        Environment.getInstance().scheduleTimerTask(new ResetTCPRedirectCounter(), 900000L, 900000L);
        Environment.getInstance().scheduleTimerTask(new HopsFlowTimer(), 120000L, 15000L);
    }

    public void removeRoutings(Host host) {
        this.messageRouting.removeRoutings(host);
    }

    public <T extends Message> void addMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        this.messageDispatcher.addMessageSubscriber(clazz, subscriber);
    }

    public <T extends Message> void removeMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        this.messageDispatcher.removeMessageSubscriber(clazz, subscriber);
    }

    public void dispatchMessage(Message message, Host sourceHost) {
        MsgHeader header = message.getHeader();
        switch (header.getPayload()) {
            case 0: {
                this.messageDispatcher.handlePing((PingMsg)message, sourceHost);
                break;
            }
            case 1: {
                this.messageDispatcher.handlePong((PongMsg)message, sourceHost);
                break;
            }
            case 64: {
                this.messageDispatcher.handlePushRequest((PushRequestMsg)message, sourceHost);
                break;
            }
            case -128: {
                this.messageDispatcher.handleQuery((QueryMsg)message, sourceHost);
                break;
            }
            case -127: {
                this.messageDispatcher.handleQueryResponse((QueryResponseMsg)message, sourceHost);
                break;
            }
            case 48: {
                this.messageDispatcher.handleRouteTableUpdate((RouteTableUpdateMsg)message, sourceHost);
                break;
            }
            case 49: 
            case 50: {
                this.messageDispatcher.handleVendorMessage((VendorMsg)message, sourceHost);
            }
        }
    }

    public void dropMessage(MsgHeader header, byte[] body, String reason, Host sourceHost) {
        this.messageDispatcher.dropMessage(header, body, reason, sourceHost);
    }

    public DynamicQueryEngine sendQuery(QueryMsg queryMsg) {
        this.messageRouting.checkAndAddToQueryRoutingTable(queryMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (this.servent.isUltrapeer()) {
            return this.servent.getQueryService().sendDynamicQuery(queryMsg, 200);
        }
        this.queryMsgRoutingHandler.forwardQueryToUltrapeers(queryMsg, null);
        return null;
    }

    public void forwardQueryToLeaves(QueryMsg msg, Host fromHost) {
        this.queryMsgRoutingHandler.forwardQueryToLeaves(msg, fromHost);
    }

    public boolean routePushMessage(PushRequestMsg message) {
        GUID clientGUID = message.getClientGUID();
        Host host = this.messageRouting.getPushRouting(clientGUID);
        if (host == null) {
            NLogger.debug(MessageService.class, (Object)("No PUSH route for " + clientGUID + "."));
            return false;
        }
        NLogger.debug(MessageService.class, (Object)("Push route for " + clientGUID + " is " + host));
        host.queueMessageToSend(message);
        return true;
    }

    public void pingHost(Host host) {
        this.pingHost(host, (byte)1);
    }

    public void pingHost(Host host, byte ttl) {
        PingMsg pingMsg = new PingMsg(ttl);
        this.messageRouting.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (NLogger.isDebugEnabled(MessageService.class)) {
            NLogger.debug(MessageService.class, (Object)("Queueing Ping: " + pingMsg.getDebugString() + " - " + pingMsg.getHeader().toString() + " - Host: " + host.toString()));
        }
        host.queueMessageToSend(pingMsg);
    }

    public void pingHosts(byte ttl, Host[] hosts) {
        PingMsg pingMsg = new PingMsg(ttl);
        this.messageRouting.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        this.forwardPing(pingMsg, Host.LOCAL_HOST, hosts);
    }

    private void forwardPing(PingMsg msg, Host fromHost, Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            if (hosts[i] == fromHost) continue;
            hosts[i].queueMessageToSend(msg);
        }
    }

    public void addPongToCache(PongMsg pong) {
        this.pongCache.addPong(pong);
    }

    public List<PongMsg> getCachedPongs() {
        return this.pongCache.getPongs();
    }

    public boolean requestTCPConnectBack() {
        DestAddress localAddress = this.servent.getLocalAddress();
        TCPConnectBackVMsg tcpConnectBack = new TCPConnectBackVMsg(localAddress.getPort());
        Host[] hosts = this.servent.getHostService().getUltrapeerConnections();
        int sentCount = 0;
        for (int i = 0; sentCount <= 5 && i < hosts.length; ++i) {
            if (!hosts[i].isTCPConnectBackSupported()) continue;
            hosts[i].queueMessageToSend(tcpConnectBack);
            ++sentCount;
        }
        return sentCount > 0;
    }

    public boolean isTCPRedirectAllowed() {
        return this.numberOfTCPRedirectsSent <= 3;
    }

    public void incNumberOfTCPRedirectsSent() {
        ++this.numberOfTCPRedirectsSent;
    }

    public QueryRoutingTable getLastSentQueryRoutingTable() {
        return this.lastSentQueryRoutingTable;
    }

    public void triggerQueryRoutingTableUpdate() {
        Environment.getInstance().executeOnThreadPool(this.qrpUpdateTimer, "TriggerQueryRoutingTableUpdate");
    }

    public void sendUdpPing(DestAddress address) {
        assert (this.udpMsgEngine != null) : "No UdpMessageEngine available.";
        PingMsg udpPing = PingMsg.createUdpPingMsg(Servent.getInstance().isUltrapeer());
        this.udpMsgEngine.addMessageToSend(udpPing, address);
        NLogger.debug(MessageService.class, (Object)("Sent Udp Ping to" + address + " : " + udpPing + " with Scp Byte : " + udpPing.getScpByte() != null ? String.valueOf(udpPing.getScpByte()[0]) : "null"));
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;
        private final SharedFilesService sharedFilesService;

        public QRPUpdateTimer(SharedFilesService sharedFilesService) {
            this.sharedFilesService = sharedFilesService;
        }

        public void run() {
            try {
                this.sendQueryRoutingTable();
            }
            catch (Throwable th) {
                NLogger.error(QRPUpdateTimer.class, (Object)th, th);
            }
        }

        private void sendQueryRoutingTable() {
            boolean isUltrapeer = MessageService.this.servent.isUltrapeer();
            if (!MessageService.this.servent.isShieldedLeafNode() && !isUltrapeer) {
                return;
            }
            Host[] hosts = MessageService.this.servent.getHostService().getUltrapeerConnections();
            QueryRoutingTable shareQRT = this.sharedFilesService.getLocalRoutingTable();
            QueryRoutingTable currentTable = null;
            for (int i = 0; i < hosts.length; ++i) {
                if ((!isUltrapeer ? !hosts[i].isQueryRoutingSupported() : !hosts[i].isUPQueryRoutingSupported()) || !hosts[i].isQRTableUpdateRequired()) continue;
                NLogger.debug(Host.class, (Object)("Updating QRTable for: " + hosts[i]));
                if (currentTable == null) {
                    currentTable = new QueryRoutingTable(shareQRT.getTableSize());
                    currentTable.aggregateToRouteTable(shareQRT);
                    QueryRoutingTable.fillQRTWithLeaves(currentTable, Servent.getInstance());
                    MessageService.this.lastSentQueryRoutingTable = currentTable;
                }
                QueryRoutingTable lastSentTable = hosts[i].getLastSentRoutingTable();
                Iterator<RouteTableUpdateMsg> msgIterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(currentTable, lastSentTable);
                while (msgIterator.hasNext()) {
                    RouteTableUpdateMsg msg = msgIterator.next();
                    hosts[i].queueMessageToSend(msg);
                }
                hosts[i].setLastSentRoutingTable(currentTable);
            }
        }
    }

    private class HopsFlowTimer
    extends TimerTask {
        private static final long TIMER_DELAY = 120000L;
        private static final long TIMER_PERIOD = 15000L;
        private boolean lastBusyState = false;

        private HopsFlowTimer() {
        }

        public void run() {
            try {
                if (!MessageService.this.servent.getHostService().isShieldedLeafNode()) {
                    return;
                }
                Host[] ultrapeers = MessageService.this.servent.getHostService().getUltrapeerConnections();
                boolean isHostBusy = MessageService.this.servent.isUploadLimitReached();
                int hopsFlowLimit = isHostBusy ? 0 : 5;
                HopsFlowVMsg msg = new HopsFlowVMsg(hopsFlowLimit);
                long now = System.currentTimeMillis();
                for (int i = 0; i < ultrapeers.length; ++i) {
                    if (!ultrapeers[i].isHopsFlowSupported() || isHostBusy == this.lastBusyState && !((double)ultrapeers[i].getConnectionUpTime(now) < 16500.0)) continue;
                    ultrapeers[i].queueMessageToSend(msg);
                }
                this.lastBusyState = isHostBusy;
            }
            catch (Throwable th) {
                NLogger.error(HopsFlowTimer.class, (Object)th, th);
            }
        }
    }

    private class ResetTCPRedirectCounter
    extends TimerTask {
        private static final long TIMER_PERIOD = 900000L;

        private ResetTCPRedirectCounter() {
        }

        public void run() {
            MessageService.this.numberOfTCPRedirectsSent = 0;
        }
    }
}

