/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import phex.host.Host;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.PongMsg;
import phex.msg.QueryResponseMsg;
import phex.utils.GUIDRoutingTable;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.QueryGUIDRoutingTable;

class MessageRouting {
    private final GUIDRoutingTable pingRoutingTable = new GUIDRoutingTable(120000L);
    private final QueryGUIDRoutingTable queryRoutingTable = new QueryGUIDRoutingTable(300000L);
    private final GUIDRoutingTable pushRoutingTable = new GUIDRoutingTable(420000L);

    public synchronized boolean checkAndAddToPingRoutingTable(GUID pingGUID, Host sender) {
        boolean state = this.pingRoutingTable.checkAndAddRouting(pingGUID, sender);
        return state;
    }

    public synchronized boolean checkAndAddToQueryRoutingTable(GUID queryGUID, Host sender) {
        boolean state = this.queryRoutingTable.checkAndAddRouting(queryGUID, sender);
        return state;
    }

    public synchronized void addToPushRoutingTable(GUID clientID, Host sender) {
        this.pushRoutingTable.addRouting(clientID, sender);
    }

    protected synchronized Host getPushRouting(GUID clientID) {
        return this.pushRoutingTable.findRouting(clientID);
    }

    protected synchronized Host getPingRouting(GUID pingGUID) {
        return this.pingRoutingTable.findRouting(pingGUID);
    }

    public boolean routePongMessage(PongMsg pongMessage) {
        Host host = this.getPingRouting(pongMessage.getHeader().getMsgID());
        if (host == null || host == Host.LOCAL_HOST) {
            return false;
        }
        host.queueMessageToSend(pongMessage);
        return true;
    }

    protected synchronized QueryGUIDRoutingPair getQueryRouting(GUID queryGUID, int resultCount) {
        return this.queryRoutingTable.findRoutingForQuerys(queryGUID, resultCount);
    }

    public boolean routeQueryResponse(QueryResponseMsg queryResponseMsg, Host sourceHost) throws InvalidMessageException {
        MsgHeader header = queryResponseMsg.getHeader();
        QueryGUIDRoutingPair routingPair = this.getQueryRouting(header.getMsgID(), queryResponseMsg.getUniqueResultCount());
        if (routingPair == null) {
            return false;
        }
        Host host = routingPair.getHost();
        if (host == Host.LOCAL_HOST) {
            return false;
        }
        if (routingPair.getRoutedResultCount() >= 200) {
            return false;
        }
        this.addToPushRoutingTable(queryResponseMsg.getRemoteServentID(), sourceHost);
        host.queueMessageToSend(queryResponseMsg);
        return true;
    }

    public synchronized void removeRoutings(Host host) {
        this.pingRoutingTable.removeHost(host);
        this.queryRoutingTable.removeHost(host);
        this.pushRoutingTable.removeHost(host);
    }
}

